/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.render.entity.layers;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.client.model.entity.ModelDGArmor;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerGhoulArmor
extends LayerArmorBase<ModelDGArmor> {
    private final ResourceLocation MISSING_ARMOR = new ResourceLocation("abyssalcraft:textures/armor/ghoul/missing_1.png");
    private final ResourceLocation MISSING_LEGGINGS = new ResourceLocation("abyssalcraft:textures/armor/ghoul/missing_2.png");

    public LayerGhoulArmor(RenderLivingBase<?> rendererIn) {
        super(rendererIn);
    }

    protected void func_177177_a() {
        this.field_177189_c = new ModelDGArmor(0.5f);
        this.field_177186_d = new ModelDGArmor(1.0f);
    }

    protected void setModelSlotVisible(ModelDGArmor model, EntityEquipmentSlot slot) {
        this.func_177194_a(model);
        switch (slot) {
            case FEET: {
                model.rleg.field_78806_j = true;
                model.lleg.field_78806_j = true;
                break;
            }
            case LEGS: {
                model.chestplate.field_78806_j = true;
                model.pelvis.field_78806_j = true;
                model.rleg.field_78806_j = true;
                model.lleg.field_78806_j = true;
                break;
            }
            case CHEST: {
                model.chestplate.field_78806_j = true;
                model.Spine3.field_78806_j = true;
                model.rarm1.field_78806_j = true;
                model.larm1.field_78806_j = true;
                break;
            }
            case HEAD: {
                model.Head.field_78806_j = true;
                model.jaw.field_78806_j = true;
                break;
            }
        }
    }

    protected void func_177194_a(ModelDGArmor p_177194_1_) {
        p_177194_1_.setInvisible(false);
    }

    protected ModelDGArmor getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelDGArmor model) {
        return model;
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EntityEquipmentSlot slot, String type) {
        ResourceLocation res = null;
        switch (slot) {
            case HEAD: {
                res = AbyssalCraftAPI.getGhoulHelmetTexture(stack.func_77973_b());
                if (type != null && type.equals("overlay") && res != null) {
                    String domain = res.func_110624_b();
                    String path = res.func_110623_a();
                    res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                }
                if (res != null) break;
                res = this.MISSING_ARMOR;
                break;
            }
            case CHEST: {
                res = AbyssalCraftAPI.getGhoulChestplateTexture(stack.func_77973_b());
                if (type != null && type.equals("overlay") && res != null) {
                    String domain = res.func_110624_b();
                    String path = res.func_110623_a();
                    res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                }
                if (res != null) break;
                res = this.MISSING_ARMOR;
                break;
            }
            case LEGS: {
                res = AbyssalCraftAPI.getGhoulLeggingsTexture(stack.func_77973_b());
                if (type != null && type.equals("overlay") && res != null) {
                    String domain = res.func_110624_b();
                    String path = res.func_110623_a();
                    res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                }
                if (res != null) break;
                res = this.MISSING_LEGGINGS;
                break;
            }
            case FEET: {
                res = AbyssalCraftAPI.getGhoulBootsTexture(stack.func_77973_b());
                if (type != null && type.equals("overlay") && res != null) {
                    String domain = res.func_110624_b();
                    String path = res.func_110623_a();
                    res = new ResourceLocation(domain, path.substring(0, path.length() - 4).concat("_overlay.png"));
                }
                if (res != null) break;
                res = this.MISSING_ARMOR;
                break;
            }
            default: {
                res = this.MISSING_ARMOR;
            }
        }
        return res;
    }
}

