/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.event;

import com.shinoow.abyssalcraft.api.energy.EnergyEnum;
import com.shinoow.abyssalcraft.api.energy.disruption.DisruptionEntry;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ACEvents {

    @Cancelable
    public static class DisruptionEvent
    extends Event {
        private final EnergyEnum.DeityType deity;
        private final World world;
        private final BlockPos pos;
        private final List<EntityPlayer> players;
        private final DisruptionEntry disruption;

        public DisruptionEvent(EnergyEnum.DeityType deity, World world, BlockPos pos, List<EntityPlayer> players, DisruptionEntry disruption) {
            this.deity = deity;
            this.world = world;
            this.pos = pos;
            this.players = players;
            this.disruption = disruption;
        }

        public EnergyEnum.DeityType getDeityType() {
            return this.deity;
        }

        public World getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public List<EntityPlayer> getPlayers() {
            return this.players;
        }

        public DisruptionEntry getDisruption() {
            return this.disruption;
        }
    }

    public static class RitualEvent
    extends PlayerEvent {
        private final NecronomiconRitual ritual;
        private final World world;
        private final BlockPos pos;

        public RitualEvent(EntityPlayer player, NecronomiconRitual ritual, World world, BlockPos pos) {
            super(player);
            this.ritual = ritual;
            this.world = world;
            this.pos = pos;
        }

        public NecronomiconRitual getRitual() {
            return this.ritual;
        }

        public World getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public static class Failed
        extends RitualEvent {
            private DisruptionEntry disruption;

            public Failed(EntityPlayer player, NecronomiconRitual ritual, DisruptionEntry disruption, World world, BlockPos pos) {
                super(player, ritual, world, pos);
                this.disruption = disruption;
            }

            public DisruptionEntry getDisruption() {
                return this.disruption;
            }

            public void setDisruption(DisruptionEntry disruption) {
                this.disruption = disruption;
            }
        }

        @Cancelable
        public static class Post
        extends RitualEvent {
            public Post(EntityPlayer player, NecronomiconRitual ritual, World world, BlockPos pos) {
                super(player, ritual, world, pos);
            }
        }

        @Cancelable
        public static class Pre
        extends RitualEvent {
            public Pre(EntityPlayer player, NecronomiconRitual ritual, World world, BlockPos pos) {
                super(player, ritual, world, pos);
            }
        }
    }

    public static class ItemMaterializedEvent
    extends PlayerEvent {
        private final ItemStack materialized;

        public ItemMaterializedEvent(EntityPlayer player, ItemStack crafting) {
            super(player);
            this.materialized = crafting;
        }

        public ItemStack getMaterializedStack() {
            return this.materialized;
        }
    }

    public static class ItemEngravedEvent
    extends PlayerEvent {
        private final ItemStack engraved;

        public ItemEngravedEvent(EntityPlayer player, ItemStack crafting) {
            super(player);
            this.engraved = crafting;
        }

        public ItemStack getEngravedStack() {
            return this.engraved;
        }
    }

    public static class ItemCrystallizedEvent
    extends PlayerEvent {
        private final ItemStack crystallized;

        public ItemCrystallizedEvent(EntityPlayer player, ItemStack crafting) {
            super(player);
            this.crystallized = crafting;
        }

        public ItemStack getCrystallizedStack() {
            return this.crystallized;
        }
    }

    public static class ItemTransmutedEvent
    extends PlayerEvent {
        private final ItemStack transmuted;

        public ItemTransmutedEvent(EntityPlayer player, ItemStack crafting) {
            super(player);
            this.transmuted = crafting;
        }

        public ItemStack getTransmutedStack() {
            return this.transmuted;
        }
    }
}

