/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.energy.structure;

import com.shinoow.abyssalcraft.api.energy.structure.IPlaceOfPower;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureHandler {
    private final List<IPlaceOfPower> structures = new ArrayList<IPlaceOfPower>();
    private final Logger logger = LogManager.getLogger((String)"StructureHandler");
    private static final StructureHandler instance = new StructureHandler();

    public static StructureHandler instance() {
        return instance;
    }

    public void registerStructure(IPlaceOfPower place) {
        for (IPlaceOfPower entry : this.structures) {
            if (!place.getIdentifier().equals(entry.getIdentifier())) continue;
            this.logger.log(Level.ERROR, "Place of Power already registered: {}", (Object)place.getIdentifier());
            return;
        }
        this.structures.add(place);
    }

    public List<IPlaceOfPower> getStructures() {
        return this.structures;
    }

    public IPlaceOfPower getStructureByName(String name) {
        for (IPlaceOfPower str : this.structures) {
            if (!str.getIdentifier().equals(name)) continue;
            return str;
        }
        return null;
    }

    public boolean tryFormStructure(World world, BlockPos pos, int booktype, EntityPlayer player) {
        for (IPlaceOfPower place : this.structures) {
            if (booktype < place.getBookType() || !place.canConstruct(world, pos, player)) continue;
            if (!world.field_72995_K) {
                place.construct(world, pos);
            }
            return true;
        }
        return false;
    }
}

