/*
 * Decompiled with CFR 0.152.
 */
package primal_tech.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import primal_tech.ModBlocks;
import primal_tech.PrimalTech;
import primal_tech.recipes.ClayKilnRecipes;
import primal_tech.tiles.TileEntityKiln;

public class BlockClayKiln
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool FIRED = PropertyBool.func_177716_a((String)"fired");

    public BlockClayKiln() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)FIRED, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(PrimalTech.TAB);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this.func_176201_c(state) < 8) {
            return Item.func_150898_a((Block)this);
        }
        if (this.func_176201_c(state) >= 8) {
            return Items.field_151118_aC;
        }
        return null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityKiln();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)FIRED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)FIRED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)FIRED, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, FIRED});
    }

    public void setState(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            TileEntityKiln tile = (TileEntityKiln)world.func_175625_s(pos);
            IBlockState state = world.func_180495_p(pos);
            world.func_180501_a(pos, ModBlocks.CLAY_KILN.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)FIRED, (Comparable)Boolean.valueOf(true)), 3);
            if (tile != null) {
                tile.func_145829_t();
                world.func_175690_a(pos, (TileEntity)tile);
                tile.setActive(true);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack stack = player.func_184614_ca();
        if (world.func_175625_s(pos) instanceof TileEntityKiln) {
            ItemStack stack2;
            int activeSlot;
            TileEntityKiln tile = (TileEntityKiln)world.func_175625_s(pos);
            int n = activeSlot = !tile.func_70301_a(1).func_190926_b() ? 1 : 0;
            if (!stack.func_190926_b() && tile.func_70301_a(0).func_190926_b() && tile.func_70301_a(1).func_190926_b()) {
                if (!world.field_72995_K) {
                    ItemStack stackInput = new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i());
                    if (stack.func_77942_o()) {
                        stackInput.func_77982_d(stack.func_77978_p());
                    }
                    tile.func_70299_a(0, stackInput);
                    tile.setCookingDuration(0);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    if (!world.field_72995_K) {
                        tile.markForUpdate();
                    }
                    return true;
                }
            } else if (!world.field_72995_K && !(stack2 = tile.func_70301_a(activeSlot)).func_190926_b()) {
                if (stack2 == ClayKilnRecipes.getOutput(stack2) && activeSlot == 1) {
                    EntityXPOrb orb = new EntityXPOrb(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1);
                    world.func_72838_d((Entity)orb);
                }
                if (!player.field_71071_by.func_70441_a(stack2)) {
                    ForgeHooks.onPlayerTossEvent((EntityPlayer)player, (ItemStack)stack2, (boolean)false);
                }
                tile.func_70299_a(activeSlot, ItemStack.field_190927_a);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.5f, 2.0f);
                tile.markForUpdate();
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityKiln tile = (TileEntityKiln)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(world, pos, state);
    }
}

