/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.node;

import buildcraft.lib.client.guide.font.IFontRenderer;
import buildcraft.lib.client.guide.node.FormatSegment;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.TextFormatting;

public class FormatString {
    private static final String WORD_GAP = " \n\t";
    private static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    public final FormatSegment[] segments;
    private final String unformatted;
    private final String formatted;

    public FormatString(FormatSegment[] segments) {
        this.segments = segments;
        String s = "";
        String sf = "";
        for (FormatSegment seg : segments) {
            s = s + seg.text;
            sf = sf + seg.toFormatString();
        }
        this.unformatted = s;
        this.formatted = sf;
    }

    public String getFormatted() {
        return this.formatted;
    }

    public String getUnformatted() {
        return this.unformatted;
    }

    public static FormatString split(String formattedText) {
        ArrayList<FormatSegment> segments = new ArrayList<FormatSegment>();
        TextFormatting lastColour = null;
        EnumSet<TextFormatting> lastMisc = EnumSet.noneOf(TextFormatting.class);
        int lastEnd = 0;
        Matcher matcher = FORMATTING_CODE_PATTERN.matcher(formattedText);
        while (matcher.find()) {
            int start = matcher.start();
            if (start != lastEnd) {
                String subText = formattedText.substring(lastEnd, start);
                ImmutableSet miscCopy = ImmutableSet.copyOf(lastMisc);
                segments.add(new FormatSegment(subText, lastColour, (Set<TextFormatting>)miscCopy));
            }
            String matched = matcher.group();
            TextFormatting format = null;
            for (TextFormatting f : TextFormatting.values()) {
                if (!f.toString().equals(matched)) continue;
                format = f;
                break;
            }
            if (format != null) {
                if (format == TextFormatting.RESET) {
                    lastColour = null;
                    lastMisc.clear();
                } else if (format.func_96302_c()) {
                    lastColour = format;
                } else {
                    lastMisc.add(format);
                }
            }
            lastEnd = matcher.end();
        }
        if (lastEnd != formattedText.length()) {
            String subText = formattedText.substring(lastEnd);
            ImmutableSet miscCopy = ImmutableSet.copyOf(lastMisc);
            segments.add(new FormatSegment(subText, lastColour, (Set<TextFormatting>)miscCopy));
        }
        return new FormatString(segments.toArray(new FormatSegment[0]));
    }

    public FormatString[] wrap(IFontRenderer font, int maxWidth) {
        return this.wrap(font, maxWidth, true);
    }

    public FormatString[] wrap(IFontRenderer font, int maxWidth, boolean onWords) {
        ArrayList<FormatSegment> thisLine = new ArrayList<FormatSegment>();
        int widthUsed = 0;
        for (int segmentIndex = 0; segmentIndex < this.segments.length; ++segmentIndex) {
            int i;
            FormatSegment segment = this.segments[segmentIndex];
            int width = font.getStringWidth(segment.toFormatString());
            if (width + widthUsed <= maxWidth) {
                thisLine.add(segment);
                widthUsed += width;
                continue;
            }
            String text = segment.toFormatString();
            int allowedLength = 1;
            boolean words = onWords;
            block1: while (true) {
                for (i = text.length(); i > 1; --i) {
                    String subText;
                    int w;
                    String c = text.substring(i - 1, i);
                    if (words && !WORD_GAP.contains(c) || (w = font.getStringWidth(subText = text.substring(0, i))) + widthUsed > maxWidth) continue;
                    allowedLength = i;
                    break block1;
                }
                if (!words || segmentIndex != 0) break;
                words = false;
            }
            i = allowedLength;
            if (i > 1) {
                String subText = text.substring(0, allowedLength);
                int left = this.segments.length - segmentIndex;
                FormatSegment[] next = new FormatSegment[left];
                thisLine.add(new FormatSegment(subText, segment.colour, segment.misc));
                next[0] = new FormatSegment(text.substring(i), segment.colour, segment.misc);
                for (int j = 1; j < left; ++j) {
                    next[j] = this.segments[segmentIndex + j];
                }
                return new FormatString[]{new FormatString(thisLine.toArray(new FormatSegment[0])), new FormatString(next)};
            }
            int left = this.segments.length - segmentIndex;
            FormatSegment[] next = new FormatSegment[left];
            for (int j = 0; j < left; ++j) {
                next[j] = this.segments[j + 1];
            }
            return new FormatString[]{new FormatString(thisLine.toArray(new FormatSegment[0])), new FormatString(next)};
        }
        return new FormatString[]{this};
    }
}

