/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker;

import buildcraft.core.BCCoreConfig;
import buildcraft.core.client.BuildCraftLaserManager;
import buildcraft.core.marker.PathCache;
import buildcraft.core.marker.PathConnection;
import buildcraft.core.marker.PathSavedData;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.marker.MarkerCache;
import buildcraft.lib.marker.MarkerSubCache;
import buildcraft.lib.net.MessageMarker;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class PathSubCache
extends MarkerSubCache<PathConnection> {
    public PathSubCache(World world) {
        super(world, MarkerCache.CACHES.indexOf(PathCache.INSTANCE));
        PathSavedData data = (PathSavedData)world.getPerWorldStorage().func_75742_a(PathSavedData.class, "buildcraft_marker_path");
        if (data == null) {
            data = new PathSavedData();
            world.getPerWorldStorage().func_75745_a("buildcraft_marker_path", (WorldSavedData)data);
        }
        data.loadInto(this);
    }

    @Override
    public boolean tryConnect(BlockPos from, BlockPos to) {
        PathConnection conFrom = (PathConnection)this.getConnection(from);
        PathConnection conTo = (PathConnection)this.getConnection(to);
        if (conFrom == null) {
            if (conTo == null) {
                return PathConnection.tryCreateConnection(this, from, to);
            }
            return conTo.addMarker(from, to);
        }
        if (conTo == null) {
            return conFrom.addMarker(from, to);
        }
        return conFrom.mergeWith(conTo, from, to);
    }

    @Override
    public boolean canConnect(BlockPos from, BlockPos to) {
        PathConnection conFrom = (PathConnection)this.getConnection(from);
        PathConnection conTo = (PathConnection)this.getConnection(to);
        if (conFrom == null) {
            if (conTo == null) {
                return true;
            }
            return conTo.canAddMarker(from, to);
        }
        if (conTo == null) {
            return conFrom.canAddMarker(from, to);
        }
        return conFrom.canMergeWith(conTo, from, to);
    }

    @Override
    public ImmutableList<BlockPos> getValidConnections(BlockPos from) {
        ImmutableList.Builder list = ImmutableList.builder();
        int maxLengthSquared = BCCoreConfig.markerMaxDistance * BCCoreConfig.markerMaxDistance;
        for (BlockPos pos : this.getAllMarkers()) {
            if (pos.equals((Object)from) || pos.func_177951_i((Vec3i)from) > (double)maxLengthSquared || !this.canConnect(from, pos) && !this.canConnect(pos, from)) continue;
            list.add((Object)pos);
        }
        return list.build();
    }

    @Override
    public LaserData_BC8.LaserType getPossibleLaserType() {
        return BuildCraftLaserManager.MARKER_PATH_POSSIBLE;
    }

    @Override
    protected boolean handleMessage(MessageMarker message) {
        List<BlockPos> positions = message.positions;
        if (message.connection) {
            if (message.add) {
                for (BlockPos p : positions) {
                    PathConnection existing = (PathConnection)this.getConnection(p);
                    this.destroyConnection(existing);
                }
                PathConnection con = new PathConnection(this, positions);
                this.addConnection(con);
            } else {
                for (BlockPos p : positions) {
                    PathConnection existing = (PathConnection)this.getConnection(p);
                    if (existing == null) continue;
                    existing.removeMarker(p);
                    this.refreshConnection(existing);
                }
            }
        }
        return false;
    }
}

