/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.api.indlog.filter.FluidFilterProvider;
import cd4017be.api.indlog.pipe.IFluidPipeCon;
import cd4017be.indlog.filter.DummyFilter;
import cd4017be.indlog.tileentity.Pipe;
import cd4017be.lib.capability.LinkedTank;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPipe
extends Pipe<FluidPipe, FluidStack, IFluidHandler> {
    public static int CAP;
    public static int TICKS;
    protected final IFluidHandler access = new LinkedTank(CAP, this::getFluid, this::setFluid);
    protected final IFluidHandler accessF = new Tank(CAP, this::getFluid, this::setFluid);

    public FluidPipe() {
    }

    public FluidPipe(IBlockState state) {
        super(state);
    }

    @Override
    protected Class<FluidPipe> pipeClass() {
        return FluidPipe.class;
    }

    @Override
    protected Capability<IFluidHandler> capability() {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    protected int resetTimer() {
        return TICKS;
    }

    @Override
    protected IFluidHandler getInv(boolean filtered) {
        return filtered ? this.accessF : this.access;
    }

    private FluidStack getFluid() {
        return (FluidStack)this.content;
    }

    private void setFluid(FluidStack fluid) {
        this.content = fluid;
        this.func_70296_d();
    }

    @Override
    protected byte conDir(TileEntity te, EnumFacing side) {
        return te instanceof IFluidPipeCon ? ((IFluidPipeCon)te).getFluidConnectDir(side) : (byte)0;
    }

    @Override
    protected boolean transferOut(IFluidHandler acc) {
        int m;
        if (this.filter == null || this.filter.noEffect() ? (((FluidStack)this.content).amount -= acc.fill((FluidStack)this.content, true)) > 0 : (m = this.filter.insertAmount(this.content, (Object)acc)) <= 0 || (((FluidStack)this.content).amount -= acc.fill(new FluidStack((FluidStack)this.content, m), true)) > 0) {
            return false;
        }
        this.content = null;
        this.func_70296_d();
        return true;
    }

    @Override
    protected boolean transferIn(IFluidHandler acc) {
        if (this.filter == null || this.filter.noEffect()) {
            if (this.content == null) {
                this.content = acc.drain(CAP, true);
                if (this.content != null) {
                    this.func_70296_d();
                }
            } else {
                int m = CAP - ((FluidStack)this.content).amount;
                if (m <= 0) {
                    return true;
                }
                FluidStack fluid = acc.drain(new FluidStack((FluidStack)this.content, m), true);
                if (fluid != null) {
                    ((FluidStack)this.content).amount += fluid.amount;
                    this.func_70296_d();
                }
            }
        } else {
            int n;
            if (this.content == null) {
                n = 0;
            } else {
                n = ((FluidStack)this.content).amount;
                if (n >= CAP) {
                    return true;
                }
            }
            FluidStack fluid = (FluidStack)this.filter.getExtract(this.content, (Object)acc);
            if (fluid == null || fluid.amount <= 0) {
                return false;
            }
            int m = CAP - n;
            if (m < fluid.amount) {
                fluid.amount = m;
            }
            fluid.amount = acc.drain((FluidStack)fluid, (boolean)true).amount + n;
            this.content = fluid;
            this.func_70296_d();
        }
        return false;
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing dir, float X, float Y, float Z) {
        if (super.onActivated(player, hand, item, dir, X, Y, Z)) {
            return true;
        }
        if (this.filter != null && !player.func_70093_af() && item.func_190916_E() == 0) {
            player.func_184611_a(hand, this.filter.getItemStack());
            this.filter = null;
            this.flow = (short)(this.flow | 0x8000);
            this.markUpdate();
            this.func_70296_d();
            return true;
        }
        if (this.filter == null && this.type != 0 && item.func_77973_b() instanceof FluidFilterProvider && (this.filter = ((FluidFilterProvider)item.func_77973_b()).getFluidFilter(item)) != null) {
            this.flow = (short)(this.flow & Short.MAX_VALUE);
            item.func_190917_f(-1);
            player.func_184611_a(hand, item);
            this.markUpdate();
            this.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        if (this.filter != null) {
            nbt.func_74782_a("filter", (NBTBase)this.filter.writeNBT());
        }
        if (this.content != null) {
            nbt.func_74782_a("fluid", (NBTBase)((FluidStack)this.content).writeToNBT(new NBTTagCompound()));
        }
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.filter = nbt.func_74764_b("filter") ? FluidFilterProvider.load((NBTTagCompound)nbt.func_74775_l("filter")) : null;
        this.content = nbt.func_74764_b("fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fluid")) : null;
    }

    @Override
    protected boolean onDataPacket(NBTTagCompound nbt) {
        this.content = nbt.func_150297_b("fl", 10) ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("fl")) : null;
        byte f = nbt.func_74771_c("filt");
        if (f == -1 ^ this.filter != null) {
            return false;
        }
        this.filter = f == -1 ? null : new DummyFilter(f);
        return true;
    }

    @Override
    protected void getUpdatePacket(NBTTagCompound nbt) {
        nbt.func_74774_a("filt", (byte)(this.filter == null ? -1 : (this.filter.blocking() ? 2 : 0)));
        if (this.last != null) {
            nbt.func_74782_a("fl", (NBTBase)((FluidStack)this.last).writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List<ItemStack> list = super.dropItem(state, fortune);
        if (this.filter != null) {
            list.add(this.filter.getItemStack());
        }
        return list;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && !this.cover.opaque;
    }

    private class Tank
    extends LinkedTank {
        public Tank(int cap, Supplier<FluidStack> get, Consumer<FluidStack> set) {
            super(cap, get, set);
        }

        public int fill(FluidStack res, boolean doFill) {
            if ((FluidPipe.this.type & 1) == 0 && (FluidPipe.this.filter == null || FluidPipe.this.filter.matches((Object)res))) {
                return super.fill(res, doFill);
            }
            return 0;
        }

        public FluidStack drain(FluidStack res, boolean doDrain) {
            if (FluidPipe.this.content != null && (FluidPipe.this.type & 1) != 0 && (FluidPipe.this.filter == null || FluidPipe.this.filter.matches(FluidPipe.this.content))) {
                return super.drain(res, doDrain);
            }
            return null;
        }

        public FluidStack drain(int m, boolean doDrain) {
            if (FluidPipe.this.content != null && (FluidPipe.this.type & 1) != 0 && (FluidPipe.this.filter == null || FluidPipe.this.filter.matches(FluidPipe.this.content))) {
                return super.drain(m, doDrain);
            }
            return null;
        }
    }
}

