/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.tileentity;

import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.SaferFakePlayer;
import cd4017be.lib.util.TooltipUtil;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BlockPlacer
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
IItemHandler,
AdvancedBlock.ITilePlaceHarvest,
AdvancedBlock.IInteractiveTile {
    public static int RANGE = 15;
    public int dx;
    public int dy;
    public int dz;
    private GameProfile gp = new GameProfile(new UUID(0L, 0L), "dummyPlayer");
    private float yaw;
    private float pitch;
    private float rX;
    private float rY;
    private float rZ;
    private boolean sneaking;
    private FakePlayer player;
    private ItemStack item = ItemStack.field_190927_a;

    private ItemStack place(BlockPos pos, ItemStack item) {
        if (this.player == null) {
            this.initializePlayer();
        }
        EnumHand hand = EnumHand.MAIN_HAND;
        this.player.func_70107_b((double)((float)pos.func_177958_n() + this.rX), (double)((float)pos.func_177956_o() + this.rY), (double)((float)pos.func_177952_p() + this.rZ));
        this.player.func_184611_a(hand, item);
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        RayTraceResult res = this.rayTrace(state, pos);
        PlayerInteractEvent.RightClickBlock event = ForgeHooks.onRightClickBlock((EntityPlayer)this.player, (EnumHand)hand, (BlockPos)pos, (EnumFacing)res.field_178784_b, (Vec3d)res.field_72307_f);
        if (!(event.isCanceled() || item.onItemUseFirst((EntityPlayer)this.player, this.field_145850_b, pos, hand, res.field_178784_b, (float)res.field_72307_f.field_72450_a, (float)res.field_72307_f.field_72448_b, (float)res.field_72307_f.field_72449_c) != EnumActionResult.PASS || (!this.sneaking || item.func_77973_b().doesSneakBypassUse(item, (IBlockAccess)this.field_145850_b, pos, (EntityPlayer)this.player) || event.getUseBlock() == Event.Result.ALLOW) && event.getUseBlock() != Event.Result.DENY && state.func_177230_c().func_180639_a(this.field_145850_b, pos, state, (EntityPlayer)this.player, hand, res.field_178784_b, (float)res.field_72307_f.field_72450_a, (float)res.field_72307_f.field_72448_b, (float)res.field_72307_f.field_72449_c) && event.getUseItem() != Event.Result.ALLOW || item.func_190926_b() || event.getUseItem() == Event.Result.DENY)) {
            ItemStack copy = item.func_77946_l();
            item.func_179546_a((EntityPlayer)this.player, this.field_145850_b, pos, hand, res.field_178784_b, (float)res.field_72307_f.field_72450_a, (float)res.field_72307_f.field_72448_b, (float)res.field_72307_f.field_72449_c);
            if (item.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)this.player, (ItemStack)copy, (EnumHand)hand);
            }
        }
        item = this.player.func_184586_b(hand);
        this.player.func_184611_a(hand, ItemStack.field_190927_a);
        this.player.field_71071_by.func_70436_m();
        return item;
    }

    private RayTraceResult rayTrace(IBlockState state, BlockPos pos) {
        double t1;
        EnumFacing side;
        double t;
        Vec3d p1;
        Vec3d p = this.player.func_174824_e(1.0f);
        RayTraceResult res = state.func_185910_a(this.field_145850_b, pos, p, p.func_178787_e((p1 = this.player.func_70676_i(1.0f)).func_186678_a(16.0)));
        if (res != null) {
            return res;
        }
        if (p1.field_72450_a < 0.0) {
            t = (double)(-this.rX) / p1.field_72450_a;
            side = EnumFacing.EAST;
        } else {
            t = (1.0 - (double)this.rX) / p1.field_72450_a;
            side = EnumFacing.WEST;
        }
        if (p1.field_72448_b < 0.0) {
            double d;
            t1 = (double)(-this.rY) / p1.field_72448_b;
            if (d < t) {
                t = t1;
                side = EnumFacing.UP;
            }
        } else {
            double d;
            t1 = (1.0 - (double)this.rY) / p1.field_72448_b;
            if (d < t) {
                t = t1;
                side = EnumFacing.DOWN;
            }
        }
        if (p1.field_72449_c < 0.0) {
            double d;
            t1 = (double)(-this.rZ) / p1.field_72449_c;
            if (d < t) {
                t = t1;
                side = EnumFacing.SOUTH;
            }
        } else {
            double d;
            t1 = (1.0 - (double)this.rZ) / p1.field_72449_c;
            if (d < t) {
                t = t1;
                side = EnumFacing.NORTH;
            }
        }
        return new RayTraceResult(p.func_178787_e(p1.func_186678_a(t)), side);
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Orientation o = this.getOrientation();
        if (src.func_177958_n() != this.field_174879_c.func_177958_n()) {
            this.dx = o.front.func_82601_c() + MathHelper.func_76125_a((int)(this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(EnumFacing.WEST), EnumFacing.WEST) - this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(EnumFacing.EAST), EnumFacing.EAST)), (int)(-RANGE), (int)RANGE);
        }
        if (src.func_177956_o() != this.field_174879_c.func_177956_o()) {
            this.dy = o.front.func_96559_d() + MathHelper.func_76125_a((int)(this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(EnumFacing.DOWN), EnumFacing.DOWN) - this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(EnumFacing.UP), EnumFacing.UP)), (int)(-RANGE), (int)RANGE);
        }
        if (src.func_177952_p() != this.field_174879_c.func_177952_p()) {
            this.dz = o.front.func_82599_e() + MathHelper.func_76125_a((int)(this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(EnumFacing.NORTH), EnumFacing.NORTH) - this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(EnumFacing.SOUTH), EnumFacing.SOUTH)), (int)(-RANGE), (int)RANGE);
        }
    }

    public void neighborTileChange(TileEntity te, EnumFacing side) {
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.item;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.item.func_190916_E() > 0) {
            return stack;
        }
        if (!simulate) {
            this.item = this.place(this.field_174879_c.func_177982_a(this.dx, this.dy, this.dz), ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int n = this.item.func_190916_E();
        if (amount > n) {
            amount = n;
        }
        if (amount <= 0) {
            return ItemStack.field_190927_a;
        }
        if (!simulate) {
            if ((n -= amount) <= 0) {
                ItemStack stack = this.item;
                this.item = ItemStack.field_190927_a;
                return stack;
            }
            this.item.func_190920_e(n);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)this.item, (int)amount);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        return (T)((Object)(cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.gp = new GameProfile(nbt.func_186857_a("FPuuid"), nbt.func_74779_i("FPname"));
        this.item = new ItemStack(nbt.func_74775_l("item"));
        this.dx = nbt.func_74762_e("dx");
        this.dy = nbt.func_74762_e("dy");
        this.dz = nbt.func_74762_e("dz");
        this.rX = nbt.func_74760_g("rx");
        this.rY = nbt.func_74760_g("ry");
        this.rZ = nbt.func_74760_g("rz");
        this.yaw = nbt.func_74760_g("yaw");
        this.pitch = nbt.func_74760_g("pitch");
        this.sneaking = nbt.func_74767_n("sneak");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_186854_a("FPuuid", this.gp.getId());
        nbt.func_74778_a("FPname", this.gp.getName());
        nbt.func_74782_a("item", (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
        nbt.func_74768_a("dx", this.dx);
        nbt.func_74768_a("dy", this.dy);
        nbt.func_74768_a("dz", this.dz);
        nbt.func_74776_a("rx", this.rX);
        nbt.func_74776_a("ry", this.rY);
        nbt.func_74776_a("rz", this.rZ);
        nbt.func_74776_a("yaw", this.yaw);
        nbt.func_74776_a("pitch", this.pitch);
        nbt.func_74757_a("sneak", this.sneaking);
        return super.func_189515_b(nbt);
    }

    private void initializePlayer() {
        if (!(this.field_145850_b instanceof WorldServer)) {
            return;
        }
        this.player = new SaferFakePlayer((WorldServer)this.field_145850_b, this.gp);
        this.player.field_70177_z = this.yaw;
        this.player.field_70125_A = this.pitch;
        this.player.func_70095_a(this.sneaking);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        if (entity instanceof EntityPlayer) {
            this.gp = ((EntityPlayer)entity).func_146103_bH();
        }
        Orientation o = this.getOrientation();
        this.yaw = (float)(o.ordinal() & 3) * 90.0f;
        this.pitch = 90.0f - 90.0f * (float)((o.ordinal() >> 2) + 3 & 3);
        this.sneaking = false;
        this.dx = o.front.func_82601_c();
        this.dy = o.front.func_96559_d();
        this.dz = o.front.func_82599_e();
        this.rX = -2.0f * (float)this.dx + 0.5f;
        this.rY = -2.0f * (float)this.dy + 0.5f;
        this.rZ = -2.0f * (float)this.dz + 0.5f;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (!item.func_190926_b()) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        this.yaw = player.field_70177_z;
        this.pitch = player.field_70125_A;
        this.sneaking = player.func_70093_af();
        this.rX = (float)(player.field_70165_t - (double)this.field_174879_c.func_177958_n());
        this.rY = (float)(player.field_70163_u - (double)this.field_174879_c.func_177956_o());
        this.rZ = (float)(player.field_70161_v - (double)this.field_174879_c.func_177952_p());
        if (this.player == null) {
            this.initializePlayer();
        } else {
            this.player.field_70177_z = this.yaw;
            this.player.field_70125_A = this.pitch;
            this.player.func_70095_a(this.sneaking);
        }
        player.func_145747_a((ITextComponent)new TextComponentString(TooltipUtil.format((String)"cd4017be.placer.cfg", (Object[])new Object[]{Float.valueOf(this.rX), Float.valueOf(this.rY), Float.valueOf(this.rZ), Float.valueOf(this.yaw), Float.valueOf(this.pitch), this.sneaking})));
        return true;
    }

    public void onClicked(EntityPlayer player) {
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        List list = this.makeDefaultDrops(null);
        if (this.item.func_190916_E() > 0) {
            list.add(this.item);
        }
        return list;
    }
}

