/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.indlog.Objects;
import cd4017be.indlog.multiblock.IActiveCon;
import cd4017be.indlog.multiblock.ItemComp;
import cd4017be.indlog.multiblock.WarpPipeNetwork;
import cd4017be.indlog.multiblock.WarpPipeNode;
import cd4017be.lib.TickRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemExtractor
extends ItemComp
implements IActiveCon {
    public static int INTERVAL = 4;
    private int timer = Integer.MIN_VALUE;
    private int slotIdx = 0;

    public ItemExtractor(WarpPipeNode pipe, byte side) {
        super(pipe, side);
    }

    @Override
    public void enable() {
        if (this.timer < 0 && !this.pipe.invalid()) {
            this.timer = 0;
            TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
        }
    }

    @Override
    public void disable() {
        this.timer = Integer.MIN_VALUE;
    }

    public boolean tick() {
        if (++this.timer < INTERVAL) {
            return this.timer > 0;
        }
        if (this.pipe.invalid()) {
            this.disable();
            return false;
        }
        this.timer = 0;
        if (!this.isValid() || this.filter != null && !this.filter.active(this.pipe.redstone) || (this.pipe.isBlocked & 1 << this.side) != 0) {
            return true;
        }
        IItemHandler acc = (IItemHandler)this.link.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
        if (acc == null) {
            return true;
        }
        int target = -1;
        int m = acc.getSlots();
        ItemStack stack = ItemStack.field_190927_a;
        for (int i = this.slotIdx; i < this.slotIdx + m; ++i) {
            int s = i % m;
            stack = acc.extractItem(s, 65536, true);
            if (stack.func_190916_E() <= 0 || this.filter != null && (stack = (ItemStack)this.filter.getExtract((Object)stack, (Object)acc)).func_190916_E() <= 0) continue;
            target = s;
            this.slotIdx = (i + 1) % m;
            break;
        }
        m = stack.func_190916_E();
        if (target < 0 || m == 0) {
            return true;
        }
        if ((m -= ((WarpPipeNetwork)this.pipe.network).insertItem(stack, this.filter == null || !this.filter.blocking() ? (byte)127 : this.filter.priority()).func_190916_E()) > 0) {
            acc.extractItem(target, m, false);
        }
        return true;
    }

    @Override
    protected ItemStack moduleItem() {
        return new ItemStack((Item)Objects.item_pipe, 1, 2);
    }
}

