/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.indlog.multiblock;

import cd4017be.api.indlog.filter.ItemFilterProvider;
import cd4017be.api.indlog.filter.PipeFilter;
import cd4017be.indlog.multiblock.ConComp;
import cd4017be.indlog.multiblock.WarpPipeNetwork;
import cd4017be.indlog.multiblock.WarpPipeNode;
import cd4017be.indlog.tileentity.WarpPipe;
import cd4017be.lib.util.ItemFluidUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemComp
extends ConComp
implements WarpPipeNetwork.IObjLink {
    public ICapabilityProvider link;
    public PipeFilter<ItemStack, IItemHandler> filter;

    public ItemComp(WarpPipeNode pipe, byte side) {
        super(pipe, side);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("id") || nbt.func_74764_b("mode")) {
            this.filter = ItemFilterProvider.load((NBTTagCompound)nbt);
            this.pipe.hasFilters = (byte)(this.pipe.hasFilters | 1 << this.side);
        } else {
            this.pipe.hasFilters = (byte)(this.pipe.hasFilters & ~(1 << this.side));
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        if (this.filter != null) {
            nbt.func_179237_a(this.filter.writeNBT());
        }
    }

    @Override
    public boolean isValid() {
        if (this.link == null) {
            return false;
        }
        if (((TileEntity)this.link).func_145837_r()) {
            this.updateLink();
        }
        return this.link != null;
    }

    @Override
    public void updateLink() {
        this.link = ((WarpPipe)this.pipe.tile).getTileOnSide(EnumFacing.field_82609_l[this.side]);
    }

    @Override
    public boolean onClicked(EntityPlayer player, EnumHand hand, ItemStack item) {
        if (item.func_190916_E() == 0) {
            if (this.filter != null) {
                ItemFluidUtil.dropStack((ItemStack)this.filter.getItemStack(), (Entity)player);
                this.filter = null;
                ((WarpPipeNetwork)this.pipe.network).reorder(this);
                this.pipe.hasFilters = (byte)(this.pipe.hasFilters & ~(1 << this.side));
                this.pipe.isBlocked = (byte)(this.pipe.isBlocked | 1 << this.side);
                return true;
            }
            if (!player.func_70093_af()) {
                this.pipe.isBlocked = (byte)(this.pipe.isBlocked ^ 1 << this.side);
                return true;
            }
        } else if (this.filter == null && item.func_77973_b() instanceof ItemFilterProvider && (this.filter = ((ItemFilterProvider)item.func_77973_b()).getItemFilter(item)) != null) {
            item.func_190917_f(-1);
            player.func_184611_a(hand, item);
            ((WarpPipeNetwork)this.pipe.network).reorder(this);
            this.pipe.hasFilters = (byte)(this.pipe.hasFilters | 1 << this.side);
            this.pipe.isBlocked = (byte)(this.pipe.isBlocked & ~(1 << this.side));
            return true;
        }
        return super.onClicked(player, hand, item);
    }

    @Override
    public void dropContent(List<ItemStack> list) {
        if (this.filter != null) {
            list.add(this.filter.getItemStack());
        }
        super.dropContent(list);
    }

    public boolean blockItem(ItemStack item) {
        return this.filter != null && !this.filter.transfer((Object)item);
    }

    public ItemStack insertItem(ItemStack item) {
        if (this.filter != null && !this.filter.active(this.pipe.redstone) || (this.pipe.isBlocked & 1 << this.side) != 0) {
            return item;
        }
        IItemHandler acc = (IItemHandler)this.link.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[this.side ^ 1]);
        if (acc == null) {
            return item;
        }
        int n = item.func_190916_E();
        if (this.filter == null || this.filter.noEffect()) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)acc, (ItemStack)item, (boolean)false);
        }
        n = this.filter.insertAmount((Object)item, (Object)acc);
        if (n == 0) {
            return item;
        }
        if (n > item.func_190916_E()) {
            n = item.func_190916_E();
        }
        item.func_190917_f(ItemHandlerHelper.insertItemStacked((IItemHandler)acc, (ItemStack)item.func_77979_a(n), (boolean)false).func_190916_E());
        return item;
    }

    public byte getPriority() {
        return this.filter == null ? (byte)0 : this.filter.priority();
    }
}

