/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.gui;

import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.gui.TBGuiButton;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Rectangle2d;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;

@SideOnly(value=Side.CLIENT)
public class GuiInfo
extends TBScreen {
    private Info currentInfo;
    private Info lastInfo;
    private Info hoveredInfo = null;
    private int linesByPage;
    private int pageCount;
    private int currentPage;
    private String title;
    private final List<String> contentLines = new ArrayList<String>();
    private final List<Rectangle2d> underlines = new ArrayList<Rectangle2d>();
    private final List<InfoLink> infoLinks = new ArrayList<InfoLink>();
    private ItemStack icon;

    GuiInfo(@Nullable Info currentInfo) {
        this.currentInfo = this.lastInfo = currentInfo;
        this.currentPage = 0;
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0 && this.hoveredInfo != null) {
            this.currentInfo = this.hoveredInfo;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new TBGuiButton(0, this.halfWidth - 35, this.guiBottom - 25, 70, 15, I18n.func_135052_a((String)LangKey.MESSAGE_BACK.getKey(), (Object[])new Object[0])));
        this.field_146292_n.add(new TBGuiButton(1, this.halfWidth - 75, this.guiBottom - 25, 20, 15, "<-"));
        this.field_146292_n.add(new TBGuiButton(2, this.halfWidth + 55, this.guiBottom - 25, 20, 15, "->"));
        this.updatePage(this.currentInfo);
    }

    private void updateContent(@Nullable Info currentInfo) {
        List<Info> infos;
        this.contentLines.clear();
        this.underlines.clear();
        this.infoLinks.clear();
        this.icon = currentInfo == null ? new ItemStack((Block)ModBlocks.decorative_tombstone) : (ItemStack)currentInfo.icon.get();
        String content = I18n.func_135052_a((String)(currentInfo == null ? "tombstone.compendium.main.desc" : currentInfo.getContent()), (Object[])new Object[0]);
        Arrays.stream(content.split("[\\r\\n]+")).filter(p -> p.length() > 0).forEach(c -> {
            List list = this.field_146289_q.func_78271_c(c, this.xSize - 15);
            for (String line : list) {
                this.contentLines.add(line.replace("\u00c2\u00a7n\u00c2\u00a7r", ""));
            }
        });
        for (String line : this.contentLines) {
            if (line.startsWith(TextFormatting.UNDERLINE.toString())) {
                int endIndex = line.indexOf(TextFormatting.RESET.toString());
                if (endIndex == -1) {
                    endIndex = line.length() - 1;
                }
                this.underlines.add(new Rectangle2d(0, 0, this.field_146289_q.func_78256_a(line.substring(2, endIndex)) - 2, 0));
                continue;
            }
            this.underlines.add(null);
        }
        int x = this.guiLeft + this.xSize + 5;
        int y = this.guiTop + 10;
        if (currentInfo == null) {
            infos = Arrays.stream(Info.values()).filter(p -> ((Info)p).isMainEntry).collect(Collectors.toList());
        } else {
            infos = Info.getRelated(currentInfo);
            infos.sort(Comparator.comparing(p -> Normalizer.normalize(I18n.func_135052_a((String)p.getTitle(), (Object[])new Object[0]), Normalizer.Form.NFD)));
        }
        for (Info info : infos) {
            this.infoLinks.add(new InfoLink(info, x, y));
            y += this.field_146289_q.field_78288_b + 1;
        }
    }

    private void updatePage(@Nullable Info currentInfo) {
        this.lastInfo = currentInfo;
        this.title = I18n.func_135052_a((String)(currentInfo == null ? "tombstone.compendium.main.title" : currentInfo.getTitle()), (Object[])new Object[0]);
        this.updateContent(currentInfo);
        this.linesByPage = 12;
        this.pageCount = MathHelper.func_76123_f((float)((float)this.contentLines.size() / (float)this.linesByPage));
        this.currentPage = 0;
        this.updateButtons();
    }

    private void updateButtons() {
        ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m = this.currentPage > 0;
        ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)1)).field_146125_m;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage < this.pageCount - 1;
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m;
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.currentInfo == null) {
                    this.field_146297_k.field_71439_g.func_71053_j();
                    break;
                }
                this.currentInfo = null;
                break;
            }
            case 1: {
                --this.currentPage;
                this.updateButtons();
                break;
            }
            case 2: {
                ++this.currentPage;
                this.updateButtons();
                break;
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.func_146276_q_();
        this.hoveredInfo = null;
        if (this.currentInfo != this.lastInfo) {
            this.updatePage(this.currentInfo);
        }
        GuiInfo.func_73734_a((int)(this.guiLeft + 5), (int)(this.guiTop + 5), (int)(this.guiLeft + this.xSize - 5), (int)(this.guiTop + 20 + this.field_146289_q.field_78288_b), (int)0x55000000);
        ((Object)((Object)this)).getClass();
        this.field_146289_q.func_78276_b(this.title, this.guiLeft + 30, this.guiTop + 15, -1);
        if (this.currentInfo != null) {
            String string = this.currentPage + 1 + "/" + this.pageCount;
            float f = this.guiLeft + this.xSize - 30;
            float f2 = this.guiTop + 6;
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_175065_a(string, f, f2, -1, false);
        }
        if (!this.icon.func_190926_b()) {
            int n = this.guiLeft + 18 + this.field_146289_q.field_78288_b;
            int n2 = this.guiTop + 18 + this.field_146289_q.field_78288_b;
            ((Object)((Object)this)).getClass();
            GuiInfo.func_73734_a((int)(this.guiLeft + 7), (int)(this.guiTop + 7), (int)n, (int)n2, (int)-1);
            this.field_146296_j.func_180450_b(this.icon, (int)((float)(this.guiLeft + 9) / 1.0f), (int)((float)(this.guiTop + 9) / 1.0f));
        }
        int indexStart = Math.min(this.currentPage * this.linesByPage, this.contentLines.size() - 1);
        int indexEnd = Math.min(indexStart + this.linesByPage - 1, this.contentLines.size() - 1);
        if (indexStart >= 0) {
            GuiInfo.func_73734_a((int)(this.guiLeft + 5), (int)(this.guiTop + 34), (int)(this.guiLeft + this.xSize - 5), (int)(this.guiTop + 44 + (this.field_146289_q.field_78288_b + 1) * (indexEnd - indexStart + 1)), (int)0x55000000);
            int count = 0;
            for (int i = indexStart; i <= indexEnd; ++i) {
                String line = this.contentLines.get(i);
                float f = this.guiLeft + 10;
                float f3 = this.guiTop + 39 + count * (this.field_146289_q.field_78288_b + 1);
                ((Object)((Object)this)).getClass();
                this.field_146289_q.func_175065_a(line, f, f3, -1, false);
                Rectangle2d underline = this.underlines.get(i);
                if (underline != null) {
                    int startX = this.guiLeft + 10 + underline.getX();
                    int n = startX + underline.getWidth();
                    int n3 = this.guiTop + 39 + count * (this.field_146289_q.field_78288_b + 1) + this.field_146289_q.field_78288_b - 1;
                    ((Object)((Object)this)).getClass();
                    this.func_73730_a(startX, n, n3, -1);
                }
                ++count;
            }
        }
        for (InfoLink link : this.infoLinks) {
            if (this.hoveredInfo == null && link.isHovered(mouseX, mouseY)) {
                this.hoveredInfo = link.info;
                this.field_146289_q.func_175065_a(link.title, (float)link.x, (float)link.y, -7769547, false);
                continue;
            }
            String string = link.title;
            float f = link.x;
            float f4 = link.y;
            ((Object)((Object)this)).getClass();
            this.field_146289_q.func_175065_a(string, f, f4, -1, false);
        }
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    static enum Info {
        DEATH(() -> new ItemStack(ModItems.advancement, 1, 0), true),
        DECORATIVE_GRAVE(() -> new ItemStack((Block)ModBlocks.decorative_grave_simple), true, "tombstone.config_cat.decorative_grave"),
        MAGIC_ITEMS(() -> new ItemStack(ModItems.advancement, 1, 2), true),
        ENCHANTMENTS(() -> new ItemStack(Items.field_151134_bR), true),
        KNOWLEDGE_OF_DEATH(() -> new ItemStack((Item)ModItems.ankh_of_pray), true, "tombstone.message.knowledge_of_death"),
        SPECIAL_BONUS(() -> ItemStack.field_190927_a, true),
        ALIGNMENT(() -> new ItemStack(ModItems.advancement, 1, 6), false),
        ANKH_OF_PRAY(() -> new ItemStack((Item)ModItems.ankh_of_pray), false, "tombstone.item.ankh_of_pray.name"),
        BOOK_OF_DISENCHANTMENT(() -> new ItemStack((Item)ModItems.book_of_disenchantment), false, "tombstone.item.book_of_disenchantment.name"),
        CONTRIBUTOR(() -> ItemStack.field_190927_a, false),
        DARK_MARBLE(() -> new ItemStack(ModBlocks.dark_marble), false, "tombstone.tile.dark_marble.name"),
        DUST_OF_VANISHING(() -> new ItemStack((Item)ModItems.dust_of_vanishing), false, "tombstone.item.dust_of_vanishing.name"),
        FAMILIAR_RECEPTACLE(() -> new ItemStack((Item)ModItems.familiar_receptacle), false, "tombstone.item.familiar_receptacle.name"),
        FISHING_ROD_OF_MISADVENTURE(() -> new ItemStack((Item)ModItems.fishing_rod_of_misadventure), false, "tombstone.item.fishing_rod_of_misadventure.name"),
        GHOSTLY_SHAPE(() -> new ItemStack(ModItems.advancement, 1, 1), false, "tombstone.potion.ghostly_shape.name"),
        GRAVE_DUST(ItemCraftingIngredient.IconType.GRAVE_DUST::getStack, false, "tombstone.item.grave_dust.name"),
        GRAVE_KEY(() -> new ItemStack((Item)ModItems.grave_key), false, "tombstone.item.grave_key.name"),
        HALLOWEEN(() -> new ItemStack(ModItems.advancement, 1, 6), false),
        IMPREGNATED_DIAMOND(ItemCraftingIngredient.IconType.IMPREGNATED_DIAMOND::getStack, false, "tombstone.item.impregnated_diamond.name"),
        LOLLIPOP(() -> new ItemStack(ModItems.lollypop), false, "tombstone.item.lollypop.name"),
        LOST_TABLET(() -> new ItemStack((Item)ModItems.lost_tablet), false, "tombstone.item.lost_tablet.name"),
        PERK(() -> ItemStack.field_190927_a, false),
        SCROLL_OF_FEATHER_FALL(() -> new ItemStack((Item)ModItems.scroll_buff, 1, 2), false, "tombstone.item.scroll_of_feather_fall.name"),
        SCROLL_OF_KNOWLEDGE(() -> new ItemStack((Item)ModItems.scroll_of_knowledge), false, "tombstone.item.scroll_of_knowledge.name"),
        SCROLL_OF_PRESERVATION(() -> new ItemStack((Item)ModItems.scroll_buff, 1, 0), false, "tombstone.item.scroll_of_preservation.name"),
        SCROLL_OF_PURIFICATION(() -> new ItemStack((Item)ModItems.scroll_buff, 1, 3), false, "tombstone.item.scroll_of_purification.name"),
        SCROLL_OF_TRUE_SIGHT(() -> new ItemStack((Item)ModItems.scroll_buff, 1, 4), false, "tombstone.item.scroll_of_true_sight.name"),
        SCROLL_OF_UNSTABLE_INTANGIBLENESS(() -> new ItemStack((Item)ModItems.scroll_buff, 1, 1), false, "tombstone.item.scroll_of_unstable_intangibleness.name"),
        SCROLL_OF_REACH(() -> new ItemStack((Item)ModItems.scroll_buff, 1, 5), false, "tombstone.item.scroll_of_reach.name"),
        SCROLL_OF_LIGHTNING_RESISTANCE(() -> new ItemStack((Item)ModItems.scroll_buff, 1, 6), false, "tombstone.item.scroll_of_lightning_resistance.name"),
        MAGIC_SCROLLS(ItemCraftingIngredient.IconType.STRANGE_SCROLL::getStack, false),
        SOUL(() -> new ItemStack(ModItems.advancement, 1, 5), false),
        SOUL_RECEPTACLE(() -> new ItemStack((Item)ModItems.soul_receptacle), false, "tombstone.item.soul_receptacle.name"),
        STRANGE_SCROLL(ItemCraftingIngredient.IconType.STRANGE_SCROLL::getStack, false, "tombstone.item.strange_scroll.name"),
        STRANGE_TABLET(ItemCraftingIngredient.IconType.STRANGE_TABLET::getStack, false, "tombstone.item.strange_tablet.name"),
        TABLET_OF_HOME(() -> new ItemStack((Item)ModItems.tablet_of_home), false, "tombstone.item.tablet_of_home.name"),
        TABLET_OF_RECALL(() -> new ItemStack((Item)ModItems.tablet_of_recall), false, "tombstone.item.tablet_of_recall.name"),
        TABLET_OF_ASSISTANCE(() -> new ItemStack((Item)ModItems.tablet_of_assistance), false, "tombstone.item.tablet_of_assistance.name"),
        TABLET_OF_CUPIDITY(() -> new ItemStack((Item)ModItems.tablet_of_cupidity), false, "tombstone.item.tablet_of_cupidity.name"),
        MAGIC_TABLETS(ItemCraftingIngredient.IconType.STRANGE_TABLET::getStack, false),
        VOODOO_POPPET(() -> new ItemStack((Item)ModItems.voodoo_poppet), false, "tombstone.item.voodoo_poppet.name");

        private final Supplier<ItemStack> icon;
        private final boolean isMainEntry;
        private final String title;

        private Info(Supplier<ItemStack> icon, boolean isMainEntry) {
            this(icon, isMainEntry, null);
        }

        private Info(@Nullable Supplier<ItemStack> icon, boolean isMainEntry, String titleKey) {
            this.icon = icon;
            this.isMainEntry = isMainEntry;
            this.title = titleKey == null ? "tombstone.compendium." + this.name().toLowerCase() + ".title" : titleKey;
        }

        public final String getTitle() {
            return this.title;
        }

        public final String getContent() {
            return "tombstone.compendium." + this.name().toLowerCase() + ".desc";
        }

        public static List<Info> getRelated(Info info) {
            ArrayList<Info> infos = new ArrayList<Info>();
            switch (info) {
                case ALIGNMENT: {
                    infos.add(KNOWLEDGE_OF_DEATH);
                    break;
                }
                case ANKH_OF_PRAY: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case BOOK_OF_DISENCHANTMENT: {
                    infos.add(MAGIC_ITEMS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case CONTRIBUTOR: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case DARK_MARBLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(GRAVE_DUST);
                    break;
                }
                case DEATH: {
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(GRAVE_KEY);
                    infos.add(PERK);
                    break;
                }
                case DECORATIVE_GRAVE: {
                    infos.add(DARK_MARBLE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case DUST_OF_VANISHING: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case ENCHANTMENTS: {
                    break;
                }
                case FAMILIAR_RECEPTACLE: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(IMPREGNATED_DIAMOND);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case FISHING_ROD_OF_MISADVENTURE: {
                    infos.add(LOST_TABLET);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case GHOSTLY_SHAPE: {
                    infos.add(DEATH);
                    break;
                }
                case GRAVE_DUST: {
                    infos.add(DARK_MARBLE);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(IMPREGNATED_DIAMOND);
                    break;
                }
                case GRAVE_KEY: {
                    infos.add(DEATH);
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case HALLOWEEN: {
                    infos.add(LOLLIPOP);
                    infos.add(SPECIAL_BONUS);
                    break;
                }
                case IMPREGNATED_DIAMOND: {
                    infos.add(GRAVE_DUST);
                    infos.add(FAMILIAR_RECEPTACLE);
                    break;
                }
                case KNOWLEDGE_OF_DEATH: {
                    infos.add(ALIGNMENT);
                    infos.add(ANKH_OF_PRAY);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(SOUL);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case LOLLIPOP: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case LOST_TABLET: {
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(PERK);
                    infos.add(SOUL);
                    break;
                }
                case MAGIC_ITEMS: {
                    infos.add(ANKH_OF_PRAY);
                    infos.add(BOOK_OF_DISENCHANTMENT);
                    infos.add(DUST_OF_VANISHING);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(FISHING_ROD_OF_MISADVENTURE);
                    infos.add(GRAVE_KEY);
                    infos.add(LOLLIPOP);
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL_RECEPTACLE);
                    infos.add(MAGIC_TABLETS);
                    infos.add(VOODOO_POPPET);
                    break;
                }
                case MAGIC_SCROLLS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(SCROLL_OF_FEATHER_FALL);
                    infos.add(SCROLL_OF_KNOWLEDGE);
                    infos.add(SCROLL_OF_PRESERVATION);
                    infos.add(SCROLL_OF_PURIFICATION);
                    infos.add(SCROLL_OF_TRUE_SIGHT);
                    infos.add(SCROLL_OF_UNSTABLE_INTANGIBLENESS);
                    infos.add(SCROLL_OF_REACH);
                    infos.add(SCROLL_OF_LIGHTNING_RESISTANCE);
                    infos.add(SOUL);
                    infos.add(STRANGE_SCROLL);
                    break;
                }
                case STRANGE_SCROLL: {
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_SCROLLS);
                    break;
                }
                case STRANGE_TABLET: {
                    infos.add(DARK_MARBLE);
                    infos.add(GRAVE_DUST);
                    infos.add(MAGIC_TABLETS);
                    break;
                }
                case MAGIC_TABLETS: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(PERK);
                    infos.add(LOST_TABLET);
                    infos.add(SOUL);
                    infos.add(STRANGE_TABLET);
                    infos.add(TABLET_OF_ASSISTANCE);
                    infos.add(TABLET_OF_CUPIDITY);
                    infos.add(TABLET_OF_HOME);
                    infos.add(TABLET_OF_RECALL);
                    break;
                }
                case PERK: {
                    infos.add(DEATH);
                    infos.add(GHOSTLY_SHAPE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    break;
                }
                case SCROLL_OF_FEATHER_FALL: 
                case SCROLL_OF_KNOWLEDGE: 
                case SCROLL_OF_PRESERVATION: 
                case SCROLL_OF_PURIFICATION: 
                case SCROLL_OF_TRUE_SIGHT: 
                case SCROLL_OF_REACH: 
                case SCROLL_OF_LIGHTNING_RESISTANCE: 
                case SCROLL_OF_UNSTABLE_INTANGIBLENESS: {
                    infos.add(MAGIC_SCROLLS);
                    infos.add(SOUL);
                    break;
                }
                case SOUL: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL_RECEPTACLE);
                    break;
                }
                case SOUL_RECEPTACLE: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(FAMILIAR_RECEPTACLE);
                    infos.add(KNOWLEDGE_OF_DEATH);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                    break;
                }
                case SPECIAL_BONUS: {
                    infos.add(CONTRIBUTOR);
                    infos.add(HALLOWEEN);
                    break;
                }
                case TABLET_OF_ASSISTANCE: 
                case TABLET_OF_CUPIDITY: 
                case TABLET_OF_HOME: 
                case TABLET_OF_RECALL: {
                    infos.add(MAGIC_TABLETS);
                    infos.add(SOUL);
                    break;
                }
                case VOODOO_POPPET: {
                    infos.add(DECORATIVE_GRAVE);
                    infos.add(MAGIC_ITEMS);
                    infos.add(SOUL);
                }
            }
            return infos;
        }
    }

    public class InfoLink {
        private final String title;
        private final Info info;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        InfoLink(Info info, int x, int y) {
            this.title = I18n.func_135052_a((String)info.getTitle(), (Object[])new Object[0]);
            this.info = info;
            this.x = x;
            this.y = y;
            this.width = GuiInfo.this.field_146289_q.func_78256_a(this.title);
            this.height = ((GuiInfo)GuiInfo.this).field_146289_q.field_78288_b + 1;
        }

        boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.x && mouseY >= this.y && mouseX <= this.x + this.width & mouseY <= this.y + this.height;
        }
    }
}

