/*
 * Decompiled with CFR 0.152.
 */
package knightminer.tcomplement.plugin.jei.highoven.fuel;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import knightminer.tcomplement.library.Util;
import knightminer.tcomplement.library.steelworks.HighOvenFuel;
import knightminer.tcomplement.plugin.jei.highoven.fuel.HighOvenFuelCategory;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class HighOvenFuelWrapper
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputs;
    private final int time;
    private final int rate;
    private final IDrawableAnimated flame;

    public HighOvenFuelWrapper(HighOvenFuel recipe, IGuiHelper guiHelper) {
        this.inputs = ImmutableList.of(recipe.getFuels());
        this.time = recipe.getTime();
        this.rate = recipe.getRate();
        IDrawableStatic flameDrawable = guiHelper.createDrawable(HighOvenFuelCategory.BACKGROUND, 163, 0, 14, 14);
        this.flame = guiHelper.createAnimatedDrawable(flameDrawable, this.time, IDrawableAnimated.StartDirection.TOP, true);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.flame.draw(minecraft, 1, 0);
        minecraft.field_71466_p.func_78276_b(Util.translateFormatted("gui.jei.high_oven.fuel.rate", this.rate), 24, 13, Color.gray.getRGB());
        minecraft.field_71466_p.func_78276_b(Util.translateFormatted("gui.jei.high_oven.fuel.time", this.time), 24, 23, Color.gray.getRGB());
    }
}

