/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevpatches.core.patches;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import tv.darkosto.sevpatches.core.SevPatchesLoadingPlugin;
import tv.darkosto.sevpatches.core.patches.Patch;

public class PatchMinecraftSpawnChunkSpawning
extends Patch {
    public PatchMinecraftSpawnChunkSpawning(byte[] inputClass) {
        super(inputClass);
    }

    @Override
    protected boolean patch() {
        MethodNode findChunksForSpawning = null;
        for (MethodNode methodNode : this.classNode.methods) {
            if (!methodNode.name.equals(SevPatchesLoadingPlugin.FIND_CHUNKS_FOR_SPAWNING) || !methodNode.desc.equals(SevPatchesLoadingPlugin.FIND_CHUNKS_FOR_SPAWNING_DESC)) continue;
            findChunksForSpawning = methodNode;
        }
        if (findChunksForSpawning == null) {
            SevPatchesLoadingPlugin.LOGGER.warn("Couldn't find target method node: WorldEntitySpawner#findChunksForSpawning");
            return false;
        }
        MethodInsnNode distanceSq = null;
        for (AbstractInsnNode insnNode : findChunksForSpawning.instructions) {
            if (!(insnNode instanceof MethodInsnNode)) continue;
            MethodInsnNode mInsnNode = (MethodInsnNode)insnNode;
            if (!mInsnNode.name.equals(SevPatchesLoadingPlugin.VEC_3I_DISTANCE_SQ) || !mInsnNode.desc.equals(SevPatchesLoadingPlugin.VEC_3I_DISTANCE_SQ_DESC)) continue;
            distanceSq = (MethodInsnNode)insnNode;
        }
        if (distanceSq == null) {
            SevPatchesLoadingPlugin.LOGGER.warn("Couldn't find target method invocation: Vec3i#distanceSq");
            return false;
        }
        MethodInsnNode distanceSqRedirect = new MethodInsnNode(184, "tv/darkosto/sevpatches/core/hooks/SpawnHook", "distanceSqRedirect", "(Lnet/minecraft/util/math/BlockPos;DDD)D", false);
        findChunksForSpawning.instructions.insert(distanceSq, (AbstractInsnNode)distanceSqRedirect);
        findChunksForSpawning.instructions.remove(distanceSq);
        return true;
    }
}

