/*
 * Decompiled with CFR 0.152.
 */
package tv.darkosto.sevpatches.core.patches;

import java.util.ListIterator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import tv.darkosto.sevpatches.core.SevPatchesLoadingPlugin;
import tv.darkosto.sevpatches.core.patches.Patch;

public class PatchAstralAmulet
extends Patch {
    public PatchAstralAmulet(byte[] inputClass) {
        super(inputClass);
    }

    @Override
    protected byte[] writeClass() {
        ClassWriter classWriter = new ClassWriter(0);
        this.classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    @Override
    protected boolean patch() {
        for (MethodNode methodNode : this.classNode.methods) {
            if (!methodNode.name.equals("modifyEnchantmentTags")) continue;
            ListIterator it = methodNode.instructions.iterator();
            while (it.hasNext()) {
                AbstractInsnNode insnNode = (AbstractInsnNode)it.next();
                if (!(insnNode instanceof LdcInsnNode) || !((LdcInsnNode)insnNode).cst.equals("id")) continue;
                boolean foundTarget = false;
                while (!foundTarget) {
                    while (!((insnNode = (AbstractInsnNode)it.next()) instanceof MethodInsnNode)) {
                    }
                    MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                    if (methodInsnNode.name.equals(SevPatchesLoadingPlugin.GET_SHORT)) {
                        methodInsnNode.name = SevPatchesLoadingPlugin.GET_INT;
                        methodInsnNode.desc = "(Ljava/lang/String;)I";
                        foundTarget = true;
                        continue;
                    }
                    if (!methodInsnNode.name.equals(SevPatchesLoadingPlugin.SET_SHORT)) continue;
                    methodInsnNode.name = SevPatchesLoadingPlugin.SET_INT;
                    methodInsnNode.desc = "(Ljava/lang/String;I)V";
                    methodNode.instructions.remove(methodInsnNode.getPrevious());
                    foundTarget = true;
                }
            }
        }
        return true;
    }
}

