/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.drone.DroneConstructingEvent;
import me.desht.pneumaticcraft.api.drone.IPathNavigator;
import me.desht.pneumaticcraft.api.event.SemiblockEvent;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.api.item.IProgrammable;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.block.Blockss;
import me.desht.pneumaticcraft.common.entity.EntityProgrammableController;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityProgrammer;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneFakePlayer;
import me.desht.pneumaticcraft.common.util.fakeplayer.DroneItemHandler;
import me.desht.pneumaticcraft.common.util.fakeplayer.FakeNetHandlerPlayerServer;
import me.desht.pneumaticcraft.common.util.fakeplayer.InventoryFakePlayer;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityProgrammableController
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IDroneBase,
ISideConfigurable {
    private static final int INVENTORY_SIZE = 1;
    private static final String FALLBACK_NAME = "[ProgController]";
    private static final UUID FALLBACK_UUID = UUID.nameUUIDFromBytes("[ProgController]".getBytes());
    private final ProgrammableItemStackHandler inventory;
    private EntityProgrammableController drone;
    private final FluidTank tank = new FluidTank(16000);
    private DroneAIManager aiManager;
    private DroneFakePlayer fakePlayer;
    private DroneItemHandler droneInventory = new DroneItemHandler(1, this);
    private List<IProgWidget> progWidgets = new ArrayList<IProgWidget>();
    private final int[] redstoneLevels = new int[6];
    private int dispenserUpgrades;
    private final SideConfigurator<IItemHandler> itemHandlerSideConfigurator;
    @DescSynced
    private double targetX;
    @DescSynced
    private double targetY;
    @DescSynced
    private double targetZ;
    @DescSynced
    @LazySynced
    private double curX;
    @DescSynced
    @LazySynced
    private double curY;
    @DescSynced
    @LazySynced
    private double curZ;
    @DescSynced
    private int diggingX;
    @DescSynced
    private int diggingY;
    @DescSynced
    private int diggingZ;
    @DescSynced
    private int speedUpgrades;
    public static final Set<String> BLACKLISTED_WIDGETS = ImmutableSet.of((Object)"computerCraft", (Object)"entityAttack", (Object)"droneConditionEntity", (Object)"standby", (Object)"suicide", (Object)"teleport", (Object[])new String[]{"entityExport", "entityImport"});
    private UUID ownerID;
    private String ownerName;
    private boolean updateNeighbours;
    private LogisticsManager logisticsManager;

    public TileEntityProgrammableController() {
        super(5.0f, 7.0f, 5000, 4);
        this.inventory = new ProgrammableItemStackHandler(this);
        this.addApplicableUpgrade(IItemRegistry.EnumUpgrade.SPEED, IItemRegistry.EnumUpgrade.DISPENSER);
        MinecraftForge.EVENT_BUS.post((Event)new DroneConstructingEvent(this));
        this.itemHandlerSideConfigurator = new SideConfigurator("items", this, 5);
        this.itemHandlerSideConfigurator.registerHandler("droneInv", new ItemStack(Itemss.DRONE), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (IItemHandler)this.droneInventory, SideConfigurator.RelativeFace.TOP, SideConfigurator.RelativeFace.FRONT, SideConfigurator.RelativeFace.BACK, SideConfigurator.RelativeFace.LEFT, SideConfigurator.RelativeFace.RIGHT);
        this.itemHandlerSideConfigurator.registerHandler("programmableInv", new ItemStack(Itemss.NETWORK_COMPONENT, 1, 1), (Capability<IItemHandler>)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (IItemHandler)this.inventory, SideConfigurator.RelativeFace.BOTTOM);
        this.itemHandlerSideConfigurator.setNullFaceHandler("droneInv");
    }

    @SubscribeEvent
    public void onSemiblockEvent(SemiblockEvent event) {
        if (!event.getWorld().field_72995_K && event.getWorld() == this.func_145831_w()) {
            this.logisticsManager = null;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.updateNeighbours) {
            this.updateNeighbours();
            this.updateNeighbours = false;
        }
        double speed = this.getSpeed();
        if (PneumaticCraftUtils.distBetweenSq((Vec3i)this.func_174877_v(), this.targetX, this.targetY, this.targetZ) <= speed * speed) {
            this.curX = this.targetX;
            this.curY = this.targetY;
            this.curZ = this.targetZ;
        } else if (PneumaticCraftUtils.distBetweenSq(this.curX, this.curY, this.curZ, this.targetX, this.targetY, this.targetZ) > 0.25) {
            Vec3d vec = new Vec3d(this.targetX - this.curX, this.targetY - this.curY, this.targetZ - this.curZ).func_72432_b().func_186678_a(speed);
            this.curX += vec.field_72450_a;
            this.curY += vec.field_72448_b;
            this.curZ += vec.field_72449_c;
        }
        if (!this.func_145831_w().field_72995_K) {
            this.droneInventory.updateHeldItem();
            DroneFakePlayer fp = this.getFakePlayer();
            for (int i = 0; i < 4; ++i) {
                fp.field_71134_c.func_73075_a();
            }
            fp.field_70165_t = this.curX;
            fp.field_70163_u = this.curY;
            fp.field_70161_v = this.curZ;
            fp.func_70071_h_();
            if (this.getPressure() >= this.getMinWorkingPressure()) {
                if (!this.aiManager.isIdling()) {
                    this.addAir(-10);
                }
                this.aiManager.onUpdateTasks();
            }
        } else {
            if (this.drone == null || this.drone.field_70128_L) {
                this.drone = new EntityProgrammableController(this.func_145831_w(), this);
                this.drone.field_70165_t = this.curX;
                this.drone.field_70163_u = this.curY;
                this.drone.field_70161_v = this.curZ;
                this.func_145831_w().func_72838_d((Entity)this.drone);
            }
            this.drone.func_70107_b(this.curX, this.curY, this.curZ);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public void onDescUpdate() {
        super.onDescUpdate();
        if (this.drone != null) {
            this.drone.func_70106_y();
        }
    }

    private double getSpeed() {
        return (double)Math.min(10, this.speedUpgrades) * 0.1 + 0.1;
    }

    private UUID getOwnerUUID() {
        if (this.ownerID == null) {
            this.ownerID = UUID.randomUUID();
            Log.warning(String.format("Programmable controller with owner '%s' has no UUID! Substituting a random UUID (%s).", this.ownerName, this.ownerID.toString()));
        }
        return this.ownerID;
    }

    private void initializeFakePlayer() {
        this.fakePlayer = new DroneFakePlayer((WorldServer)this.func_145831_w(), new GameProfile(this.getOwnerUUID(), this.ownerName), this);
        this.fakePlayer.field_71135_a = new FakeNetHandlerPlayerServer(FMLCommonHandler.instance().getMinecraftServerInstance(), (EntityPlayerMP)this.fakePlayer);
        this.fakePlayer.field_71071_by = new InventoryFakePlayer((EntityPlayer)this.fakePlayer){

            @Override
            public IItemHandlerModifiable getUnderlyingItemHandler() {
                return TileEntityProgrammableController.this.droneInventory;
            }
        };
    }

    @Override
    public void handleGUIButtonPress(int buttonID, EntityPlayer player) {
        if (this.itemHandlerSideConfigurator.handleButtonPress(buttonID)) {
            this.updateNeighbours = true;
        }
    }

    @Override
    public IItemHandlerModifiable getPrimaryInventory() {
        return this.inventory;
    }

    public void setOwner(EntityPlayer ownerID) {
        this.ownerID = ownerID.func_110124_au();
        this.ownerName = ownerID.func_70005_c_();
    }

    @Override
    public List<SideConfigurator> getSideConfigurators() {
        return Collections.singletonList(this.itemHandlerSideConfigurator);
    }

    @Override
    public EnumFacing byIndex() {
        return this.getRotation();
    }

    @Override
    public String getName() {
        return Blockss.PROGRAMMABLE_CONTROLLER.func_149739_a();
    }

    @Override
    protected void onUpgradesChanged() {
        super.onUpgradesChanged();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            this.calculateUpgrades();
        }
    }

    private void calculateUpgrades() {
        int oldDispenserUpgrades = this.dispenserUpgrades;
        this.dispenserUpgrades = Math.min(35, this.getUpgrades(IItemRegistry.EnumUpgrade.DISPENSER));
        if (!this.func_145831_w().field_72995_K && oldDispenserUpgrades != this.dispenserUpgrades) {
            this.resizeDroneInventory(oldDispenserUpgrades + 1, this.dispenserUpgrades + 1);
            this.tank.setCapacity((this.dispenserUpgrades + 1) * 16000);
            if (this.tank.getFluidAmount() > this.tank.getCapacity()) {
                this.tank.getFluid().amount = this.tank.getCapacity();
            }
        }
        this.speedUpgrades = this.getUpgrades(IItemRegistry.EnumUpgrade.SPEED);
    }

    private void resizeDroneInventory(int oldSize, int newSize) {
        int i;
        DroneItemHandler tmpHandler = new DroneItemHandler(newSize, this);
        for (i = 0; i < oldSize && i < newSize; ++i) {
            tmpHandler.setStackInSlot(i, this.droneInventory.getStackInSlot(i));
        }
        for (i = newSize; i < oldSize; ++i) {
            ItemStack stack = this.droneInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            PneumaticCraftUtils.dropItemOnGround(stack, this.func_145831_w(), this.func_174877_v().func_177984_a());
        }
        this.droneInventory = tmpHandler;
        this.itemHandlerSideConfigurator.updateHandler("droneInv", (IItemHandler)this.droneInventory);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.tank.readFromNBT(tag.func_74775_l("tank"));
        this.droneInventory = new DroneItemHandler(this.getDroneSlots(), this);
        this.droneInventory.deserializeNBT(tag.func_74775_l("droneItems"));
        this.ownerID = tag.func_74764_b("ownerID") ? UUID.fromString(tag.func_74779_i("ownerID")) : FALLBACK_UUID;
        this.ownerName = tag.func_74764_b("ownerName") ? tag.func_74779_i("ownerName") : FALLBACK_NAME;
        this.itemHandlerSideConfigurator.updateHandler("droneInv", (IItemHandler)this.droneInventory);
        if (this.getDroneSlots() != this.droneInventory.getSlots()) {
            Log.warning("drone inventory size mismatch: dispenser upgrades = " + this.getDroneSlots() + ", saved inv size = " + this.droneInventory.getSlots());
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("Items", (NBTBase)this.inventory.serializeNBT());
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tag.func_74782_a("tank", (NBTBase)tankTag);
        ItemStackHandler handler = new ItemStackHandler(this.getFakePlayer().field_71071_by.func_70302_i_());
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, this.getFakePlayer().field_71071_by.func_70301_a(i));
        }
        tag.func_74782_a("droneItems", (NBTBase)handler.serializeNBT());
        tag.func_74778_a("ownerID", this.ownerID.toString());
        tag.func_74778_a("ownerName", this.ownerName);
        return tag;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandlerSideConfigurator.getHandler(facing) != null;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandlerSideConfigurator.getHandler(facing));
        }
        return super.getCapability(capability, facing);
    }

    @Override
    protected void onFirstServerUpdate() {
        super.onFirstServerUpdate();
        SideConfigurator.validateBlockRotation(this);
        this.calculateUpgrades();
        this.inventory.onContentsChanged(0);
        this.curX = this.targetX = (double)this.func_174877_v().func_177958_n() + 0.5;
        this.curY = this.targetY = (double)this.func_174877_v().func_177956_o() + 0.6;
        this.curZ = this.targetZ = (double)this.func_174877_v().func_177952_p() + 0.5;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private int getDroneSlots() {
        return this.field_145850_b != null && this.field_145850_b.field_72995_K ? 0 : Math.min(36, 1 + this.dispenserUpgrades);
    }

    private static boolean isProgrammableAndValidForDrone(IDroneBase drone, ItemStack programmable) {
        if (programmable.func_77973_b() instanceof IProgrammable && ((IProgrammable)programmable.func_77973_b()).canProgram(programmable) && ((IProgrammable)programmable.func_77973_b()).usesPieces(programmable)) {
            List<IProgWidget> widgets = TileEntityProgrammer.getProgWidgets(programmable);
            for (IProgWidget widget : widgets) {
                if (drone.isProgramApplicable(widget)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public float getMinWorkingPressure() {
        return 3.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public float getPressure(ItemStack iStack) {
        return this.getPressure();
    }

    @Override
    public void addAir(ItemStack iStack, int amount) {
        this.addAir(amount);
    }

    @Override
    public float maxPressure(ItemStack iStack) {
        return 7.0f;
    }

    @Override
    public int getVolume(ItemStack itemStack) {
        return this.getAirHandler(null).getVolume();
    }

    @Override
    public World world() {
        return this.func_145831_w();
    }

    @Override
    public IFluidTank getTank() {
        return this.tank;
    }

    @Override
    public IItemHandlerModifiable getInv() {
        return this.droneInventory;
    }

    @Override
    public Vec3d getDronePos() {
        if (this.curX == 0.0 && this.curY == 0.0 && this.curZ == 0.0) {
            this.curX = (double)this.func_174877_v().func_177958_n() + 0.5;
            this.curY = (double)this.func_174877_v().func_177956_o() + 0.6;
            this.curZ = (double)this.func_174877_v().func_177952_p() + 0.5;
            this.targetX = this.curX;
            this.targetY = this.curY;
            this.targetZ = this.curZ;
        }
        return new Vec3d(this.curX, this.curY, this.curZ);
    }

    @Override
    public IPathNavigator getPathNavigator() {
        return new IPathNavigator(){

            @Override
            public boolean moveToXYZ(double x, double y, double z) {
                if (TileEntityProgrammableController.this.isBlockValidPathfindBlock(new BlockPos(x, y, z))) {
                    TileEntityProgrammableController.this.targetX = x + 0.5;
                    TileEntityProgrammableController.this.targetY = y - 0.3;
                    TileEntityProgrammableController.this.targetZ = z + 0.5;
                    return true;
                }
                return false;
            }

            @Override
            public boolean moveToEntity(Entity entity) {
                return this.moveToXYZ(entity.field_70165_t, entity.field_70163_u + 0.3, entity.field_70161_v);
            }

            @Override
            public boolean hasNoPath() {
                return PneumaticCraftUtils.distBetweenSq(TileEntityProgrammableController.this.curX, TileEntityProgrammableController.this.curY, TileEntityProgrammableController.this.curZ, TileEntityProgrammableController.this.targetX, TileEntityProgrammableController.this.targetY, TileEntityProgrammableController.this.targetZ) < 0.5;
            }

            @Override
            public boolean isGoingToTeleport() {
                return false;
            }
        };
    }

    @Override
    public void sendWireframeToClient(BlockPos pos) {
    }

    public DroneFakePlayer getFakePlayer() {
        if (this.fakePlayer == null) {
            this.initializeFakePlayer();
        }
        return this.fakePlayer;
    }

    @Override
    public boolean isBlockValidPathfindBlock(BlockPos pos) {
        return this.func_145831_w().func_175623_d(pos);
    }

    @Override
    public void dropItem(ItemStack stack) {
        Vec3d pos = this.getDronePos();
        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, stack));
    }

    @Override
    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        super.getContentsToDrop(drops);
        for (int i = 0; i < this.getDroneSlots(); ++i) {
            if (this.fakePlayer.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            drops.add((Object)this.fakePlayer.field_71071_by.func_70301_a(i).func_77946_l());
        }
    }

    @Override
    public void setDugBlock(BlockPos pos) {
        if (pos != null) {
            this.diggingX = pos.func_177958_n();
            this.diggingY = pos.func_177956_o();
            this.diggingZ = pos.func_177952_p();
        } else {
            this.diggingZ = 0;
            this.diggingY = 0;
            this.diggingX = 0;
        }
    }

    public BlockPos getDugPosition() {
        return this.diggingX != 0 || this.diggingY != 0 || this.diggingZ != 0 ? new BlockPos(this.diggingX, this.diggingY, this.diggingZ) : null;
    }

    @Override
    public List<IProgWidget> getProgWidgets() {
        return this.progWidgets;
    }

    @Override
    public void setActiveProgram(IProgWidget widget) {
    }

    @Override
    public boolean isProgramApplicable(IProgWidget widget) {
        return !BLACKLISTED_WIDGETS.contains(widget.getWidgetString());
    }

    @Override
    public EntityAITasks getTargetAI() {
        return null;
    }

    @Override
    public void setEmittingRedstone(EnumFacing orientation, int emittingRedstone) {
        this.redstoneLevels[orientation.ordinal()] = emittingRedstone;
        this.updateNeighbours();
    }

    public int getEmittingRedstone(EnumFacing direction) {
        return this.redstoneLevels[direction.ordinal()];
    }

    @Override
    public void setName(String string) {
        ItemStack stack;
        if (this.drone != null) {
            this.drone.func_96094_a(string);
        }
        if (!(stack = this.inventory.getStackInSlot(0).func_77946_l()).func_190926_b()) {
            stack.func_151001_c(string);
            this.inventory.setStackInSlot(0, stack);
        }
    }

    @Override
    public void setCarryingEntity(Entity entity) {
        Log.warning("Drone AI setting carrying entity. However a Programmable Controller can't carry entities!");
        new Throwable().printStackTrace();
    }

    @Override
    public List<Entity> getCarryingEntities() {
        return Collections.emptyList();
    }

    @Override
    public boolean isAIOverriden() {
        return false;
    }

    @Override
    public void onItemPickupEvent(EntityItem curPickingUpEntity, int stackSize) {
    }

    @Override
    public EntityPlayer getOwner() {
        if (this.ownerID == null) {
            return null;
        }
        if (this.func_145831_w().field_72995_K) {
            return PneumaticCraftRepressurized.proxy.getClientPlayer();
        }
        return PneumaticCraftUtils.getPlayerFromId(this.ownerID);
    }

    @Override
    public void overload(String msgKey, Object ... params) {
        NetworkHandler.sendToAllAround(new PacketSpawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)this.func_174877_v().func_177958_n() - 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() - 0.5, 0.0, 0.0, 0.0, 10, 1.0, 1.0, 1.0), this.func_145831_w());
    }

    @Override
    public DroneAIManager getAIManager() {
        if (!this.func_145831_w().field_72995_K && this.aiManager == null) {
            this.aiManager = new DroneAIManager(this, new ArrayList<IProgWidget>());
            this.aiManager.dontStopWhenEndReached();
        }
        return this.aiManager;
    }

    @Override
    public void updateLabel() {
    }

    @Override
    public void addDebugEntry(String message) {
    }

    @Override
    public void addDebugEntry(String message, BlockPos pos) {
    }

    @Override
    public LogisticsManager getLogisticsManager() {
        return this.logisticsManager;
    }

    @Override
    public void setLogisticsManager(LogisticsManager logisticsManager) {
        this.logisticsManager = logisticsManager;
    }

    private class ProgrammableItemStackHandler
    extends BaseItemStackHandler {
        ProgrammableItemStackHandler(TileEntity te) {
            super(te, 1);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.func_190926_b() && TileEntityProgrammableController.isProgrammableAndValidForDrone(TileEntityProgrammableController.this, stack)) {
                TileEntityProgrammableController.this.progWidgets = TileEntityProgrammer.getProgWidgets(stack);
            } else {
                TileEntityProgrammableController.this.progWidgets.clear();
                TileEntityProgrammableController.this.setDugBlock(null);
                TileEntityProgrammableController.this.targetX = (double)TileEntityProgrammableController.this.func_174877_v().func_177958_n() + 0.5;
                TileEntityProgrammableController.this.targetY = (double)TileEntityProgrammableController.this.func_174877_v().func_177956_o() + 0.6;
                TileEntityProgrammableController.this.targetZ = (double)TileEntityProgrammableController.this.func_174877_v().func_177952_p() + 0.5;
                boolean updateNeighbours = false;
                for (int i = 0; i < TileEntityProgrammableController.this.redstoneLevels.length; ++i) {
                    if (TileEntityProgrammableController.this.redstoneLevels[i] <= 0) continue;
                    ((TileEntityProgrammableController)TileEntityProgrammableController.this).redstoneLevels[i] = 0;
                    updateNeighbours = true;
                }
                if (updateNeighbours) {
                    TileEntityProgrammableController.this.updateNeighbours();
                }
            }
            if (!TileEntityProgrammableController.this.func_145831_w().field_72995_K) {
                TileEntityProgrammableController.this.getAIManager().setWidgets(TileEntityProgrammableController.this.progWidgets);
            }
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || TileEntityProgrammableController.isProgrammableAndValidForDrone(TileEntityProgrammableController.this, itemStack);
        }
    }
}

