/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.recipes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.desht.pneumaticcraft.api.recipe.IPressureChamberRecipe;
import me.desht.pneumaticcraft.api.recipe.ItemIngredient;
import me.desht.pneumaticcraft.common.util.ItemStackHandlerIterable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class PressureChamberVacuumEnchantHandler
implements IPressureChamberRecipe {
    @Override
    public float getCraftingPressure() {
        return -0.75f;
    }

    @Override
    public boolean isValidRecipe(ItemStackHandler chamberHandler) {
        return !this.getDisenchantableItem(chamberHandler).func_190926_b() && !this.getBook(chamberHandler).func_190926_b();
    }

    public ItemStack getDisenchantableItem(ItemStackHandler inputStacks) {
        return new ItemStackHandlerIterable(inputStacks).stream().filter(stack -> stack.func_77973_b() != Items.field_151134_bR && EnchantmentHelper.func_82781_a((ItemStack)stack).size() > 0).findFirst().orElse(ItemStack.field_190927_a);
    }

    public ItemStack getBook(ItemStackHandler inputStacks) {
        return new ItemStackHandlerIterable(inputStacks).stream().filter(stack -> stack.func_77973_b() == Items.field_151122_aG).findFirst().orElse(ItemStack.field_190927_a);
    }

    @Override
    public NonNullList<ItemStack> craftRecipe(ItemStackHandler chamberHandler) {
        ItemStack enchantedStack = this.getDisenchantableItem(chamberHandler);
        this.getBook(chamberHandler).func_190918_g(1);
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)enchantedStack);
        ArrayList l = new ArrayList(enchantments.keySet());
        Enchantment strippedEnchantment = (Enchantment)l.get(new Random().nextInt(l.size()));
        int level = (Integer)enchantments.get(strippedEnchantment);
        enchantments.remove(strippedEnchantment);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)enchantedStack);
        ItemStack enchantedBook = new ItemStack(Items.field_151134_bR);
        EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)strippedEnchantment, (Object)level), (ItemStack)enchantedBook);
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{enchantedBook});
    }

    @Override
    public List<ItemIngredient> getInput() {
        ItemStack stack = new ItemStack(Items.field_151046_w);
        stack.func_77966_a(Enchantments.field_185308_t, 1);
        ItemIngredient pick = new ItemIngredient(stack).setTooltip("gui.nei.tooltip.vacuumEnchantItem");
        ItemIngredient book = new ItemIngredient(Items.field_151122_aG, 1, 0);
        return ImmutableList.of((Object)pick, (Object)book);
    }

    @Override
    public NonNullList<ItemStack> getResult() {
        ItemStack pick = new ItemStack(Items.field_151046_w);
        IPressureChamberRecipe.setTooltipKey(pick, "gui.nei.tooltip.vacuumEnchantItemOut");
        ItemStack book = new ItemStack(Items.field_151134_bR);
        book.func_77966_a(Enchantments.field_185308_t, 1);
        IPressureChamberRecipe.setTooltipKey(book, "gui.nei.tooltip.vacuumEnchantBookOut");
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{pick, book});
    }
}

