/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.progwidgets;

import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.gui.GuiProgrammer;
import me.desht.pneumaticcraft.client.gui.programmer.GuiProgWidgetItemFilter;
import me.desht.pneumaticcraft.common.ai.DroneAIManager;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.IVariableWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProgWidgetItemFilter
extends ProgWidget
implements IVariableWidget {
    private ItemStack filter = ItemStack.field_190927_a;
    public boolean useMetadata = true;
    public boolean useNBT;
    public boolean useOreDict;
    public boolean useModSimilarity;
    public boolean matchBlock;
    public int specificMeta;
    private DroneAIManager aiManager;
    private String variable = "";
    @SideOnly(value=Side.CLIENT)
    private static RenderItem itemRender;

    public static ProgWidgetItemFilter withFilter(ItemStack filter) {
        ProgWidgetItemFilter widget = new ProgWidgetItemFilter();
        widget.filter = filter;
        return widget;
    }

    @Override
    public void addErrors(List<String> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        if (this.variable.equals("") && this.filter == null) {
            curInfo.add("gui.progWidget.itemFilter.error.noFilter");
        }
        if (this.matchBlock && !(this.filter.func_77973_b() instanceof ItemBlock)) {
            curInfo.add("gui.progWidget.itemFilter.error.notBlock");
        }
    }

    @Override
    public void renderExtraInfo() {
        if (this.variable.equals("")) {
            if (!this.filter.func_190926_b()) {
                ProgWidgetItemFilter.drawItemStack(this.filter, 10, 2, "");
            }
        } else {
            super.renderExtraInfo();
        }
    }

    @Override
    public String getExtraStringInfo() {
        return "\"" + this.variable + "\"";
    }

    @Nonnull
    public ItemStack getFilter() {
        return this.variable.equals("") ? this.filter : (this.aiManager != null ? this.aiManager.getStack(this.variable) : ItemStack.field_190927_a);
    }

    public void setFilter(@Nonnull ItemStack filter) {
        this.filter = filter;
    }

    public static void drawItemStack(@Nonnull ItemStack stack, int x, int y, String text) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        if (itemRender == null) {
            itemRender = Minecraft.func_71410_x().func_175599_af();
        }
        ProgWidgetItemFilter.itemRender.field_77023_b = 200.0f;
        FontRenderer font = null;
        if (!stack.func_190926_b()) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = mc.field_71466_p;
        }
        itemRender.func_180450_b(stack, x, y);
        itemRender.func_180453_a(font, stack, x, y, text);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
    }

    @Override
    public void getTooltip(List<String> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.filter.func_190926_b()) {
            curTooltip.add(TextFormatting.AQUA + "Filter: " + TextFormatting.RESET + this.filter.func_82833_r());
            if (this.useOreDict) {
                curTooltip.add(TextFormatting.DARK_AQUA + "- Using Ore Dictionary");
            } else if (this.useModSimilarity) {
                curTooltip.add(TextFormatting.DARK_AQUA + "- Using Mod similarity");
            } else {
                curTooltip.add(TextFormatting.DARK_AQUA + "- " + (this.useMetadata ? "Using" : "Ignoring") + " meta");
                if (this.matchBlock) {
                    curTooltip.add(TextFormatting.DARK_AQUA + "- Matching by block");
                } else {
                    curTooltip.add(TextFormatting.DARK_AQUA + "- " + (this.useNBT ? "Using" : "Ignoring") + " NBT");
                }
            }
        }
    }

    @Override
    public boolean hasStepInput() {
        return false;
    }

    @Override
    public Class<? extends IProgWidget> returnType() {
        return ProgWidgetItemFilter.class;
    }

    @Override
    public Class<? extends IProgWidget>[] getParameters() {
        return new Class[]{ProgWidgetItemFilter.class};
    }

    @Override
    public String getWidgetString() {
        return "itemFilter";
    }

    @Override
    public ResourceLocation getTexture() {
        return Textures.PROG_WIDGET_ITEM_FILTER;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        if (this.filter != null) {
            this.filter.func_77955_b(tag);
        }
        tag.func_74757_a("useMetadata", this.useMetadata);
        tag.func_74757_a("useNBT", this.useNBT);
        tag.func_74757_a("useOreDict", this.useOreDict);
        tag.func_74757_a("useModSimilarity", this.useModSimilarity);
        tag.func_74757_a("matchBlock", this.matchBlock);
        tag.func_74768_a("specificMeta", this.specificMeta);
        tag.func_74778_a("variable", this.variable);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.filter = new ItemStack(tag);
        this.useMetadata = tag.func_74767_n("useMetadata");
        this.useNBT = tag.func_74767_n("useNBT");
        this.useOreDict = tag.func_74767_n("useOreDict");
        this.useModSimilarity = tag.func_74767_n("useModSimilarity");
        this.matchBlock = tag.func_74767_n("matchBlock");
        this.specificMeta = tag.func_74762_e("specificMeta");
        this.variable = tag.func_74779_i("variable");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getOptionWindow(GuiProgrammer guiProgrammer) {
        return new GuiProgWidgetItemFilter(this, guiProgrammer);
    }

    public static boolean isItemValidForFilters(ItemStack item, List<ProgWidgetItemFilter> whitelist, List<ProgWidgetItemFilter> blacklist, IBlockState blockState) {
        if (blacklist != null) {
            for (ProgWidgetItemFilter black : blacklist) {
                if (!ProgWidgetItemFilter.matchFilter(item, blockState, black)) continue;
                return false;
            }
        }
        if (whitelist == null || whitelist.size() == 0) {
            return true;
        }
        for (ProgWidgetItemFilter white : whitelist) {
            if (!ProgWidgetItemFilter.matchFilter(item, blockState, white)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchFilter(ItemStack stack, IBlockState blockState, ProgWidgetItemFilter filter) {
        if (filter.matchBlock && stack.func_190926_b() && blockState != null && filter.getFilter().func_77973_b() instanceof ItemBlock) {
            return blockState.func_177230_c() == ((ItemBlock)filter.getFilter().func_77973_b()).func_179223_d() && (!filter.useMetadata || filter.specificMeta == blockState.func_177230_c().func_176201_c(blockState));
        }
        if (PneumaticCraftUtils.areStacksEqual(filter.getFilter(), stack, filter.useMetadata && blockState == null, filter.useNBT, filter.useOreDict, filter.useModSimilarity)) {
            return blockState == null || !filter.useMetadata || filter.specificMeta == blockState.func_177230_c().func_176201_c(blockState);
        }
        return false;
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.EASY;
    }

    @Override
    public int getCraftingColorIndex() {
        return 8;
    }

    @Override
    public void setAIManager(DroneAIManager aiManager) {
        this.aiManager = aiManager;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    public String getVariable() {
        return this.variable;
    }

    @Override
    public void addVariables(Set<String> variables) {
        variables.add(this.variable);
    }
}

