/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.heat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class HeatExtractionTracker
extends WorldSavedData {
    private static final String DATA_NAME = "PneumaticCraftHeatExtraction";
    private final Map<BlockPos, Double> extracted = new HashMap<BlockPos, Double>();

    private HeatExtractionTracker() {
        super(DATA_NAME);
    }

    public HeatExtractionTracker(String name) {
        super(name);
    }

    public static HeatExtractionTracker getInstance(World world) {
        MapStorage storage = world.getPerWorldStorage();
        HeatExtractionTracker tracker = (HeatExtractionTracker)storage.func_75742_a(HeatExtractionTracker.class, DATA_NAME);
        if (tracker == null) {
            tracker = new HeatExtractionTracker();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)tracker);
        }
        return tracker;
    }

    public double getHeatExtracted(BlockPos pos) {
        return this.extracted.getOrDefault(pos, 0.0);
    }

    public void extractHeat(BlockPos pos, double heat) {
        double newAmount = this.getHeatExtracted(pos) + heat;
        if (Math.abs(newAmount) < 1.0E-6) {
            this.extracted.remove(pos);
        } else {
            this.extracted.put(pos, newAmount);
        }
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.extracted.clear();
        NBTTagList list = nbt.func_150295_c("extracted", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound sub = list.func_150305_b(i);
            BlockPos pos = new BlockPos(sub.func_74762_e("x"), sub.func_74762_e("y"), sub.func_74762_e("z"));
            this.extracted.put(pos, sub.func_74769_h("heat"));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<BlockPos, Double> entry : this.extracted.entrySet()) {
            NBTTagCompound sub = new NBTTagCompound();
            sub.func_74768_a("x", entry.getKey().func_177958_n());
            sub.func_74768_a("y", entry.getKey().func_177956_o());
            sub.func_74768_a("z", entry.getKey().func_177952_p());
            sub.func_74780_a("heat", entry.getValue().doubleValue());
            list.func_74742_a((NBTBase)sub);
        }
        compound.func_74782_a("extracted", (NBTBase)list);
        return compound;
    }
}

