/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.infoaccessories.info;

import baubles.api.BaublesApi;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import net.darkhax.bookshelf.data.MoonPhase;
import net.darkhax.bookshelf.lib.MCDate;
import net.darkhax.bookshelf.util.BlockUtils;
import net.darkhax.bookshelf.util.PlayerUtils;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.infoaccessories.InfoAccessories;
import net.darkhax.infoaccessories.IntercardinalDirection;
import net.darkhax.infoaccessories.info.IInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public enum InfoType {
    PLAYER_X(Items.field_151111_aL, (world, player, left, right) -> left.add(String.format("X: %.3f", player.field_70165_t))),
    PLAYER_Y(2, (world, player, left, right) -> left.add(String.format("Y: %.3f", player.field_70163_u))),
    PLAYER_Z(Items.field_151111_aL, (world, player, left, right) -> left.add(String.format("Z: %.3f", player.field_70161_v))),
    DIRECTION(Items.field_151111_aL, (world, player, left, right) -> InfoType.addDirectionInfo(world, player, left)),
    CALENDAR(5, (world, player, left, right) -> InfoType.addDateInfo(world, left)),
    MOVEMENT(0, (world, player, left, right) -> left.add(String.format("Motion X: %.3f Y: %.3f Z: %.3f", player.field_70159_w, player.field_70181_x, player.field_70179_y))),
    MOON_PHASE(1, (world, player, left, right) -> left.add("Moon Phase: " + MoonPhase.getCurrentPhase().getPhaseName())),
    BIOME(6, (world, player, left, right) -> left.add("Biome: " + world.getBiomeForCoordsBody(player.func_180425_c()).func_185359_l())),
    CHUNK(7, (world, player, left, right) -> InfoType.addChunkInfo(world, player, left)),
    SLIME_CHUNK(4, (world, player, left, right) -> left.add("Slime Chunk: " + BlockUtils.isSlimeChunk((World)world, (BlockPos)player.func_180425_c()))),
    DPS(8, (world, player, left, right) -> left.add("//TODO")),
    STRUCTURE(9, (world, player, left, right) -> left.add("//TODO"));

    private final IInfo info;
    private final Item item;
    private final int meta;

    private InfoType(int meta, IInfo info) {
        this(InfoAccessories.infoItem, meta, info);
    }

    private InfoType(Item item, IInfo info) {
        this(item, 0, info);
    }

    private InfoType(Item item, int meta, IInfo info) {
        this.item = item;
        this.meta = meta;
        this.info = info;
    }

    public ItemStack getInfoStack() {
        return new ItemStack(this.item, 1, this.meta);
    }

    public boolean isValidItem(ItemStack stack) {
        return StackUtils.areStacksSimilar((ItemStack)stack, (ItemStack)this.getInfoStack());
    }

    public boolean canPlayerSee(EntityPlayer player) {
        if (Loader.isModLoaded((String)"baubles") && this.hasBauble(player)) {
            return true;
        }
        return PlayerUtils.playerHasItem((EntityPlayer)player, (Item)this.item, (int)this.meta);
    }

    public void getInfo(World world, EntityPlayer player, List<String> info, List<String> debug) {
        this.info.applyInfo(world, player, info, debug);
    }

    private static void addDateInfo(World world, List<String> infoList) {
        MCDate date = new MCDate(world);
        infoList.add(date.getLocalizedMonthName() + " " + date.getDay() + ", " + date.getYear());
    }

    private static void addChunkInfo(World world, EntityPlayer player, List<String> info) {
        Chunk chunk = world.func_175726_f(player.func_180425_c());
        info.add(String.format("Chunk X: %d y:%d", chunk.field_76635_g, chunk.field_76647_h));
    }

    private static void addDirectionInfo(World world, EntityPlayer player, List<String> info) {
        int yaw = MathHelper.func_76141_d((float)(player.field_70177_z % 360.0f));
        for (IntercardinalDirection direction : IntercardinalDirection.values()) {
            if (!direction.isDirection(yaw)) continue;
            info.add(String.format("Direction: %s (%d)", direction.getShorthand(), yaw));
            break;
        }
    }

    @Optional.Method(modid="baubles")
    private boolean hasBauble(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        for (int slot = 0; slot < baubles.getSlots(); ++slot) {
            if (!this.isValidItem(baubles.getStackInSlot(slot))) continue;
            return true;
        }
        return false;
    }
}

