/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.events;

import com.bloodnbonesgaming.bnbgamingcore.events.MapGenEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.MapGenStructureEvent;
import com.bloodnbonesgaming.bnbgamingcore.events.WorldProviderEvent;
import com.bloodnbonesgaming.dimensionalcontrol.DimensionalControl;
import com.bloodnbonesgaming.dimensionalcontrol.config.ConfigurationManager;
import com.bloodnbonesgaming.dimensionalcontrol.config.DimensionDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.config.chunkprovider.ChunkGeneratorDefinition;
import com.bloodnbonesgaming.dimensionalcontrol.util.MapGenNames;
import com.bloodnbonesgaming.dimensionalcontrol.util.WorldInfoCustom;
import com.google.common.collect.MapMaker;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CoreEventHandler {
    private static Map<MapGenBase, World> mapGenWorldMap = new MapMaker().weakKeys().makeMap();

    @SubscribeEvent
    public void onRegisterWorldPre(WorldProviderEvent.RegisterWorld.Pre event) {
        if (ConfigurationManager.getInstance() != null && (ConfigurationManager.getInstance().isWorldInfoChanged() || ConfigurationManager.getInstance().getWorldInfoDefinition(event.getWorldProvider().getDimension()) != null)) {
            World world = event.getWorld();
            WorldProvider provider = event.getWorldProvider();
            if (!(world.field_72986_A instanceof WorldInfoCustom)) {
                DimensionalControl.instance.getLog().debug((Object)("Wrapping WorldInfo " + world.field_73011_w.getDimension() + " " + provider.getDimension()));
                world.field_72986_A = new WorldInfoCustom(world, world.field_72986_A, provider.getDimension());
            } else {
                DimensionalControl.instance.getLog().debug((Object)("ReWrapping WorldInfo " + world.field_73011_w.getDimension() + " " + provider.getDimension()));
                world.field_72986_A = new WorldInfoCustom(world, ((WorldInfoCustom)world.field_72986_A).getParent(), provider.getDimension());
            }
        }
    }

    @SubscribeEvent
    public void onRegisterWorldPost(WorldProviderEvent.RegisterWorld.Post event) {
        if (ConfigurationManager.getInstance() != null) {
            BiomeProvider biomeProvider;
            World world = event.getWorldProvider().field_76579_a;
            DimensionDefinition definition = ConfigurationManager.getInstance().getDimensionDefinition(world.field_73011_w.getDimension());
            if (definition != null && (biomeProvider = definition.getBiomeProvider(event.getWorldProvider().field_76579_a)) != null) {
                event.getWorldProvider().field_76578_c = biomeProvider;
            }
        }
    }

    @SubscribeEvent
    public void onCreateChunkGenerator(WorldProviderEvent.CreateChunkGenerator event) {
        IChunkGenerator generator;
        DimensionDefinition definition;
        if (ConfigurationManager.getInstance() != null && (definition = ConfigurationManager.getInstance().getDimensionDefinition(event.getWorldProvider().getDimension())) != null && (generator = definition.getChunkGenerator(event.getWorldProvider().field_76579_a)) != null) {
            event.setChunkGenerator(generator);
        }
    }

    public static void clearMapGenWorldMap() {
        mapGenWorldMap.clear();
    }

    @SubscribeEvent
    public void onMapGenEvent(MapGenEvent event) {
        if (ConfigurationManager.getInstance() != null) {
            MapGenNames name;
            ChunkGeneratorDefinition chunkGeneratorDefinition;
            World world = event.getWorld();
            if (world != null) {
                mapGenWorldMap.put(event.getMapGen(), world);
            } else {
                world = mapGenWorldMap.get(event.getMapGen());
            }
            DimensionDefinition definition = ConfigurationManager.getInstance().getDimensionDefinition(world.field_73011_w.getDimension());
            if (definition != null && (chunkGeneratorDefinition = definition.getChunkGeneratorDefinition()) != null && (name = MapGenNames.getNameForClass(event.getMapGen().getClass().getName())) != null && chunkGeneratorDefinition.shouldDisableMapGen(name)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onMapGenStructureEvent(MapGenStructureEvent event) {
        if (ConfigurationManager.getInstance() != null) {
            MapGenNames name;
            ChunkGeneratorDefinition chunkGeneratorDefinition;
            World world = event.getWorld();
            if (world != null) {
                mapGenWorldMap.put((MapGenBase)event.getStructure(), world);
            } else {
                world = mapGenWorldMap.get(event.getStructure());
            }
            if (world == null) {
                return;
            }
            DimensionDefinition definition = ConfigurationManager.getInstance().getDimensionDefinition(world.field_73011_w.getDimension());
            if (definition != null && (chunkGeneratorDefinition = definition.getChunkGeneratorDefinition()) != null && (name = MapGenNames.getNameForClass(event.getStructure().getClass().getName())) != null && chunkGeneratorDefinition.shouldDisableMapGen(name)) {
                event.setCanceled(true);
            }
        }
    }
}

