/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.dimensionalcontrol.config;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.WorldType;

@ScriptClassDocumentation(documentationFile="./config/dimensionalcontrol/documentation/worldinfo/WorldInfo", classExplaination="Not all options tested for dimension specific use. Some options may have unforseen results when used dimension specific.")
public class WorldInfoDefinition {
    private Long seed;
    private Integer spawnX;
    private Integer spawnY;
    private Integer spawnZ;
    private Boolean thundering;
    private Boolean raining;
    private Boolean mapFeaturesEnabled;
    private Boolean hardcoreEnabled;
    private WorldType terrainType;
    private String generatorOptions;
    private Boolean commandsAllowed;
    private Double borderCenterX;
    private Double borderCenterZ;
    private Double borderSize;
    private Long borderLerpTime;
    private Double borderLerpTarget;
    private Double borderSafeZone;
    private Double borderDamagePerBlock;
    private Integer borderWarningDistance;
    private Integer borderWarningTime;
    private EnumDifficulty difficulty;
    private Boolean difficultyLocked;

    public Long getSeed() {
        return this.seed;
    }

    @ScriptMethodDocumentation(args="Long", usage="seed", notes="Sets the world seed.")
    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public Integer getSpawnX() {
        return this.spawnX;
    }

    public void setSpawnX(Integer spawnX) {
        this.spawnX = spawnX;
    }

    public Integer getSpawnY() {
        return this.spawnY;
    }

    public void setSpawnY(Integer spawnY) {
        this.spawnY = spawnY;
    }

    public Integer getSpawnZ() {
        return this.spawnZ;
    }

    public void setSpawnZ(Integer spawnZ) {
        this.spawnZ = spawnZ;
    }

    public Boolean getThundering() {
        return this.thundering;
    }

    @ScriptMethodDocumentation(args="Boolean", usage="", notes="Sets permanent thundering.")
    public void setThundering(Boolean thundering) {
        this.thundering = thundering;
    }

    public Boolean getRaining() {
        return this.raining;
    }

    @ScriptMethodDocumentation(args="Boolean", usage="", notes="Sets permanent raining.")
    public void setRaining(Boolean raining) {
        this.raining = raining;
    }

    public Boolean getMapFeaturesEnabled() {
        return this.mapFeaturesEnabled;
    }

    @ScriptMethodDocumentation(args="Boolean", usage="", notes="Sets if map features are enabled.")
    public void setMapFeaturesEnabled(Boolean mapFeaturesEnabled) {
        this.mapFeaturesEnabled = mapFeaturesEnabled;
    }

    public Boolean getHardcoreEnabled() {
        return this.hardcoreEnabled;
    }

    public void setHardcoreEnabled(Boolean hardcoreEnabled) {
        this.hardcoreEnabled = hardcoreEnabled;
    }

    public WorldType getTerrainType() {
        return this.terrainType;
    }

    @ScriptMethodDocumentation(args="String", usage="WorldType ID", notes="Sets the world type.")
    public void setWorldType(String worldType) {
        WorldType type = WorldType.func_77130_a((String)worldType);
        if (type != null) {
            this.terrainType = type;
        }
    }

    public String getGeneratorOptions() {
        return this.generatorOptions;
    }

    @ScriptMethodDocumentation(args="String", usage="vanilla generation options string", notes="Sets the generator options string. This is the string used by the vanilla Customized world type for customizing the world.")
    public void setGeneratorOptions(String generatorOptions) {
        this.generatorOptions = generatorOptions;
    }

    public Boolean getCommandsAllowed() {
        return this.commandsAllowed;
    }

    @ScriptMethodDocumentation(args="Boolean", usage="", notes="Sets if commands are allowed.")
    public void setCommandsAllowed(Boolean commandsAllowed) {
        this.commandsAllowed = commandsAllowed;
    }

    public Double getBorderCenterX() {
        return this.borderCenterX;
    }

    public void setBorderCenterX(Double borderCenterX) {
        this.borderCenterX = borderCenterX;
    }

    public Double getBorderCenterZ() {
        return this.borderCenterZ;
    }

    public void setBorderCenterZ(Double borderCenterZ) {
        this.borderCenterZ = borderCenterZ;
    }

    public Double getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(Double borderSize) {
        this.borderSize = borderSize;
    }

    public Long getBorderLerpTime() {
        return this.borderLerpTime;
    }

    public void setBorderLerpTime(Long borderLerpTime) {
        this.borderLerpTime = borderLerpTime;
    }

    public Double getBorderLerpTarget() {
        return this.borderLerpTarget;
    }

    public void setBorderLerpTarget(Double borderLerpTarget) {
        this.borderLerpTarget = borderLerpTarget;
    }

    public Double getBorderSafeZone() {
        return this.borderSafeZone;
    }

    public void setBorderSafeZone(Double borderSafeZone) {
        this.borderSafeZone = borderSafeZone;
    }

    public Double getBorderDamagePerBlock() {
        return this.borderDamagePerBlock;
    }

    public void setBorderDamagePerBlock(Double borderDamagePerBlock) {
        this.borderDamagePerBlock = borderDamagePerBlock;
    }

    public Integer getBorderWarningDistance() {
        return this.borderWarningDistance;
    }

    public void setBorderWarningDistance(Integer borderWarningDistance) {
        this.borderWarningDistance = borderWarningDistance;
    }

    public Integer getBorderWarningTime() {
        return this.borderWarningTime;
    }

    public void setBorderWarningTime(Integer borderWarningTime) {
        this.borderWarningTime = borderWarningTime;
    }

    public EnumDifficulty getDifficulty() {
        return this.difficulty;
    }

    @ScriptMethodDocumentation(args="String", usage="difficulty", notes="Sets the difficulty. Options are \"Peaceful\", \"Easy\", \"Normal\", \"Hard\".")
    public void setDifficulty(String difficulty) {
        EnumDifficulty enumDifficulty = EnumDifficulty.valueOf((String)difficulty.toUpperCase());
        if (enumDifficulty != null) {
            this.difficulty = enumDifficulty;
        }
    }

    public Boolean getDifficultyLocked() {
        return this.difficultyLocked;
    }

    @ScriptMethodDocumentation(args="Boolean", usage="", notes="Sets if the difficulty is locked.")
    public void setDifficultyLocked(Boolean difficultyLocked) {
        this.difficultyLocked = difficultyLocked;
    }
}

