/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers.tools;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.IActivatorModule;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleDrillIntelligence;
import vswe.stevescarts.modules.addons.ModuleHeightControl;
import vswe.stevescarts.modules.addons.ModuleIncinerator;
import vswe.stevescarts.modules.addons.ModuleLiquidSensors;
import vswe.stevescarts.modules.addons.ModuleOreTracker;
import vswe.stevescarts.modules.storages.chests.ModuleChest;
import vswe.stevescarts.modules.workers.tools.ModuleTool;

public abstract class ModuleDrill
extends ModuleTool
implements IActivatorModule {
    private ModuleDrillIntelligence intelligence;
    private ModuleLiquidSensors liquidsensors;
    private ModuleOreTracker tracker;
    private boolean hasHeightController;
    private byte sensorLight = 1;
    private float drillRotation;
    private int miningCoolDown;
    private int[] buttonRect = new int[]{15, 30, 24, 12};
    private boolean setup;
    private DataParameter<Boolean> IS_MINING;
    private DataParameter<Boolean> IS_ENABLED;

    public ModuleDrill(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public byte getWorkPriority() {
        return 50;
    }

    @Override
    public void init() {
        super.init();
        for (ModuleBase module : this.getCart().getModules()) {
            if (module instanceof ModuleDrillIntelligence) {
                this.intelligence = (ModuleDrillIntelligence)module;
            }
            if (module instanceof ModuleLiquidSensors) {
                this.liquidsensors = (ModuleLiquidSensors)module;
            }
            if (module instanceof ModuleOreTracker) {
                this.tracker = (ModuleOreTracker)module;
            }
            if (!(module instanceof ModuleHeightControl)) continue;
            this.hasHeightController = true;
        }
    }

    @Override
    public boolean work() {
        World world = this.getCart().field_70170_p;
        if (!this.isDrillEnabled()) {
            this.stopDrill();
            this.stopWorking();
            return false;
        }
        if (!this.doPreWork()) {
            this.stopDrill();
            this.stopWorking();
        }
        if (this.isBroken()) {
            return false;
        }
        BlockPos next = this.getNextblock();
        int[] range = this.mineRange();
        for (int holeY = range[1]; holeY >= range[0]; --holeY) {
            for (int holeX = -this.blocksOnSide(); holeX <= this.blocksOnSide(); ++holeX) {
                BlockPos mine;
                if (!this.isMiningSpotAllowed(next, holeX, holeY, range) || !this.mineBlockAndRevive(world, mine = next.func_177982_a(this.getCart().z() != next.func_177952_p() ? holeX : 0, holeY, this.getCart().x() != next.func_177958_n() ? holeX : 0), next, holeX, holeY)) continue;
                return true;
            }
        }
        BlockPos pos = next.func_177982_a(0, range[0], 0);
        if (this.countsAsAir(pos) && !this.isValidForTrack(pos, true) && this.mineBlockAndRevive(world, pos.func_177977_b(), next, 0, range[0] - 1)) {
            return true;
        }
        this.stopWorking();
        this.stopDrill();
        return false;
    }

    private boolean isMiningSpotAllowed(BlockPos next, int holeX, int holeY, int[] range) {
        int maxHeight = SCConfig.drillSize * 2 + 1 - (this.hasHeightController ? (range[2] == 0 ? -1 : 1) : 0);
        if (Math.abs(holeX) <= SCConfig.drillSize && holeY <= maxHeight) {
            return this.intelligence == null || this.intelligence.isActive(holeX + this.blocksOnSide(), holeY, range[2], next.func_177958_n() > this.getCart().x() || next.func_177952_p() < this.getCart().z());
        }
        return false;
    }

    private int[] mineRange() {
        BlockPos next = this.getNextblock();
        int yTarget = this.getCart().getYTarget();
        if (BlockRailBase.func_176562_d((World)this.getCart().field_70170_p, (BlockPos)next) || BlockRailBase.func_176562_d((World)this.getCart().field_70170_p, (BlockPos)next.func_177977_b())) {
            return new int[]{0, this.blocksOnTop() - 1, 1};
        }
        if (next.func_177956_o() > yTarget) {
            return new int[]{-1, this.blocksOnTop() - 1, 1};
        }
        if (next.func_177956_o() < yTarget) {
            return new int[]{1, this.blocksOnTop() + 1, 0};
        }
        return new int[]{0, this.blocksOnTop() - 1, 1};
    }

    protected abstract int blocksOnTop();

    protected abstract int blocksOnSide();

    public int getAreaWidth() {
        return this.blocksOnSide() * 2 + 1;
    }

    public int getAreaHeight() {
        return this.blocksOnTop();
    }

    private boolean mineBlockAndRevive(World world, BlockPos coord, BlockPos next, int holeX, int holeY) {
        if (this.mineBlock(world, coord, next, holeX, holeY, false)) {
            return true;
        }
        if (this.isDead()) {
            this.revive();
            return true;
        }
        return false;
    }

    protected boolean mineBlock(World world, BlockPos coord, BlockPos next, int holeX, int holeY, boolean flag) {
        int fortune;
        BlockPos target;
        if (this.tracker != null && (target = this.tracker.findBlockToMine(this, coord)) != null) {
            coord = target;
        }
        Object valid = this.isValidBlock(world, coord, holeX, holeY, flag);
        TileEntity storage = null;
        if (valid instanceof TileEntity) {
            storage = (TileEntity)valid;
        } else if (valid == null) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(coord);
        Block block = blockState.func_177230_c();
        float h = blockState.func_185887_b(world, coord);
        if (h < 0.0f) {
            h = 0.0f;
        }
        if (storage != null) {
            for (int i = 0; i < ((IInventory)storage).func_70302_i_(); ++i) {
                ItemStack iStack = ((IInventory)storage).func_70301_a(i);
                if (iStack.func_190926_b()) continue;
                if (!this.minedItem(world, iStack, next)) {
                    return false;
                }
                ((IInventory)storage).func_70299_a(i, ItemStack.field_190927_a);
            }
        }
        int n = fortune = this.enchanter != null ? this.enchanter.getFortuneLevel() : 0;
        if (this.shouldSilkTouch(blockState, coord)) {
            ItemStack item = this.getSilkTouchedItem(blockState);
            if (!item.func_190926_b() && !this.minedItem(world, item, next)) {
                return false;
            }
            world.func_175698_g(coord);
        } else if (block.getDrops((IBlockAccess)world, coord, blockState, fortune).size() != 0) {
            List stacks = block.getDrops((IBlockAccess)world, coord, blockState, fortune);
            boolean shouldRemove = false;
            for (int j = 0; j < stacks.size(); ++j) {
                if (!this.minedItem(world, (ItemStack)stacks.get(j), next)) {
                    return false;
                }
                shouldRemove = true;
            }
            if (shouldRemove) {
                world.func_175698_g(coord);
            }
        } else {
            world.func_175698_g(coord);
        }
        this.damageTool(1 + (int)h);
        this.startWorking(this.getTimeToMine(h));
        this.startDrill();
        return true;
    }

    protected boolean minedItem(World world, @Nonnull ItemStack iStack, BlockPos Coords) {
        EntityItem entityitem;
        if (iStack.func_190926_b() || iStack.func_190916_E() <= 0) {
            return true;
        }
        for (ModuleBase module : this.getCart().getModules()) {
            if (!(module instanceof ModuleIncinerator)) continue;
            ((ModuleIncinerator)module).incinerate(iStack);
            if (iStack.func_190916_E() > 0) continue;
            return true;
        }
        int size = iStack.func_190916_E();
        this.getCart().addItemToChest(iStack);
        if (iStack.func_190916_E() == 0) {
            return true;
        }
        boolean hasChest = false;
        for (ModuleBase module2 : this.getCart().getModules()) {
            if (!(module2 instanceof ModuleChest)) continue;
            hasChest = true;
            break;
        }
        if (!hasChest) {
            entityitem = new EntityItem(world, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
            entityitem.field_70159_w = (float)(this.getCart().x() - Coords.func_177958_n()) / 10.0f;
            entityitem.field_70181_x = 0.15f;
            entityitem.field_70179_y = (float)(this.getCart().z() - Coords.func_177952_p()) / 10.0f;
            world.func_72838_d((Entity)entityitem);
            return true;
        }
        if (iStack.func_190916_E() != size) {
            entityitem = new EntityItem(world, this.getCart().field_70165_t, this.getCart().field_70163_u, this.getCart().field_70161_v, iStack);
            entityitem.field_70159_w = (float)(this.getCart().z() - Coords.func_177952_p()) / 10.0f;
            entityitem.field_70181_x = 0.15f;
            entityitem.field_70179_y = (float)(this.getCart().x() - Coords.func_177958_n()) / 10.0f;
            world.func_72838_d((Entity)entityitem);
            return true;
        }
        return false;
    }

    private int getTimeToMine(float hardness) {
        int efficiency = this.enchanter != null ? this.enchanter.getEfficiencyLevel() : 0;
        return (int)((double)(this.getTimeMult() * hardness) / Math.pow(1.3f, efficiency)) + (this.liquidsensors != null ? 2 : 0);
    }

    protected abstract float getTimeMult();

    public Object isValidBlock(World world, BlockPos pos, int holeX, int holeY, boolean flag) {
        TileEntity tileentity;
        if (!flag && BlockRailBase.func_176562_d((World)world, (BlockPos)pos) || BlockRailBase.func_176562_d((World)world, (BlockPos)pos.func_177984_a())) {
            return null;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == null) {
            return null;
        }
        if (block == Blocks.field_150350_a) {
            return null;
        }
        if (block == Blocks.field_150357_h) {
            return null;
        }
        if (block instanceof BlockLiquid) {
            return null;
        }
        if (blockState.func_185887_b(world, pos) < 0.0f) {
            return null;
        }
        if (!(holeX == 0 && holeY <= 0 || block != Blocks.field_150478_aa && block != Blocks.field_150488_af && block != Blocks.field_150429_aA && block != Blocks.field_150437_az && block != Blocks.field_150416_aS && block != Blocks.field_150413_aR && block != Blocks.field_150455_bV && block != Blocks.field_150441_bU && block != ModBlocks.MODULE_TOGGLER.getBlock())) {
            return null;
        }
        if (block instanceof BlockContainer && IInventory.class.isInstance(tileentity = world.func_175625_s(pos))) {
            if (holeX != 0 || holeY > 0) {
                return null;
            }
            return tileentity;
        }
        if (this.liquidsensors != null) {
            if (this.liquidsensors.isDangerous(this, pos.func_177982_a(0, 1, 0), true) || this.liquidsensors.isDangerous(this, pos.func_177982_a(1, 0, 0), false) || this.liquidsensors.isDangerous(this, pos.func_177982_a(-1, 0, 0), false) || this.liquidsensors.isDangerous(this, pos.func_177982_a(0, 0, 1), false) || this.liquidsensors.isDangerous(this, pos.func_177982_a(0, 0, -1), false)) {
                this.sensorLight = (byte)3;
                return null;
            }
            this.sensorLight = (byte)2;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().func_130014_f_().field_72995_K && !this.setup) {
            if (this.isPlaceholder() || !this.getDw(this.IS_MINING).booleanValue()) {
                this.drillRotation = 0.0f;
                this.miningCoolDown = 10;
            }
            this.setup = true;
        }
        if (this.getCart().hasFuel() && this.isMining() || this.miningCoolDown < 10) {
            this.drillRotation = (float)((double)(this.drillRotation + 0.03f * (float)(10 - this.miningCoolDown)) % (Math.PI * 2));
            this.miningCoolDown = this.isMining() ? 0 : ++this.miningCoolDown;
        }
        if (!this.getCart().field_70170_p.field_72995_K && this.liquidsensors != null) {
            byte data = this.sensorLight;
            if (this.isDrillSpinning()) {
                data = (byte)(data | 4);
            }
            this.liquidsensors.getInfoFromDrill(data);
            this.sensorLight = 1;
        }
    }

    protected void startDrill() {
        this.updateDw(this.IS_MINING, true);
    }

    protected void stopDrill() {
        this.updateDw(this.IS_MINING, false);
    }

    protected boolean isMining() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getDrillSpinning();
        }
        return this.getDw(this.IS_MINING);
    }

    protected boolean isDrillSpinning() {
        return this.isMining() || this.miningCoolDown < 10;
    }

    @Override
    public void initDw() {
        this.IS_MINING = this.createDw(DataSerializers.field_187198_h);
        this.IS_ENABLED = this.createDw(DataSerializers.field_187198_h);
        this.registerDw(this.IS_MINING, false);
        this.registerDw(this.IS_ENABLED, true);
    }

    @Override
    public int numberOfDataWatchers() {
        return 2;
    }

    public float getDrillRotation() {
        return this.drillRotation;
    }

    private boolean isDrillEnabled() {
        return this.getDw(this.IS_ENABLED);
    }

    public void setDrillEnabled(boolean val) {
        this.updateDw(this.IS_ENABLED, val);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.setDrillEnabled(!this.isDrillEnabled());
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.TOOLS.DRILL.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        super.drawBackground(gui, x, y);
        ResourceHelper.bindResource("/gui/drill.png");
        int imageID = this.isDrillEnabled() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        super.drawMouseOver(gui, x, y);
        this.drawStringOnMouseOver(gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        return Localization.MODULES.TOOLS.TOGGLE.translate(this.isDrillEnabled() ? "1" : "0");
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        super.Save(tagCompound, id);
        tagCompound.func_74757_a(this.generateNBTName("DrillEnabled", id), this.isDrillEnabled());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        super.Load(tagCompound, id);
        this.setDrillEnabled(tagCompound.func_74767_n(this.generateNBTName("DrillEnabled", id)));
    }

    @Override
    public void doActivate(int id) {
        this.setDrillEnabled(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setDrillEnabled(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.isDrillEnabled();
    }
}

