/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.mjrlegendslib.util;

import com.mjr.mjrlegendslib.world.features.WorldGenCustomLake;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenUtilities {
    public static void generateStructure(WorldGenerator worldGen, World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o();
        worldGen.func_180709_b(world, rand, new BlockPos(x, y, z));
    }

    public static void generateStructureWithRandomY(WorldGenerator worldGen, World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        WorldGenUtilities.generateStructureWithSetY(worldGen, world, rand, new BlockPos(x, pos.func_177956_o(), z), pos.func_177956_o());
    }

    public static void generateStructureWithSetY(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int y) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        worldGen.func_180709_b(world, rand, new BlockPos(x, y, z));
    }

    public static void generateStructureWithRangeY(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int minY, int maxY) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        worldGen.func_180709_b(world, rand, new BlockPos(x, rand.nextInt(maxY) + minY, z));
    }

    public static void generateStructureWithRandom(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int randomAmountXZ) {
        WorldGenUtilities.generateStructure(worldGen, world, rand, pos.func_177982_a(rand.nextInt(randomAmountXZ), 0, rand.nextInt(randomAmountXZ)));
    }

    public static void generateStructureWithRandom(WorldGenerator worldGen, World world, Random rand, BlockPos pos, int randomAmountXZ, int randomAmountY) {
        WorldGenUtilities.generateStructureWithRandomY(worldGen, world, rand, pos.func_177982_a(rand.nextInt(randomAmountXZ), rand.nextInt(randomAmountY), rand.nextInt(randomAmountXZ)));
    }

    public static void generateLake(World world, Random rand, BlockPos pos, Block fluid, Block block) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o() - 2;
        new WorldGenCustomLake(fluid).generate(world, rand, new BlockPos(x, y, z), block);
    }

    public static void generateLake(World world, Random rand, BlockPos pos, Block fluid, IBlockState block) {
        int x = pos.func_177958_n() + 8;
        int z = pos.func_177952_p() + 8;
        int y = world.func_175672_r(new BlockPos(x, 0, z)).func_177956_o() - 2;
        new WorldGenCustomLake(fluid).generate(world, rand, new BlockPos(x, y, z), block);
    }

    public static boolean checkValidSpawn(World world, BlockPos position, int checkSize, int loadedCheckSize) {
        if (!world.func_175697_a(position, loadedCheckSize)) {
            return false;
        }
        position = position.func_177982_a(0, 0, 0);
        while (position.func_177956_o() > 5 && world.func_175623_d(position) || world.func_180495_p(position).func_185904_a().func_76224_d()) {
            position = position.func_177977_b();
        }
        if (position.func_177956_o() <= 4) {
            return false;
        }
        for (int i = -checkSize; i <= checkSize; ++i) {
            for (int j = -checkSize; j <= checkSize; ++j) {
                if ((!world.func_175623_d(position.func_177982_a(i, -1, j)) || !world.func_175623_d(position.func_177982_a(i, -2, j))) && (!world.func_180495_p(position.func_177982_a(i, -1, j)).func_185904_a().func_76224_d() || !world.func_180495_p(position.func_177982_a(i, -2, j)).func_185904_a().func_76224_d())) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean checkValidSpawn(World world, BlockPos position, int size) {
        return WorldGenUtilities.checkValidSpawn(world, position, size, size);
    }
}

