/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.util;

import com.google.common.collect.Iterables;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class BlockCompatHelper {
    private static final ResourceLocation ic2TileBlock = new ResourceLocation("ic2", "te");
    private static final Method getITeBlockIc2;
    private static final Method getTeClassIc2;
    private static final Method getTeBlockState;
    private static final Method getITEgetSupportedFacings;
    private static final Method getTEBlockId;
    private static final Method getITeBlockIc2Class;
    private static final IProperty<EnumFacing> facingPropertyField;
    private static final Field teBlockItemField;

    @Nonnull
    @Optional.Method(modid="ic2")
    public static ItemStack tryGetIC2MachineStack(IBlockState state, Object tile) {
        try {
            Object tileITBlock = getITeBlockIc2Class.invoke(null, tile.getClass());
            int id = (Integer)getTEBlockId.invoke(tileITBlock, new Object[0]);
            if (id != -1) {
                Item i = (Item)teBlockItemField.get(state.func_177230_c());
                return new ItemStack(i, 1, id);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static Tuple<IBlockState, TileEntity> transformState(IBlockState state, @Nullable NBTTagCompound matchTag, BlockArray.TileInstantiateContext context) {
        TileEntity te;
        Tuple<IBlockState, TileEntity> ret;
        ResourceLocation blockRes = state.func_177230_c().getRegistryName();
        if (ic2TileBlock.equals((Object)blockRes) && matchTag != null && (ret = BlockCompatHelper.tryRecoverTileState(state, matchTag, context)) != null) {
            return ret;
        }
        TileEntity tileEntity = te = state.func_177230_c().hasTileEntity(state) ? state.func_177230_c().createTileEntity(context.getWorld(), state) : null;
        if (te != null) {
            context.apply(te);
        }
        return new Tuple((Object)state, (Object)te);
    }

    @Optional.Method(modid="ic2")
    private static Tuple<IBlockState, TileEntity> tryRecoverTileState(IBlockState state, @Nonnull NBTTagCompound matchTag, BlockArray.TileInstantiateContext context) {
        ResourceLocation key;
        if (getTeClassIc2 == null || getITeBlockIc2 == null || getTeBlockState == null || getITEgetSupportedFacings == null || facingPropertyField == null) {
            return null;
        }
        ResourceLocation ic2TileBlock = new ResourceLocation("ic2", "te");
        if (ic2TileBlock.equals((Object)state.func_177230_c().getRegistryName()) && matchTag.func_74764_b("id") && (key = new ResourceLocation(matchTag.func_74779_i("id"))).func_110624_b().equalsIgnoreCase("ic2")) {
            String name = key.func_110623_a();
            try {
                TileEntity te;
                Object o = getITeBlockIc2.invoke(null, name);
                Object oClazz = getTeClassIc2.invoke(o, new Object[0]);
                if (oClazz instanceof Class && (te = (TileEntity)((Class)oClazz).newInstance()) != null) {
                    context.apply(te);
                    te.func_145839_a(matchTag);
                    IBlockState st = (IBlockState)getTeBlockState.invoke((Object)te, new Object[0]);
                    EnumFacing applicable = (EnumFacing)Iterables.getFirst((Iterable)((Collection)getITEgetSupportedFacings.invoke(o, new Object[0])), (Object)EnumFacing.NORTH);
                    st = st.func_177226_a(facingPropertyField, (Comparable)applicable);
                    return new Tuple((Object)st, (Object)te);
                }
            }
            catch (Throwable tr) {
                tr.printStackTrace();
            }
        }
        return null;
    }

    static {
        Method m = null;
        Method m2 = null;
        Method m3 = null;
        Method m4 = null;
        Method m5 = null;
        Method m6 = null;
        IProperty f = null;
        Field f1 = null;
        if (Loader.isModLoaded((String)"ic2")) {
            try {
                Class<?> c = Class.forName("ic2.core.block.TeBlockRegistry");
                m = c.getDeclaredMethod("get", String.class);
                m6 = c.getDeclaredMethod("get", Class.class);
                c = Class.forName("ic2.core.block.ITeBlock");
                m2 = c.getDeclaredMethod("getTeClass", new Class[0]);
                m4 = c.getDeclaredMethod("getSupportedFacings", new Class[0]);
                c = Class.forName("ic2.core.block.state.IIdProvider");
                m5 = c.getDeclaredMethod("getId", new Class[0]);
                m5.setAccessible(true);
                c = Class.forName("ic2.core.block.TileEntityBlock");
                m3 = c.getDeclaredMethod("getBlockState", new Class[0]);
                c = Class.forName("ic2.core.block.BlockTileEntity");
                f1 = c.getDeclaredField("item");
                f1.setAccessible(true);
                f = (IProperty)c.getDeclaredField("facingProperty").get(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        getITeBlockIc2 = m;
        getITeBlockIc2Class = m6;
        getTeClassIc2 = m2;
        getTeBlockState = m3;
        facingPropertyField = f;
        getITEgetSupportedFacings = m4;
        getTEBlockId = m5;
        teBlockItemField = f1;
    }
}

