/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.block.prop;

import hellfirepvp.modularmachinery.ModularMachinery;
import hellfirepvp.modularmachinery.common.tiles.base.TileEntitySynchronized;
import hellfirepvp.modularmachinery.common.util.HybridGasTank;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Optional;

public enum FluidHatchSize implements IStringSerializable
{
    TINY(100),
    SMALL(400),
    NORMAL(1000),
    REINFORCED(2000),
    BIG(4500),
    HUGE(8000),
    LUDICROUS(16000),
    VACUUM(32000);

    private int size;
    private final int defaultConfigurationValue;

    private FluidHatchSize(int defaultConfigurationValue) {
        this.defaultConfigurationValue = defaultConfigurationValue;
    }

    public HybridTank buildTank(TileEntitySynchronized tileEntity, boolean canFill, boolean canDrain) {
        HybridTank tank = ModularMachinery.isMekanismLoaded ? this.buildMekTank(tileEntity) : this.buildDefaultTank(tileEntity);
        tank.setCanFill(canFill);
        tank.setCanDrain(canDrain);
        return tank;
    }

    private HybridTank buildDefaultTank(final TileEntitySynchronized tileEntity) {
        return new HybridTank(this.size){

            protected void onContentsChanged() {
                super.onContentsChanged();
                tileEntity.markForUpdate();
            }
        };
    }

    @Optional.Method(modid="mekanism")
    private HybridTank buildMekTank(final TileEntitySynchronized tileEntity) {
        return new HybridGasTank(this.size){

            protected void onContentsChanged() {
                super.onContentsChanged();
                tileEntity.markForUpdate();
            }
        };
    }

    public int getSize() {
        return this.size;
    }

    public String func_176610_l() {
        return this.name().toLowerCase();
    }

    public static void loadSizeFromConfig(Configuration cfg) {
        for (FluidHatchSize size : FluidHatchSize.values()) {
            size.size = cfg.getInt("size", "fluidhatch." + size.name().toUpperCase(), size.defaultConfigurationValue, 1, Integer.MAX_VALUE, "Defines the tank size for the size-type of fluid hatch.");
        }
    }
}

