/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.util;

import com.google.common.collect.HashMultimap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TeaType {
    public static HashMap<String, TeaType> TYPES = new HashMap();
    public static final TeaType WHITE = new TeaType("white", new Color(239, 229, 153)).setHasLeaf().setHasWilted();
    public static final TeaType ASSAM = new TeaType("assam", new Color(73, 26, 19)){

        @Override
        public int getWeight(World world, BlockPos pos) {
            return pos.func_177956_o() > 128 ? 100 : 0;
        }
    }.setHasLeaf().setHasWilted();
    public static final TeaType CEYLON = new TeaType("ceylon", new Color(119, 40, 16)){

        @Override
        public int getWeight(World world, BlockPos pos) {
            return pos.func_177956_o() < world.func_181545_F() ? 100 : 0;
        }
    }.setHasLeaf().setHasWilted();
    public static final TeaType GYOKURO = new TeaType("gyokuro", new Color(176, 255, 81)){

        @Override
        public int getWeight(World world, BlockPos pos) {
            return 3.inGoodBiome(world.func_180494_b(pos)) && !world.func_175678_i(pos) && world.func_175699_k(pos) > 10 ? 23 : 0;
        }
    }.setHasLeaf().setHasSoaked();
    public static final TeaType SENCHA = new TeaType("sencha", new Color(124, 182, 24)){

        @Override
        public int getWeight(World world, BlockPos pos) {
            return 4.inGoodBiome(world.func_180494_b(pos)) || 4.inTropical(world.func_180494_b(pos)) ? 30 : 0;
        }
    }.setHasLeaf().setHasSoaked();
    public static final TeaType BANCHA = new TeaType("bancha", new Color(124, 143, 24)){

        @Override
        public int getWeight(World world, BlockPos pos) {
            return 5.inGoodBiome(world.func_180494_b(pos)) || 5.inTropical(world.func_180494_b(pos)) ? 30 : 0;
        }
    }.setHasLeaf().setHasSoaked();
    public static final TeaType TENCHA = new TeaType("tencha", new Color(36, 194, 20)){

        @Override
        public int getWeight(World world, BlockPos pos) {
            return 6.inGoodBiome(world.func_180494_b(pos)) && !world.func_175678_i(pos) && world.func_175699_k(pos) > 10 ? 7 : 0;
        }
    }.setHasLeaf().setHasSoaked();
    public static final TeaType MATCHA = new TeaType("matcha", new Color(36, 194, 20));
    public static final TeaType HOUJICHA = new TeaType("houjicha", new Color(55, 93, 31));
    public static final TeaType NETHER = new TeaType("nether", new Color(190, 25, 25)).setHasLeaf().setHasWilted();
    public static final TeaType END = new TeaType("end", new Color(85, 56, 160)).setHasLeaf().setHasWilted();
    String name;
    boolean hasLeaf;
    int leafColor;
    boolean hasSoaked;
    int soakedColor;
    boolean hasWilted;
    int wiltedColor;
    int powderColor;
    HashMultimap<ItemType, PotionEffect> PositiveEffects = HashMultimap.create();
    HashMultimap<ItemType, PotionEffect> NegativeEffects = HashMultimap.create();

    public TeaType(String name, Color color) {
        this.name = name;
        this.powderColor = color.getRGB();
        this.leafColor = color.getRGB();
        this.soakedColor = color.getRGB();
        this.wiltedColor = color.getRGB();
        TYPES.put(name, this);
    }

    public static TeaType getType(String name) {
        return TYPES.getOrDefault(name, WHITE);
    }

    public static List<TeaType> getTypesByItem(ItemType type) {
        return TYPES.values().stream().filter(tea -> tea.isItemType(type)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static TeaType getByLocation(World world, BlockPos pos, Random rand) {
        ArrayList weightedTeas = TYPES.values().stream().filter(tea -> tea.getWeight(world, pos) > 0).map(tea -> new WeightedTea((TeaType)tea, tea.getWeight(world, pos))).collect(Collectors.toCollection(ArrayList::new));
        return weightedTeas.size() > 0 ? ((WeightedTea)WeightedRandom.func_76271_a((Random)rand, (List)weightedTeas)).getType() : null;
    }

    public boolean isItemType(ItemType type) {
        switch (type) {
            case Leaves: {
                return this.hasLeaf();
            }
            case Soaked: {
                return this.hasSoaked();
            }
            case Wilted: {
                return this.hasWilted();
            }
            case Powder: {
                return true;
            }
        }
        return false;
    }

    public TeaType setHasLeaf() {
        this.hasLeaf = true;
        return this;
    }

    public TeaType setHasLeaf(Color color) {
        this.leafColor = color.getRGB();
        return this.setHasLeaf();
    }

    public TeaType setHasSoaked() {
        this.hasSoaked = true;
        return this;
    }

    public TeaType setHasSoaked(Color color) {
        this.soakedColor = color.getRGB();
        return this.setHasLeaf();
    }

    public TeaType setHasWilted() {
        this.hasWilted = true;
        return this;
    }

    public TeaType setHasWilted(Color color) {
        this.wiltedColor = color.getRGB();
        return this.setHasLeaf();
    }

    public TeaType addPositive(ItemType type, PotionEffect effect) {
        this.PositiveEffects.put((Object)type, (Object)effect);
        return this;
    }

    public TeaType addNegative(ItemType type, PotionEffect effect) {
        this.NegativeEffects.put((Object)type, (Object)effect);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasLeaf() {
        return this.hasLeaf;
    }

    public boolean hasSoaked() {
        return this.hasSoaked;
    }

    public boolean hasWilted() {
        return this.hasWilted;
    }

    public int getLeafColor() {
        return this.leafColor;
    }

    public int getSoakedColor() {
        return this.soakedColor;
    }

    public int getWiltedColor() {
        return this.wiltedColor;
    }

    public int getPowderColor() {
        return this.powderColor;
    }

    public Collection<PotionEffect> getPositiveEffects() {
        return this.PositiveEffects.values();
    }

    public Collection<PotionEffect> getPositiveEffects(ItemType type) {
        return this.PositiveEffects.get((Object)type);
    }

    public Collection<PotionEffect> getNegativeEffects() {
        return this.NegativeEffects.values();
    }

    public Collection<PotionEffect> getNegativeEffects(ItemType type) {
        return this.NegativeEffects.get((Object)type);
    }

    public int getWeight(World world, BlockPos pos) {
        return 0;
    }

    static boolean inGoodBiome(Biome biome) {
        return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.PLAINS) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN);
    }

    static boolean inTropical(Biome biome) {
        return biome.func_76727_i() >= 0.75f || !biome.func_150559_j();
    }

    static {
        WHITE.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76428_l, 200));
        WHITE.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76438_s, 200));
        WHITE.addPositive(ItemType.Wilted, new PotionEffect(MobEffects.field_76424_c, 200));
        WHITE.addNegative(ItemType.Wilted, new PotionEffect(MobEffects.field_76438_s, 200));
        WHITE.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76424_c, 400));
        WHITE.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76438_s, 200));
        ASSAM.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76420_g, 600));
        ASSAM.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76440_q, 400));
        ASSAM.addPositive(ItemType.Wilted, new PotionEffect(MobEffects.field_76420_g, 1200));
        ASSAM.addNegative(ItemType.Wilted, new PotionEffect(MobEffects.field_76436_u, 600));
        ASSAM.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76420_g, 600, 1));
        ASSAM.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76438_s, 400));
        CEYLON.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76427_o, 600));
        CEYLON.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76437_t, 1200));
        CEYLON.addPositive(ItemType.Wilted, new PotionEffect(MobEffects.field_76427_o, 1200));
        CEYLON.addNegative(ItemType.Wilted, new PotionEffect(MobEffects.field_76437_t, 2400));
        CEYLON.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76427_o, 2400));
        CEYLON.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76437_t, 3600));
        GYOKURO.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76439_r, 600));
        GYOKURO.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76437_t, 1200));
        GYOKURO.addPositive(ItemType.Soaked, new PotionEffect(MobEffects.field_76430_j, 600, 1));
        GYOKURO.addNegative(ItemType.Soaked, new PotionEffect(MobEffects.field_76421_d, 2400));
        GYOKURO.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76430_j, 2400));
        GYOKURO.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76436_u, 1200));
        SENCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76424_c, 600));
        SENCHA.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76419_f, 1200));
        SENCHA.addPositive(ItemType.Soaked, new PotionEffect(MobEffects.field_76424_c, 600, 1));
        SENCHA.addNegative(ItemType.Soaked, new PotionEffect(MobEffects.field_76419_f, 2400));
        SENCHA.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76424_c, 2400));
        SENCHA.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76419_f, 1200));
        TENCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76443_y, 400));
        TENCHA.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76421_d, 1200));
        TENCHA.addPositive(ItemType.Soaked, new PotionEffect(MobEffects.field_76443_y, 400, 1));
        TENCHA.addNegative(ItemType.Soaked, new PotionEffect(MobEffects.field_76440_q, 2400));
        TENCHA.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76432_h, 0));
        TENCHA.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76437_t, 1200, 2));
        BANCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76428_l, 400));
        BANCHA.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76440_q, 1200));
        BANCHA.addPositive(ItemType.Soaked, new PotionEffect(MobEffects.field_76428_l, 400, 1));
        BANCHA.addNegative(ItemType.Soaked, new PotionEffect(MobEffects.field_76437_t, 2400));
        BANCHA.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76429_m, 2400, 1));
        BANCHA.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76431_k, 400));
        HOUJICHA.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_188425_z, 1200));
        HOUJICHA.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76440_q, 1200));
        MATCHA.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76438_s, 600));
        MATCHA.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76431_k, 600));
        MATCHA.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76419_f, 600, 2));
        MATCHA.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_76437_t, 600, 1));
        MATCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76428_l, 1200, 1));
        MATCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76422_e, 600));
        MATCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76424_c, 1200));
        MATCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76443_y, 600));
        MATCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76444_x, 12000));
        MATCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76441_p, 3600));
        MATCHA.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76429_m, 1200));
        MATCHA.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76444_x, 1200, 1));
        MATCHA.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_76438_s, 1200));
        NETHER.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76426_n, 600));
        NETHER.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_82731_v, 600));
        NETHER.addPositive(ItemType.Wilted, new PotionEffect(MobEffects.field_76426_n, 600));
        NETHER.addNegative(ItemType.Wilted, new PotionEffect(MobEffects.field_82731_v, 200));
        NETHER.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76426_n, 1200));
        NETHER.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_189112_A, 1200, 2));
        END.addPositive(ItemType.Leaves, new PotionEffect(MobEffects.field_76432_h, 600));
        END.addNegative(ItemType.Leaves, new PotionEffect(MobEffects.field_188424_y, 200));
        END.addPositive(ItemType.Wilted, new PotionEffect(MobEffects.field_76428_l, 600));
        END.addNegative(ItemType.Wilted, new PotionEffect(MobEffects.field_188424_y, 200));
        END.addPositive(ItemType.Powder, new PotionEffect(MobEffects.field_76441_p, 6000));
        END.addNegative(ItemType.Powder, new PotionEffect(MobEffects.field_188424_y, 200));
    }

    public static class WeightedTea
    extends WeightedRandom.Item {
        TeaType type;

        public WeightedTea(TeaType type, int itemWeightIn) {
            super(itemWeightIn);
            this.type = type;
        }

        public TeaType getType() {
            return this.type;
        }
    }

    public static enum ItemType {
        Leaves,
        Soaked,
        Wilted,
        Powder;

    }
}

