/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.tileentity;

import betterwithaddons.block.EriottoMod.BlockNettedScreen;
import betterwithaddons.block.EriottoMod.BlockSlat;
import betterwithaddons.crafting.manager.CraftingManagerFireNet;
import betterwithaddons.crafting.manager.CraftingManagerNet;
import betterwithaddons.crafting.manager.CraftingManagerSandNet;
import betterwithaddons.crafting.manager.CraftingManagerWaterNet;
import betterwithaddons.crafting.recipes.NetRecipe;
import betterwithaddons.tileentity.TileEntityBase;
import betterwithaddons.util.ItemUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityNettedScreen
extends TileEntityBase
implements ITickable {
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.captureDroppedItems();
        }
    }

    public BlockNettedScreen.SifterType getSifterType() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof BlockNettedScreen) {
            return ((BlockNettedScreen)state.func_177230_c()).getSifterType(this.field_145850_b, this.field_174879_c);
        }
        return BlockNettedScreen.SifterType.NONE;
    }

    private CraftingManagerNet getCraftingManager(BlockNettedScreen.SifterType type) {
        switch (type) {
            case WATER: {
                return CraftingManagerWaterNet.getInstance();
            }
            case SAND: {
                return CraftingManagerSandNet.getInstance();
            }
            case FIRE: {
                return CraftingManagerFireNet.getInstance();
            }
        }
        return null;
    }

    public List<EntityItem> getCaptureItems(World worldIn, BlockPos pos) {
        return worldIn.func_175647_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 1.0), EntitySelectors.field_94557_a);
    }

    private void handleSandCase(EntityItem item) {
        ItemStack sandstack = item.func_92059_d().func_77946_l();
        sandstack.func_190918_g(this.increaseSandCount(sandstack.func_190916_E()));
        item.func_92058_a(sandstack);
        if (sandstack.func_190916_E() < 0) {
            item.func_70106_y();
        }
    }

    private boolean canHoldSand() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        return state.func_177230_c() instanceof BlockSlat;
    }

    private int getSandCount() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        return state.func_177230_c() instanceof BlockSlat ? (Integer)state.func_177229_b((IProperty)BlockSlat.SANDFILL) : 0;
    }

    private int increaseSandCount(int n) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        Block slatblock = state.func_177230_c();
        if (slatblock instanceof BlockSlat) {
            int currsand = this.getSandCount();
            int added = Math.min(n, 8 - currsand);
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), slatblock.func_176223_P().func_177226_a((IProperty)BlockSlat.SANDFILL, (Comparable)Integer.valueOf(currsand + added)));
            return added;
        }
        return 0;
    }

    private boolean captureDroppedItems() {
        List<EntityItem> items = this.getCaptureItems(this.field_145850_b, this.field_174879_c);
        if (items.size() > 0) {
            ArrayList<ItemStack> ret;
            NetRecipe recipe;
            for (EntityItem item : items) {
                ItemStack stack = item.func_92059_d();
                if (stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150354_m)) continue;
                this.handleSandCase(item);
            }
            CraftingManagerNet manager = this.getCraftingManager(this.getSifterType());
            if (manager != null && (recipe = manager.getMostValidRecipe(items, this.getSandCount())) != null && (ret = recipe.getOutput()) != null && ret.size() > 0) {
                ItemUtil.consumeItem(items, recipe.input);
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                for (int i = 0; i < ret.size(); ++i) {
                    ItemStack item = (ItemStack)ret.get(i);
                    if (item.func_190926_b()) continue;
                    EntityItem result = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + (i % 2 == 0 ? 1.2f : -0.5f)), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), item.func_77946_l());
                    result.func_174869_p();
                    if (this.field_145850_b.field_72995_K) continue;
                    this.field_145850_b.func_72838_d((Entity)result);
                }
                if (recipe.getSandRequired() > 0) {
                    this.increaseSandCount(-recipe.getSandRequired());
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void writeDataToNBT(NBTTagCompound compound) {
    }

    @Override
    public void readDataFromNBT(NBTTagCompound compound) {
    }
}

