/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.item;

import betterwithaddons.entity.EntityGreatarrow;
import betterwithaddons.item.ItemGreatarrow;
import betterwithaddons.potion.ModPotions;
import betterwithaddons.util.EntityUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemGreatarrowLightning
extends ItemGreatarrow {
    static final float EXTRA_LIGHTNING_DAMAGE = 20.0f;
    NBTTagCompound fireworksEntity = new NBTTagCompound();
    NBTTagCompound fireworksGround;

    public ItemGreatarrowLightning() {
        NBTTagCompound fireworksTagEntity = new NBTTagCompound();
        NBTTagCompound explosionEntity = new NBTTagCompound();
        explosionEntity.func_74757_a("Flicker", true);
        explosionEntity.func_74774_a("Type", (byte)0);
        explosionEntity.func_74783_a("Colors", new int[]{0xF9FFFE});
        explosionEntity.func_74783_a("FadeColors", new int[]{16701501});
        NBTTagList explosionsEntityList = new NBTTagList();
        explosionsEntityList.func_74742_a((NBTBase)explosionEntity);
        fireworksTagEntity.func_74782_a("Explosions", (NBTBase)explosionsEntityList);
        fireworksTagEntity.func_74774_a("Flight", (byte)-100);
        this.fireworksEntity.func_74782_a("Fireworks", (NBTBase)fireworksTagEntity);
        this.fireworksGround = new NBTTagCompound();
        NBTTagCompound fireworksTagGround = new NBTTagCompound();
        NBTTagCompound explosionGround = explosionEntity.func_74737_b();
        explosionGround.func_74774_a("Type", (byte)1);
        NBTTagList explosionsGroundList = new NBTTagList();
        explosionsGroundList.func_74742_a((NBTBase)explosionGround);
        fireworksTagGround.func_74782_a("Explosions", (NBTBase)explosionsGroundList);
        fireworksTagGround.func_74774_a("Flight", (byte)-100);
        this.fireworksGround.func_74782_a("Fireworks", (NBTBase)fireworksTagGround);
    }

    private void makeFireworks(World world, Vec3d pos, NBTTagCompound parameters) {
        if (!world.field_72995_K) {
            ItemStack rocket = new ItemStack(Items.field_151152_bP);
            rocket.func_77982_d(parameters);
            EntityFireworkRocket explosion = new EntityFireworkRocket(world, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, rocket);
            explosion.func_82142_c(true);
            world.func_72838_d((Entity)explosion);
        }
    }

    @Override
    public void hitBlockFinal(EntityGreatarrow arrow) {
        super.hitBlockFinal(arrow);
        if (!arrow.field_70128_L && !arrow.field_70170_p.field_72995_K) {
            ItemGreatarrowLightning.makeLightningField(arrow.field_70170_p, arrow.func_174791_d(), 4.0);
            this.makeFireworks(arrow.field_70170_p, arrow.func_174791_d(), this.fireworksGround);
            arrow.func_70106_y();
        }
    }

    @Override
    public void hitEntity(EntityGreatarrow arrow, Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        if (!entity.field_70170_p.field_72995_K) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (ItemGreatarrowLightning.isDragon((Entity)living)) {
                DamageSource damagesource = EntityUtil.causeLightningArrowDamage(arrow.field_70250_c);
                int hurtSave = entity.field_70172_ad;
                entity.field_70172_ad = 0;
                if (!entity.func_70097_a(damagesource, 20.0f)) {
                    entity.field_70172_ad = hurtSave;
                }
            }
            living.func_70690_d(new PotionEffect((Potion)ModPotions.electrified, 100, 2, false, false));
            ItemGreatarrowLightning.makeLightningField(arrow.field_70170_p, arrow.func_174791_d(), 1.0);
            this.makeFireworks(arrow.field_70170_p, arrow.func_174791_d(), this.fireworksEntity);
            arrow.func_70106_y();
        }
    }

    private static void makeLightningField(World world, Vec3d pos, double range) {
        AxisAlignedBB aabb = new AxisAlignedBB(pos.field_72450_a - range, pos.field_72448_b - range, pos.field_72449_c - range, pos.field_72450_a + range, pos.field_72448_b + range, pos.field_72449_c + range);
        List list = world.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase living : list) {
            double distSq = living.func_70092_e(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
            if (!(distSq < range * range)) continue;
            living.func_70690_d(new PotionEffect((Potion)ModPotions.electrified, 140, 2, false, false));
        }
    }

    private static boolean isDragon(Entity target) {
        ResourceLocation location = EntityList.func_191301_a((Entity)target);
        if (location == null) {
            return false;
        }
        String lowercase = location.func_110623_a().toLowerCase();
        return lowercase.contains("dragon") && !lowercase.contains("dragonfly");
    }
}

