/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.crafting.conditions.ConditionModule;
import betterwithaddons.crafting.manager.CraftingManagerPacking;
import betterwithaddons.handler.ButcherHandler;
import betterwithaddons.handler.FallingPlatformHandler;
import betterwithaddons.handler.HardcorePackingHandler;
import betterwithaddons.handler.HardcoreWoolHandler;
import betterwithaddons.interaction.Interaction;
import betterwithaddons.interaction.InteractionDecoAddon;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.IngredientSized;
import betterwithaddons.util.ItemUtil;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.common.blocks.BlockUrn;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.crafting.RecipeShapedColor;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.hardcore.crafting.HCDiamond;
import betterwithmods.module.hardcore.needs.HCCooking;
import betterwithmods.module.hardcore.needs.HCPiles;
import betterwithmods.util.StackIngredient;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistry;

public class InteractionBWM
extends Interaction {
    final String modid = "betterwithmods";
    public static boolean ENABLED = true;
    public static boolean MILL_CLAY = true;
    public static boolean CHORUS_IN_CAULDRON = true;
    public static boolean BUTCHER_BLOCKS = true;
    public static boolean FALLING_PLATFORMS = false;
    public static boolean HARDCORE_SHEARING = true;
    public static boolean HARDCORE_PACKING = true;
    public static int WOOL_MULTIPLIER = 1;
    public static int WOOL_BATCH = 8;
    public static int GLASS_BATCH = 1;
    public static int TERRACOTTA_BATCH = 4;
    public static int FLEECE_BATCH = 32;
    public static boolean DYE_WOOL_IN_CAULDRON = true;
    public static boolean DYE_FLEECE_IN_CAULDRON = true;
    public static boolean DYE_GLASS_IN_CAULDRON = true;
    public static boolean DYE_TERRACOTTA_IN_CAULDRON = true;
    public static boolean REMOVE_REGULAR_DYE_RECIPES = true;
    public static boolean HIDDEN_ENCHANTS = false;
    public static boolean CHEAP_WOOL_ARMOR = true;
    public static String[] SHEARS_WHITELIST = new String[]{"tconstruct:kama", "tconstruct:scythe"};
    public static String[] WOOL_DYING_RECIPES = new String[]{"minecraft:black_wool", "minecraft:blue_wool", "minecraft:white_wool", "minecraft:cyan_wool", "minecraft:gray_wool", "minecraft:green_wool", "minecraft:light_blue_wool", "minecraft:light_gray_wool", "minecraft:lime_wool", "minecraft:magenta_wool", "minecraft:orange_wool", "minecraft:pink_wool", "minecraft:purple_wool", "minecraft:red_wool", "minecraft:yellow_wool", "minecraft:brown_wool"};
    public static String[] GLASS_DYING_RECIPES = new String[]{"minecraft:black_stained_glass", "minecraft:blue_stained_glass", "minecraft:white_stained_glass", "minecraft:cyan_stained_glass", "minecraft:gray_stained_glass", "minecraft:green_stained_glass", "minecraft:light_blue_stained_glass", "minecraft:light_gray_stained_glass", "minecraft:lime_stained_glass", "minecraft:magenta_stained_glass", "minecraft:orange_stained_glass", "minecraft:pink_stained_glass", "minecraft:purple_stained_glass", "minecraft:red_stained_glass", "minecraft:yellow_stained_glass", "minecraft:brown_stained_glass"};
    public static String[] TERRACOTTA_DYING_RECIPES = new String[]{"minecraft:black_stained_hardened_clay", "minecraft:blue_stained_hardened_clay", "minecraft:white_stained_hardened_clay", "minecraft:cyan_stained_hardened_clay", "minecraft:gray_stained_hardened_clay", "minecraft:green_stained_hardened_clay", "minecraft:light_blue_stained_hardened_clay", "minecraft:light_gray_stained_hardened_clay", "minecraft:lime_stained_hardened_clay", "minecraft:magenta_stained_hardened_clay", "minecraft:orange_stained_hardened_clay", "minecraft:pink_stained_hardened_clay", "minecraft:purple_stained_hardened_clay", "minecraft:red_stained_hardened_clay", "minecraft:yellow_stained_hardened_clay", "minecraft:brown_stained_hardened_clay"};

    @Override
    protected String getName() {
        return "interaction.BetterWithMods";
    }

    @Override
    void setupConfig() {
        ENABLED = this.loadPropBool("Enabled", "Whether the Better With Mods compat module is on. DISABLING THIS WILL DISABLE THE WHOLE MODULE.", ENABLED);
        MILL_CLAY = this.loadPropBool("MillClay", "Hardened clay can be milled into bricks, saving fuel and allowing dyed bricks.", MILL_CLAY);
        CHORUS_IN_CAULDRON = this.loadPropBool("ChorusInCauldron", "Chorus fruit (and Midori) can only be popped in a cauldron.", CHORUS_IN_CAULDRON);
        BUTCHER_BLOCKS = this.loadPropBool("ButcherBlocks", "Striking an enemy on chopping blocks will bloody them and bestow a short strength buff.", BUTCHER_BLOCKS);
        HARDCORE_SHEARING = this.loadPropBool("HardcoreShearing", "Sheep will only be sheared into wool items, which must be crafted into wool blocks. This does not work with machines that use onSheared, but should work with Fake Players.", HARDCORE_SHEARING);
        HARDCORE_PACKING = this.loadPropBool("HardcorePacking", "Items can be compressed in world with a piston pushing them into an enclosed space.", HARDCORE_PACKING);
        WOOL_MULTIPLIER = this.loadPropInt("WoolMultiplier", "Adjusts how much wool a sheep drops if Hardcore Shearing is enabled.", WOOL_MULTIPLIER);
        DYE_WOOL_IN_CAULDRON = this.loadPropBool("DyeInCauldron", "Wool can be dyed in batches of 8 in a cauldron and bleached with potash.", DYE_WOOL_IN_CAULDRON);
        WOOL_BATCH = this.loadPropInt("DyeWoolBatchSize", "How much wool can be dyed at once in a cauldron.", WOOL_BATCH);
        DYE_FLEECE_IN_CAULDRON = this.loadPropBool("DyeFleeceInCauldron", "Fleece can be dyed in batches of 32 in a cauldron and bleached with potash.", DYE_FLEECE_IN_CAULDRON);
        FLEECE_BATCH = this.loadPropInt("DyeFleeceBatchSize", "How much fleece can be dyed at once in a cauldron.", FLEECE_BATCH);
        DYE_GLASS_IN_CAULDRON = this.loadPropBool("DyeGlassInCauldron", "Glass can be dyed in a stoked cauldron.", DYE_GLASS_IN_CAULDRON);
        GLASS_BATCH = this.loadPropInt("DyeGlassBatchSize", "How much glass can be dyed at once in a stoked cauldron.", GLASS_BATCH);
        DYE_TERRACOTTA_IN_CAULDRON = this.loadPropBool("DyeTerracottaInCauldron", "Terracotta can be dyed in batches of 4 in a stoked cauldron.", DYE_TERRACOTTA_IN_CAULDRON);
        TERRACOTTA_BATCH = this.loadPropInt("DyeTerracottaBatchSize", "How much terracotta can be dyed at once in a stoked cauldron.", TERRACOTTA_BATCH);
        REMOVE_REGULAR_DYE_RECIPES = this.loadPropBool("RemoveDyeRecipes", "Removes dye recipes from the crafting table if the relevant cauldron dying recipes exist.", REMOVE_REGULAR_DYE_RECIPES);
        SHEARS_WHITELIST = this.loadPropStringList("ShearWhitelist", "Extra items that are functionally shears but don't extend ItemShears.", SHEARS_WHITELIST);
        CHEAP_WOOL_ARMOR = this.loadPropBool("CheapWoolArmor", "Wool Armor is made from Fleece.", CHEAP_WOOL_ARMOR);
    }

    @Override
    public boolean isActive() {
        return ENABLED && Loader.isModLoaded((String)"betterwithmods");
    }

    @Override
    public void setEnabled(boolean active) {
        ENABLED = active;
        super.setEnabled(active);
    }

    @Override
    public List<Interaction> getDependencies() {
        return null;
    }

    @Override
    public List<Interaction> getIncompatibilities() {
        return null;
    }

    @Override
    public void preInit() {
        if (BUTCHER_BLOCKS) {
            MinecraftForge.EVENT_BUS.register((Object)new ButcherHandler());
        }
        if (FALLING_PLATFORMS) {
            MinecraftForge.EVENT_BUS.register((Object)new FallingPlatformHandler());
        }
        if (HARDCORE_SHEARING) {
            MinecraftForge.EVENT_BUS.register((Object)new HardcoreWoolHandler());
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("minecraft", "string_to_wool"));
        }
        if (HARDCORE_PACKING) {
            MinecraftForge.EVENT_BUS.register((Object)new HardcorePackingHandler());
        }
        if (REMOVE_REGULAR_DYE_RECIPES) {
            if (DYE_WOOL_IN_CAULDRON) {
                Arrays.stream(WOOL_DYING_RECIPES).forEach(resloc -> BetterWithAddons.removeCraftingRecipe(new ResourceLocation(resloc)));
            }
            if (DYE_GLASS_IN_CAULDRON) {
                Arrays.stream(GLASS_DYING_RECIPES).forEach(resloc -> BetterWithAddons.removeCraftingRecipe(new ResourceLocation(resloc)));
            }
            if (DYE_TERRACOTTA_IN_CAULDRON) {
                Arrays.stream(TERRACOTTA_DYING_RECIPES).forEach(resloc -> BetterWithAddons.removeCraftingRecipe(new ResourceLocation(resloc)));
            }
        }
        if (CHEAP_WOOL_ARMOR) {
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("betterwithmods", "items/wool_boots"));
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("betterwithmods", "items/wool_chest"));
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("betterwithmods", "items/wool_helmet"));
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("betterwithmods", "items/wool_pants"));
        }
        ConditionModule.MODULES.put("HardcoreDiamond", () -> ModuleLoader.isFeatureEnabled(HCDiamond.class));
        ConditionModule.MODULES.put("HardcoreShearing", () -> HARDCORE_SHEARING);
        ConditionModule.MODULES.put("HardcoreHunger", () -> ModuleLoader.isFeatureEnabled(HCCooking.class));
        HardcoreWoolHandler.EXTRA_SHEARS = new HashSet<String>(Arrays.asList(SHEARS_WHITELIST));
    }

    @Override
    void modifyRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register(new RecipeShapedColor(new ResourceLocation("betterwithaddons", "wool_boots"), BWMItems.WOOL_BOOTS, new Object[]{"C C", "C C", Character.valueOf('C'), new ItemStack((Item)ModItems.WOOL, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation("betterwithaddons", "wool_boots")));
        registry.register(new RecipeShapedColor(new ResourceLocation("betterwithaddons", "wool_pants"), BWMItems.WOOL_PANTS, new Object[]{"CCC", "C C", "C C", Character.valueOf('C'), new ItemStack((Item)ModItems.WOOL, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation("betterwithaddons", "wool_pants")));
        registry.register(new RecipeShapedColor(new ResourceLocation("betterwithaddons", "wool_chest"), BWMItems.WOOL_CHEST, new Object[]{"C C", "CCC", "CCC", Character.valueOf('C'), new ItemStack((Item)ModItems.WOOL, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation("betterwithaddons", "wool_chest")));
        registry.register(new RecipeShapedColor(new ResourceLocation("betterwithaddons", "wool_helmet"), BWMItems.WOOL_HELMET, new Object[]{"CCC", "C C", Character.valueOf('C'), new ItemStack((Item)ModItems.WOOL, 1, Short.MAX_VALUE)}).setRegistryName(new ResourceLocation("betterwithaddons", "wool_helmet")));
    }

    public static NonNullList<ItemStack> convertShearedWool(List<ItemStack> sheared) {
        NonNullList returnList = NonNullList.func_191196_a();
        returnList.addAll((Collection)sheared.stream().map(InteractionBWM::convertOneWool).collect(Collectors.toList()));
        return returnList;
    }

    public static void convertShearedWoolEntities(List<EntityItem> sheared) {
        for (EntityItem item : sheared) {
            ItemStack stack = item.func_92059_d();
            item.func_92058_a(InteractionBWM.convertOneWool(stack));
        }
    }

    public static ItemStack convertOneWool(ItemStack stack) {
        if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L)) {
            return new ItemStack((Item)ModItems.WOOL, stack.func_190916_E() * WOOL_MULTIPLIER, stack.func_77960_j());
        }
        if (ItemUtil.matchesOreDict(stack, "blockWool")) {
            return new ItemStack((Item)ModItems.WOOL, stack.func_190916_E() * WOOL_MULTIPLIER, 0);
        }
        return stack;
    }

    @Override
    public void init() {
        OreIngredient dye;
        if (!this.isActive()) {
            return;
        }
        String[] dyeOredictTags = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
        if (HARDCORE_SHEARING) {
            BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a((Object)new ResourceLocation("sheep"), (world, pos, entity, itemStack) -> {
                EntitySheep sheep = (EntitySheep)entity;
                if (sheep.isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos)) {
                    return InteractionBWM.convertShearedWool(sheep.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos, 0));
                }
                return NonNullList.func_191196_a();
            });
        }
        ItemStack whiteWool = new ItemStack(Blocks.field_150325_L, WOOL_BATCH, EnumDyeColor.WHITE.func_176765_a());
        ItemStack whiteFleece = new ItemStack((Item)ModItems.WOOL, FLEECE_BATCH, EnumDyeColor.WHITE.func_176765_a());
        for (EnumDyeColor color2 : EnumDyeColor.values()) {
            EnumDyeColor[] dye2 = new OreIngredient("dye" + dyeOredictTags[color2.ordinal()]);
            if (color2 == EnumDyeColor.WHITE) continue;
            if (DYE_WOOL_IN_CAULDRON) {
                BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{whiteWool}), dye2}), new ItemStack(Blocks.field_150325_L, WOOL_BATCH, color2.func_176765_a()));
            }
            if (!DYE_FLEECE_IN_CAULDRON) continue;
            BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{whiteFleece}), dye2}), new ItemStack((Item)ModItems.WOOL, FLEECE_BATCH, color2.func_176765_a()));
        }
        StackIngredient anyColoredWool = StackIngredient.fromIngredient((int)WOOL_BATCH, (Ingredient)Ingredient.func_193369_a((ItemStack[])Arrays.stream(EnumDyeColor.values()).filter(color -> color != EnumDyeColor.WHITE).map(color -> new ItemStack(Blocks.field_150325_L, 1, color.func_176765_a())).collect(Collectors.toList()).toArray(new ItemStack[15])));
        StackIngredient anyColoredFleece = StackIngredient.fromIngredient((int)FLEECE_BATCH, (Ingredient)Ingredient.func_193369_a((ItemStack[])Arrays.stream(EnumDyeColor.values()).filter(color -> color != EnumDyeColor.WHITE).map(color -> new ItemStack((Item)ModItems.WOOL, 1, color.func_176765_a())).collect(Collectors.toList()).toArray(new ItemStack[15])));
        Ingredient potash = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.POTASH)});
        if (DYE_WOOL_IN_CAULDRON) {
            BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{anyColoredWool, potash}), whiteWool);
        }
        if (DYE_FLEECE_IN_CAULDRON) {
            BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{anyColoredFleece, potash}), whiteFleece);
        }
        int glassPaneBatch = GLASS_BATCH * (InteractionDecoAddon.GLASS_PANE_REBALANCE ? 2 : 8);
        if (DYE_GLASS_IN_CAULDRON) {
            for (EnumDyeColor color3 : EnumDyeColor.values()) {
                dye = new OreIngredient("dye" + dyeOredictTags[color3.ordinal()]);
                BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150359_w, GLASS_BATCH)}), dye}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)Blocks.field_150399_cn, GLASS_BATCH, color3.func_176765_a())}));
                BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150410_aZ, glassPaneBatch)}), dye}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)Blocks.field_150397_co, glassPaneBatch, color3.func_176765_a())}));
            }
        }
        if (DYE_TERRACOTTA_IN_CAULDRON) {
            for (EnumDyeColor color3 : EnumDyeColor.values()) {
                dye = new OreIngredient("dye" + dyeOredictTags[color3.ordinal()]);
                BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150405_ch, TERRACOTTA_BATCH)}), dye}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack(Blocks.field_150406_ce, TERRACOTTA_BATCH, color3.func_176765_a())}));
            }
        }
        HCPiles.registerPile((Block)ModBlocks.ZEN_SAND, (ItemStack)new ItemStack(BWMItems.SAND_PILE, 3));
        HCPiles.registerPile((Block)ModBlocks.ZEN_RED_SAND, (ItemStack)new ItemStack(BWMItems.RED_SAND_PILE, 3));
        HCPiles.registerPile((Block)ModBlocks.ZEN_SOUL_SAND, (ItemStack)new ItemStack(ModItems.SOUL_SAND_PILE, 3));
        HCPiles.registerPile((Block)Blocks.field_150425_aM, (ItemStack)new ItemStack(ModItems.SOUL_SAND_PILE, 3));
        OreDictionary.getOres((String)"cookedCarrot").clear();
        OreDictionary.registerOre((String)"cookedCarrot", (ItemStack)new ItemStack((Item)ModItems.COOKED_CARROT));
        OreDictionary.registerOre((String)"cookedCarrot", (ItemStack)new ItemStack((Item)ModItems.BAKED_CARROT));
        OreDictionary.registerOre((String)"cookedPotato", (ItemStack)new ItemStack((Item)ModItems.COOKED_POTATO));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)new ItemStack(Blocks.field_150335_W));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)new ItemStack(Items.field_151016_H));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)new ItemStack(BWMItems.DYNAMITE));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)new ItemStack(BWMBlocks.MINING_CHARGE));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.HELLFIRE.getMeta()));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.BLASTING_OIL));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HELLFIRE_DUST));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.CONCENTRATED_HELLFIRE));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)ModItems.MATERIAL_BAG.getMaterial("gunpowder"));
        OreDictionary.registerOre((String)"listAllExplosives", (ItemStack)ModItems.MATERIAL_BAG.getMaterial("hellfire"));
        OreDictionary.registerOre((String)"listAllmeat", (Item)Items.field_179558_bo);
        OreDictionary.registerOre((String)"listAllmeatcooked", (Item)ModItems.COOKED_CLOWNFISH);
        OreDictionary.registerOre((String)"blockDung", (ItemStack)BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.DUNG));
        OreDictionary.registerOre((String)"book", (Item)Items.field_151164_bB);
        OreDictionary.registerOre((String)"book", (Item)Items.field_151122_aG);
        if (HARDCORE_PACKING) {
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150346_d.func_176223_P(), new ItemStack(Blocks.field_150346_d), IngredientSized.fromItem(BWMItems.DIRT_PILE, 4));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150354_m.func_176223_P(), new ItemStack((Block)Blocks.field_150354_m), IngredientSized.fromItem(BWMItems.SAND_PILE, 4));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND), new ItemStack((Block)Blocks.field_150354_m, 1, 1), IngredientSized.fromItem(BWMItems.RED_SAND_PILE, 4));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150351_n.func_176223_P(), new ItemStack(Blocks.field_150351_n), IngredientSized.fromItem(BWMItems.GRAVEL_PILE, 4));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150425_aM.func_176223_P(), new ItemStack(Blocks.field_150425_aM), IngredientSized.fromItem(ModItems.SOUL_SAND_PILE, 4));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150435_aG.func_176223_P(), new ItemStack(Blocks.field_150435_aG), IngredientSized.fromItem(Items.field_151119_aD, 4));
            CraftingManagerPacking.getInstance().addRecipe(BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.NETHERCLAY), BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.NETHERCLAY), IngredientSized.fromStacks(ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.NETHER_SLUDGE, (int)4)));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150433_aE.func_176223_P(), new ItemStack(Blocks.field_150433_aE), IngredientSized.fromItem(Items.field_151126_ay, 4));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150336_V.func_176223_P(), new ItemStack(Blocks.field_150336_V), IngredientSized.fromItem(Items.field_151118_aC, 4));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150385_bj.func_176223_P(), new ItemStack(Blocks.field_150385_bj), IngredientSized.fromItem(Items.field_151130_bT, 4));
            CraftingManagerPacking.getInstance().addRecipe(BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.FLINT), BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.FLINT), IngredientSized.fromItem(Items.field_151145_ak, 9));
            CraftingManagerPacking.getInstance().addRecipe(BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.DUNG), BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.DUNG), IngredientSized.fromStacks(ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.DUNG, (int)9)));
            CraftingManagerPacking.getInstance().addRecipe(BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.SOAP), BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.SOAP), IngredientSized.fromStacks(ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.SOAP, (int)9)));
            CraftingManagerPacking.getInstance().addRecipe(BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.HELLFIRE), BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.HELLFIRE), IngredientSized.fromStacks(ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.CONCENTRATED_HELLFIRE, (int)9)));
            CraftingManagerPacking.getInstance().addRecipe(BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.ENDERBLOCK), BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.ENDERBLOCK), IngredientSized.fromItem(Items.field_151079_bi, 9));
            CraftingManagerPacking.getInstance().addRecipe(BlockAesthetic.getVariant((BlockAesthetic.EnumType)BlockAesthetic.EnumType.NETHERCOAL), BlockAesthetic.getStack((BlockAesthetic.EnumType)BlockAesthetic.EnumType.NETHERCOAL), IngredientSized.fromStacks(ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.NETHERCOAL, (int)9)));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_189878_dg.func_176223_P(), new ItemStack(Blocks.field_189878_dg), IngredientSized.fromItem(Items.field_151075_bm, 9));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_189880_di.func_176223_P(), new ItemStack(Blocks.field_189880_di), IngredientSized.fromStacks(new ItemStack(Items.field_151100_aR, 9, EnumDyeColor.WHITE.func_176767_b())));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_180399_cE.func_176223_P(), new ItemStack(Blocks.field_180399_cE), IngredientSized.fromItem(Items.field_151123_aH, 9));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_189877_df.func_176223_P(), new ItemStack(Blocks.field_189877_df), IngredientSized.fromItem(Items.field_151064_bs, 4));
            CraftingManagerPacking.getInstance().addRecipe(ModBlocks.ELYTRA_MAGMA.func_176223_P(), new ItemStack((Block)ModBlocks.ELYTRA_MAGMA), IngredientSized.fromStacks(ModItems.MATERIAL.getMaterial("ender_cream", 4)));
            CraftingManagerPacking.getInstance().addRecipe(Blocks.field_150403_cj.func_176223_P(), new ItemStack(Blocks.field_150403_cj), IngredientSized.fromStacks(new ItemStack(Blocks.field_150432_aD, 4)));
        }
        ItemStack arrowhead = ModItems.MATERIAL.getMaterial("arrowhead");
        ItemStack haft = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HAFT);
        ItemStack string = new ItemStack(BWMBlocks.ROPE);
        ItemStack feather = new ItemStack(Items.field_151008_G);
        String oreIronIngot = "ingotIron";
        BWRegistry.CAULDRON.addStokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151071_bq), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150417_aV)}), new OreIngredient("dustPotash")}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)ModBlocks.PCB_BLOCK)}));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193367_a((Item)Items.field_185164_cV), new ItemStack((Item)ModItems.COOKED_BEETROOT));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193367_a((Item)Items.field_151172_bF), new ItemStack((Item)ModItems.COOKED_CARROT));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193367_a((Item)Items.field_151174_bG), new ItemStack((Item)ModItems.COOKED_POTATO));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193367_a((Item)Items.field_151110_aK), new ItemStack((Item)ModItems.COOKED_EGG));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a())}), new ItemStack((Item)ModItems.COOKED_CLOWNFISH));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a())}), new ItemStack((Item)ModItems.COOKED_PUFFER));
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{StackIngredient.fromStacks((ItemStack[])new ItemStack[]{new ItemStack(Items.field_151103_aS, 2)}), this.getIngredient(new ItemStack(Items.field_151100_aR, 8, 15))}), ModItems.MATERIAL.getMaterial("bone_ingot"));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{ModItems.MATERIAL.getMaterial("midori")}), ModItems.MATERIAL.getMaterial("midori_popped"));
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193367_a((Item)ModItems.GROUND_MEAT), new ItemStack((Item)ModItems.MEATBALLS, 1));
        ModBlocks.MULBERRY_LOG.barkStack = ModItems.MATERIAL_JAPAN.getMaterial("bark_mulberry");
        ModBlocks.SAKURA_LOG.barkStack = ModItems.MATERIAL_JAPAN.getMaterial("bark_sakura");
        ItemStack rosebush = new ItemStack((Block)Blocks.field_150398_cm, 4, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a());
        ItemStack thornrose = ModItems.MATERIAL.getMaterial("thornrose", 2);
        ItemStack soulUrn = new ItemStack(BWMBlocks.URN, 1, BlockUrn.EnumType.FULL.getMeta());
        ItemStack cactus = new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.GREEN.func_176767_b());
        ItemStack dung = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.DUNG, (int)1);
        ItemStack midori = ModItems.MATERIAL.getMaterial("midori", 8);
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{this.getIngredient(cactus), this.getIngredient(rosebush), this.getIngredient(dung), this.getIngredient(soulUrn)}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)ModBlocks.THORN_ROSE)}));
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{this.getIngredient(midori), this.getIngredient(thornrose), this.getIngredient(dung), this.getIngredient(soulUrn)}), (List)Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((Block)ModBlocks.THORN_ROSE)}));
        BWRegistry.MILLSTONE.addMillRecipe(ModItems.MATERIAL.getMaterial("midori", 1), cactus);
        ItemStack wheat = new ItemStack(Items.field_151015_O, 16);
        ItemStack flesh = new ItemStack(Items.field_151078_bh, 4);
        ItemStack red = new ItemStack(Items.field_151100_aR, 8, EnumDyeColor.RED.func_176767_b());
        ItemStack tree = new ItemStack(Blocks.field_150345_g, 1, BlockPlanks.EnumType.BIRCH.func_176839_a());
        BWRegistry.CAULDRON.addUnstokedRecipe((List)Lists.newArrayList((Object[])new Ingredient[]{this.getIngredient(tree), this.getIngredient(wheat), this.getIngredient(red), this.getIngredient(flesh)}), new ItemStack((Block)ModBlocks.LURETREE_SAPLING));
        if (MILL_CLAY) {
            BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Blocks.field_150405_ch, 1), new ItemStack(Items.field_151118_aC, 4));
            for (EnumDyeColor dye3 : EnumDyeColor.values()) {
                ItemStack brick = new ItemStack((Item)ModItems.STAINED_BRICK, 1, dye3.func_176765_a());
                BWRegistry.MILLSTONE.addMillRecipe(new ItemStack(Blocks.field_150406_ce, 1, dye3.func_176765_a()), new ItemStack((Item)ModItems.STAINED_BRICK, 4, dye3.func_176765_a()));
            }
        }
        if (!CHORUS_IN_CAULDRON) {
            GameRegistry.addSmelting((ItemStack)ModItems.MATERIAL.getMaterial("midori"), (ItemStack)ModItems.MATERIAL.getMaterial("midori_popped"), (float)0.1f);
        }
    }

    private StackIngredient getIngredient(ItemStack stack) {
        return StackIngredient.fromStacks((ItemStack[])new ItemStack[]{stack});
    }

    @Override
    public void postInit() {
        InteractionBWM.removeCauldronRecipe(new ItemStack(Items.field_151168_bH));
        InteractionBWM.removeCauldronRecipe(new ItemStack((Item)ModItems.BAKED_CARROT));
        InteractionBWM.removeCauldronRecipe(new ItemStack((Item)ModItems.BAKED_BEETROOT));
        if (CHORUS_IN_CAULDRON) {
            BetterWithAddons.removeSmeltingRecipe(new ItemStack(Items.field_185162_cT));
        }
        for (ItemStack stack : OreDictionary.getOres((String)"listAllmeat")) {
            ItemStack groundMeat = new ItemStack((Item)ModItems.GROUND_MEAT);
            ItemStack meatStack = stack.func_77946_l();
            meatStack.func_190920_e(1);
            if (meatStack.func_77973_b() instanceof ItemFood) {
                int amount = ((ItemFood)meatStack.func_77973_b()).func_150905_g(meatStack) / ModItems.GROUND_MEAT.func_150905_g(groundMeat);
                groundMeat.func_190920_e(Math.max(amount, 1));
            }
            BWRegistry.MILLSTONE.addMillRecipe(meatStack, groundMeat);
        }
    }

    private static void removeCauldronRecipe(ItemStack outputs) {
        BWRegistry.CAULDRON.remove((List)Lists.newArrayList((Object[])new ItemStack[]{outputs}));
    }
}

