/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.interaction;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.BlockModUnbaked;
import betterwithaddons.block.BlockRopeSideways;
import betterwithaddons.block.BlockWeight;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.crafting.conditions.ConditionModule;
import betterwithaddons.crafting.recipes.AdobeRecipe;
import betterwithaddons.crafting.recipes.FoodCombiningRecipe;
import betterwithaddons.enchantment.EnchantmentMendingGoldOnly;
import betterwithaddons.enchantment.EnchantmentProtectionOther;
import betterwithaddons.enchantment.EnchantmentSharpnessOther;
import betterwithaddons.handler.AssortedHandler;
import betterwithaddons.handler.ElytraUpdriftHandler;
import betterwithaddons.handler.GrassHandler;
import betterwithaddons.handler.HarvestHandler;
import betterwithaddons.handler.HorseFoodHandler;
import betterwithaddons.handler.PatientiaHandler;
import betterwithaddons.handler.RotHandler;
import betterwithaddons.handler.ToolShardRepairHandler;
import betterwithaddons.interaction.Interaction;
import betterwithaddons.item.ModItems;
import betterwithaddons.tileentity.TileEntityAqueductWater;
import betterwithaddons.tileentity.TileEntityLureTree;
import betterwithaddons.util.EntityUtil;
import betterwithaddons.util.ISpecialMeasuringBehavior;
import betterwithaddons.util.ItemUtil;
import betterwithaddons.util.PulleyUtil;
import betterwithaddons.util.VariableSegment;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWRegistry;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.PulleyStructureManager;
import betterwithmods.common.registry.bulk.recipes.BulkRecipe;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.gameplay.AnvilRecipes;
import betterwithmods.module.gameplay.MetalReclaming;
import betterwithmods.module.hardcore.crafting.HCDiamond;
import betterwithmods.module.hardcore.needs.HCCooking;
import betterwithmods.module.tweaks.CheaperAxes;
import betterwithmods.module.tweaks.EasyBreeding;
import betterwithmods.util.DirUtils;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityEvoker;
import net.minecraft.entity.monster.EntityIllusionIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class InteractionBWA
extends Interaction {
    public static boolean GATED_AQUEDUCTS = true;
    public static int AQUEDUCT_MAX_LENGTH = 128;
    public static String[] AQUEDUCT_BIOME_STRINGS = new String[0];
    public static boolean AQUEDUCT_BIOMES_IS_WHITELIST = true;
    public static String[] AQUEDUCT_SOURCE_WHITELIST = new String[]{"streams:river"};
    public static boolean AQUEDUCT_IS_TANK = false;
    public static int AQUEDUCT_WATER_AMOUNT = 1000;
    public static int AQUEDUCT_SOURCES_MINIMUM = 0;
    public static int AQUEDUCT_SOURCES_SEARCH = 0;
    public static boolean GRASS_TO_CLAY = false;
    public static boolean GRASS_TO_SAND = false;
    public static boolean STONEBRICKS_NEED_SMELTING = false;
    public static boolean ARMOR_SHARD_RENDER = true;
    public static double LEGENDARIUM_MIN_DAMAGE = 0.1f;
    public static boolean LEGENDARIUM_MUST_BE_NAMED = true;
    public static boolean LEGENDARIUM_MUST_BE_ENCHANTED = true;
    public static boolean LEGENDARIUM_MUST_BE_LIMIT = true;
    public static int LEGENDARIUM_DAMAGE_PAD = 24;
    public static int LEGENDARIUM_POSTER_RANGE = 16;
    public static int LEGENDARIUM_MIN_QUEUE_SIZE = 7;
    public static int LEGENDARIUM_TURN_IN_DELAY = 120000;
    public static int RADIUS = 6;
    public static int MAXCHARGE = 600;
    public static int MAXFOOD = 5000;
    public static boolean CONVENIENT_TOOLS_PRE_END = true;
    public static boolean ROTTEN_FOOD = false;
    public static long MEAT_ROT_TIME = 96000L;
    public static long FISH_ROT_TIME = 48000L;
    public static long FRUIT_ROT_TIME = 120000L;
    public static long MISC_ROT_TIME = 72000L;
    public static String[] ROTTEN_FOOD_BLACKLIST = new String[]{"minecraft:golden_apple", "minecraft:golden_carrot", "minecraft:rotten_flesh", "minecraft:spider_eye", "minecraft:poisonous_potato", "minecraft:chorus_fruit", "betterwithmods:kibble", "betterwithmods:creeper_oyster", "betterwithaddons:food_mushroom_baked", "betterwithaddons:food_amanita_baked", "betterwithaddons:food_fugu_sac", "betterwithaddons:rotten_food"};
    public static boolean ROTTEN_FOOD_COMBINING = true;
    public static int LEGENDARIUM_SHARD_COST = 35;
    public static double LEGENDARIUM_REPAIR_COST_MULTIPLIER = 0.5;
    public static boolean HORSES_IGNORE_GOLD = true;
    public static boolean HORSES_SET_HOME = true;
    public static boolean HORSES_BREED_HAYBALE_PLACED = true;
    public static boolean HORSES_BREED_HAYBALES = false;
    public static int ROPE_LIMIT = 30;
    public static boolean REPLACE_PROTECTION = true;
    public static String[] RESISTANCE_TYPES = new String[0];
    public static boolean REPLACE_SHARPNESS = true;
    public static String[] SHARPNESS_ENTITIES = new String[0];
    public static boolean REPLACE_MENDING = true;
    public static String[] GOLD_ITEMS = new String[0];
    private boolean isLoaded;

    @Override
    protected String getName() {
        return "addons.BetterWithAddons";
    }

    @Override
    void setupConfig() {
        STONEBRICKS_NEED_SMELTING = this.loadPropBool("StoneBricksNeedSmelting", "Stonebricks need two extra steps in crafting.", STONEBRICKS_NEED_SMELTING);
        GATED_AQUEDUCTS = this.loadPropBool("GatedAqueducts", "Aqueducts require white stone to craft. This means you need to go to the end to transport water over long distances without power usage.", GATED_AQUEDUCTS);
        AQUEDUCT_BIOME_STRINGS = this.loadPropStringList("AqueductBiomes", "Aqueducts can only draw water from sources in specific biomes.", AQUEDUCT_BIOME_STRINGS);
        AQUEDUCT_BIOMES_IS_WHITELIST = this.loadPropBool("AqueductBiomesIsWhitelist", "Whether aqueduct biomes should be whitelisted or blacklisted.", AQUEDUCT_BIOMES_IS_WHITELIST);
        AQUEDUCT_SOURCE_WHITELIST = this.loadPropStringList("AqueductSources", "Sources Aqueducts can pull from other than real source blocks.", AQUEDUCT_SOURCE_WHITELIST);
        CONVENIENT_TOOLS_PRE_END = this.loadPropBool("ConvenientIronTools", "Convenient tools can be made from iron, gold and diamond pre-soulsteel.", CONVENIENT_TOOLS_PRE_END);
        ROTTEN_FOOD = this.loadPropBool("RottenFood", "Whether food will rot after a certain number of days has passed.", ROTTEN_FOOD);
        ROTTEN_FOOD_COMBINING = this.loadPropBool("RottenFoodCombining", "Whether food can be combined in the crafting grid to stack.", ROTTEN_FOOD_COMBINING);
        ROTTEN_FOOD_BLACKLIST = this.loadPropStringList("RottenFoodBlacklist", "These foods are excluded from rotting.", ROTTEN_FOOD_BLACKLIST);
        MEAT_ROT_TIME = this.loadPropInt("RottenMeatTime", "How long meat takes to rot. (In ticks)", (int)MEAT_ROT_TIME);
        FISH_ROT_TIME = this.loadPropInt("RottenFishTime", "How long fish takes to rot. (In ticks)", (int)FISH_ROT_TIME);
        FRUIT_ROT_TIME = this.loadPropInt("RottenFruitTime", "How long fruit takes to rot. (In ticks)", (int)FRUIT_ROT_TIME);
        MISC_ROT_TIME = this.loadPropInt("RottenMiscTime", "How long misc food takes to rot. (In ticks)", (int)MISC_ROT_TIME);
        HORSES_BREED_HAYBALES = this.loadPropBool("HorsesBreedHaybales", "Horeses can breed from eating dropped haybales.", HORSES_BREED_HAYBALES);
        ARMOR_SHARD_RENDER = this.loadPropBool("ArmorShardRender", "Enables or disables the custom armor shard renderer, for when it causes crashes.", ARMOR_SHARD_RENDER);
        REPLACE_SHARPNESS = this.loadPropBool("SharpnessReplacer", "Whether the Sharpness enchantment should be replaced with a weaker version that only works on things not affected by other damage enchantments.", REPLACE_SHARPNESS);
        REPLACE_PROTECTION = this.loadPropBool("ProtectionReplacer", "Whether the Protection enchantment should be replaced with a weaker version that only works on things not affected by other protective enchantments.", REPLACE_PROTECTION);
        REPLACE_MENDING = this.loadPropBool("MendingReplacer", "Whether the Mending enchantment should be replaced with a weaker version that only works on golden items.", REPLACE_MENDING);
        this.doesNotNeedRestart(() -> {
            RADIUS = this.loadPropInt("LureTreeRadius", "Radius in which the tree can spawn mobs.", RADIUS);
            MAXCHARGE = this.loadPropInt("LureTreeTime", "Time it takes for the tree to do one spawning cycle.", MAXCHARGE);
            MAXFOOD = this.loadPropInt("LureTreeMaxFood", "How much food the tree can hold.", MAXFOOD);
            ROPE_LIMIT = this.loadPropInt("RopeBridgeLimit", "How far rope can be spanned horizontally between two posts or other attachments.", ROPE_LIMIT);
            HORSES_IGNORE_GOLD = this.loadPropBool("HorsesIgnoreGold", "Horses can't be fed golden food. It gives them a tummy ache.", HORSES_IGNORE_GOLD);
            HORSES_SET_HOME = this.loadPropBool("HorsesSetHome", "Horses set their home location if they're in a safe spot when dismounting.", HORSES_SET_HOME);
            HORSES_BREED_HAYBALE_PLACED = this.loadPropBool("HorsesBreedHaybalesPlaced", "Horses can breed from eating haybales placed in world.", HORSES_BREED_HAYBALE_PLACED);
            AQUEDUCT_MAX_LENGTH = this.loadPropInt("MaxAqueductLength", "How long aqueducts can be.", AQUEDUCT_MAX_LENGTH);
            AQUEDUCT_SOURCES_MINIMUM = this.loadPropInt("AqueductSourcesRequired", "How many connected water sources are required for an aqueduct to take from it.", AQUEDUCT_SOURCES_MINIMUM);
            AQUEDUCT_SOURCES_SEARCH = this.loadPropInt("AqueductSourcesSearch", "How many blocks will be checked for water sources. This should be a bit larger than the minimum amount of sources.", AQUEDUCT_SOURCES_SEARCH);
            AQUEDUCT_IS_TANK = this.loadPropBool("AqueductIsTank", "Aqueduct water counts as a fluid tank for modded pipes. Happy birthday Vyraal1", AQUEDUCT_IS_TANK);
            AQUEDUCT_WATER_AMOUNT = this.loadPropInt("AqueductWaterAmount", "How much water is contained in each block, set to less than 1000 to disallow picking up buckets.", AQUEDUCT_WATER_AMOUNT, 0, Integer.MAX_VALUE);
            LEGENDARIUM_MIN_DAMAGE = this.loadPropDouble("LegendariumDamageMin", "How much durability the artifact you're turning in can have at max. (As a factor of max durability; 0.1 means 1/10 of max durability)", LEGENDARIUM_MIN_DAMAGE);
            LEGENDARIUM_DAMAGE_PAD = this.loadPropInt("LegendariumDamagePad", "How much durability more than the minimum the artifact can have to still be considered broken. (As a static value)", LEGENDARIUM_DAMAGE_PAD);
            LEGENDARIUM_POSTER_RANGE = this.loadPropInt("LegendariumPosterRange", "How far away Display Frames are recognized. (in blocks; as a cubic radius)", LEGENDARIUM_POSTER_RANGE);
            LEGENDARIUM_MIN_QUEUE_SIZE = this.loadPropInt("LegendariumMinQueueSize", "How many artifacts must be in the Hall of Legends to take one out.", LEGENDARIUM_MIN_QUEUE_SIZE);
            LEGENDARIUM_TURN_IN_DELAY = this.loadPropInt("LegendariumTurnInDelay", "How long until the next artifact can be turned in. (in ticks; 1000 ticks is one Minecraft hour)", LEGENDARIUM_TURN_IN_DELAY);
            LEGENDARIUM_REPAIR_COST_MULTIPLIER = this.loadPropDouble("LegendariumRepairCostMultiplier", "When repairing a shard on an anvil, the repair cost is modified by this multiplier.", LEGENDARIUM_REPAIR_COST_MULTIPLIER);
            LEGENDARIUM_SHARD_COST = this.loadPropInt("LegendariumRepairCost", "How many levels it costs to repair a shard on an anvil.", LEGENDARIUM_SHARD_COST);
            LEGENDARIUM_MUST_BE_NAMED = this.loadPropBool("LegendariumMustBeNamed", "Whether items must be named to be considered artifacts.", LEGENDARIUM_MUST_BE_NAMED);
            LEGENDARIUM_MUST_BE_ENCHANTED = this.loadPropBool("LegendariumMustBeEnchanted", "Whether items must be enchanted to be considered artifacts.", LEGENDARIUM_MUST_BE_ENCHANTED);
            LEGENDARIUM_MUST_BE_LIMIT = this.loadPropBool("LegendariumMustBeLimit", "Whether items must be over the repair limit to be considered artifacts.", LEGENDARIUM_MUST_BE_LIMIT);
            RESISTANCE_TYPES = this.loadPropStringList("ProtectionResistanceTypes", "Damage types already covered by other protective enchantments.", RESISTANCE_TYPES);
            SHARPNESS_ENTITIES = this.loadPropStringList("SharpnessEntities", "Resource names of entities already affected by other damage enchantments.", SHARPNESS_ENTITIES);
            GOLD_ITEMS = this.loadPropStringList("MendingGoldItems", "Resource names of items that should be allowed to have Mending on them.", GOLD_ITEMS);
            if (this.isLoaded) {
                this.writeEnchantmentConfigs();
            }
        });
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        if (REPLACE_SHARPNESS) {
            event.getRegistry().register(new EnchantmentSharpnessOther(Enchantment.Rarity.COMMON, EntityEquipmentSlot.MAINHAND).setRegistryName(new ResourceLocation("sharpness")));
        }
        if (REPLACE_PROTECTION) {
            event.getRegistry().register(new EnchantmentProtectionOther(Enchantment.Rarity.COMMON, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET).setRegistryName(new ResourceLocation("protection")));
        }
        if (REPLACE_MENDING) {
            event.getRegistry().register(new EnchantmentMendingGoldOnly(Enchantment.Rarity.RARE, EntityEquipmentSlot.values()).setRegistryName(new ResourceLocation("mending")));
        }
    }

    private void writeEnchantmentConfigs() {
        EnchantmentProtectionOther.reset();
        EnchantmentSharpnessOther.reset();
        EnchantmentMendingGoldOnly.reset();
        EnchantmentProtectionOther.register(DamageSource::func_76347_k);
        EnchantmentProtectionOther.register(DamageSource::func_76352_a);
        EnchantmentProtectionOther.register(DamageSource::func_94541_c);
        EnchantmentProtectionOther.register("fall");
        if (Loader.isModLoaded((String)"apotheosis")) {
            EnchantmentProtectionOther.register(DamageSource::func_82725_o);
        }
        EnchantmentSharpnessOther.registerType(EnumCreatureAttribute.ARTHROPOD);
        EnchantmentSharpnessOther.registerType(EnumCreatureAttribute.UNDEAD);
        if (Loader.isModLoaded((String)"abyssalcraft")) {
            EnchantmentSharpnessOther.registerType("SHADOW");
        }
        if (Loader.isModLoaded((String)"selim_enchants")) {
            EnchantmentSharpnessOther.register(EntityVillager.class);
            EnchantmentSharpnessOther.register(EntityIronGolem.class);
            EnchantmentSharpnessOther.register(EntitySnowman.class);
            EnchantmentSharpnessOther.register(EntityWitch.class);
            EnchantmentSharpnessOther.register(EntityZombieVillager.class);
            EnchantmentSharpnessOther.register(EntityZombie.class);
            EnchantmentSharpnessOther.register(EntityPlayer.class);
            EnchantmentSharpnessOther.register(EntityEvoker.class);
            EnchantmentSharpnessOther.register(EntityVindicator.class);
            EnchantmentSharpnessOther.register(EntityVex.class);
            EnchantmentSharpnessOther.register(EntityIllusionIllager.class);
            EnchantmentSharpnessOther.register(EntityWither.class);
            for (String string : EnumCreatureType.values()) {
                for (Biome.SpawnListEntry e : Biomes.field_76778_j.func_76747_a((EnumCreatureType)string)) {
                    EnchantmentSharpnessOther.register(EntityList.func_191306_a((Class)e.field_76300_b).toString());
                }
            }
            EnchantmentSharpnessOther.register(EntityEnderman.class);
            EnchantmentSharpnessOther.register(EntityEndermite.class);
            EnchantmentSharpnessOther.register(EntityShulker.class);
            EnchantmentSharpnessOther.register(EntityDragon.class);
            for (String string : EnumCreatureType.values()) {
                for (Biome.SpawnListEntry e : Biomes.field_76779_k.func_76747_a((EnumCreatureType)string)) {
                    EnchantmentSharpnessOther.register(EntityList.func_191306_a((Class)e.field_76300_b).toString());
                }
            }
        }
        for (String string : RESISTANCE_TYPES) {
            EnchantmentProtectionOther.register(string);
        }
        for (String string : SHARPNESS_ENTITIES) {
            EnchantmentSharpnessOther.register(string);
        }
        for (String string : GOLD_ITEMS) {
            EnchantmentMendingGoldOnly.register(string);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setEnabled(boolean active) {
    }

    @Override
    public List<Interaction> getDependencies() {
        return null;
    }

    @Override
    public List<Interaction> getIncompatibilities() {
        return null;
    }

    @Override
    public void preInit() {
        ConditionModule.MODULES.put("ConvenientToolsPreEnd", () -> CONVENIENT_TOOLS_PRE_END);
        ConditionModule.MODULES.put("StoneBricksNeedSmelting", () -> STONEBRICKS_NEED_SMELTING);
        ConditionModule.MODULES.put("GatedAqueducts", () -> GATED_AQUEDUCTS);
        if (HORSES_BREED_HAYBALES) {
            EasyBreeding.REGISTRY.addPredicateEntry(new ResourceLocation("betterwithaddons", "horse"), e -> e instanceof AbstractHorse && HorseFoodHandler.canHorseBreed((AbstractHorse)e)).addIngredient(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150407_cf)}));
        }
        MinecraftForge.EVENT_BUS.register((Object)new AssortedHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ToolShardRepairHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HorseFoodHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ElytraUpdriftHandler());
        MinecraftForge.EVENT_BUS.register((Object)new HarvestHandler());
        if (GRASS_TO_CLAY || GRASS_TO_SAND) {
            PatientiaHandler.addCustomBlock((Block)Blocks.field_150349_c);
            MinecraftForge.EVENT_BUS.register((Object)new GrassHandler());
        }
        if (STONEBRICKS_NEED_SMELTING) {
            BetterWithAddons.removeCraftingRecipe(new ResourceLocation("minecraft", "stonebrick"));
        }
        for (String s : AQUEDUCT_SOURCE_WHITELIST) {
            TileEntityAqueductWater.addWaterSource(new ResourceLocation(s));
        }
        VariableSegment.addVariableSupplier(new ResourceLocation("betterwithaddons", "aqueduct_length"), () -> Integer.toString(AQUEDUCT_MAX_LENGTH));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    void preInitClient() {
        if (ROTTEN_FOOD) {
            MinecraftForge.EVENT_BUS.register((Object)new RotHandler());
        }
    }

    @Override
    void oreDictRegistration() {
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)ModBlocks.LURETREE_LOG));
    }

    @Override
    public void init() {
        int axeAmt;
        if (PatientiaHandler.shouldRegister()) {
            MinecraftForge.EVENT_BUS.register((Object)new PatientiaHandler());
        }
        ModBlocks.LURETREE_SAPLING.setLeaves(ModBlocks.LURETREE_LEAVES.func_176223_P()).setLog(ModBlocks.LURETREE_LOG.func_176223_P()).setBig(true);
        ModBlocks.LURETREE_LEAVES.setSapling(new ItemStack((Block)ModBlocks.LURETREE_SAPLING));
        ItemStack greatarrowhead = ModItems.MATERIAL.getMaterial("arrowhead");
        ItemStack haft = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.HAFT);
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "greatbow"), (ItemStack)new ItemStack((Item)ModItems.GREATBOW), (Object[])new Object[]{"si ", "s i", "s i", "si ", Character.valueOf('i'), haft, Character.valueOf('s'), new ItemStack(BWMBlocks.ROPE)});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "greatarrow_head"), (ItemStack)greatarrowhead, (Object[])new Object[]{" n ", "nnn", "nnn", "n n", Character.valueOf('n'), "nuggetSoulforgedSteel"});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "greatarrow_lightning"), (ItemStack)new ItemStack((Item)ModItems.GREATARROW_LIGHTNING), (Object[])new Object[]{"nxn", "nxn", " i ", " f ", Character.valueOf('n'), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.REDSTONE_LATCH), Character.valueOf('x'), greatarrowhead, Character.valueOf('i'), haft, Character.valueOf('f'), new ItemStack(Items.field_151008_G)});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "greatarrow_destruction"), (ItemStack)new ItemStack((Item)ModItems.GREATARROW_DESTRUCTION), (Object[])new Object[]{"n n", "nxn", " i ", " f ", Character.valueOf('n'), "nuggetSoulforgedSteel", Character.valueOf('x'), greatarrowhead, Character.valueOf('i'), haft, Character.valueOf('f'), new ItemStack(Items.field_151008_G)});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "steel_spade"), (ItemStack)new ItemStack((Item)ModItems.STEEL_SPADE), (Object[])new Object[]{"x", "x", "i", "i", Character.valueOf('x'), "ingotSoulforgedSteel", Character.valueOf('i'), haft});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "steel_matchpick"), (ItemStack)new ItemStack((Item)ModItems.STEEL_MATCHPICK), (Object[])new Object[]{"xxx", "nic", " i ", " i ", Character.valueOf('x'), "ingotSoulforgedSteel", Character.valueOf('i'), haft, Character.valueOf('n'), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.NETHERCOAL), Character.valueOf('c'), "ingotConcentratedHellfire"});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "steel_machete"), (ItemStack)new ItemStack((Item)ModItems.STEEL_MACHETE), (Object[])new Object[]{"   x", "  x ", " x  ", "i   ", Character.valueOf('x'), "ingotSoulforgedSteel", Character.valueOf('i'), haft});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "steel_kukri"), (ItemStack)new ItemStack((Item)ModItems.STEEL_KUKRI), (Object[])new Object[]{"xx", "x ", "xx", " i", Character.valueOf('x'), "ingotSoulforgedSteel", Character.valueOf('i'), haft});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "steel_carpentersaw"), (ItemStack)new ItemStack((Item)ModItems.STEEL_CARPENTER_SAW), (Object[])new Object[]{"xxxi", "x x ", Character.valueOf('x'), "ingotSoulforgedSteel", Character.valueOf('i'), haft});
        AnvilRecipes.addSteelShapedRecipe((ResourceLocation)new ResourceLocation("betterwithaddons", "steel_masonpick"), (ItemStack)new ItemStack((Item)ModItems.STEEL_MASON_PICK), (Object[])new Object[]{"xxxx", " i  ", " i  ", " i  ", Character.valueOf('x'), "ingotSoulforgedSteel", Character.valueOf('i'), haft});
        int n = axeAmt = ModuleLoader.isFeatureEnabled(CheaperAxes.class) ? 2 : 3;
        if (ModuleLoader.isFeatureEnabled(MetalReclaming.class) && MetalReclaming.reclaimCount > 0) {
            int reclaimCount = MetalReclaming.reclaimCount;
            ItemStack ingotIron = new ItemStack(Items.field_151042_j);
            ItemStack nuggetIron = new ItemStack(Items.field_191525_da);
            ItemStack ingotGold = new ItemStack(Items.field_151043_k);
            ItemStack nuggetGold = new ItemStack(Items.field_151074_bl);
            ItemStack ingotSteel = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.INGOT_STEEL);
            ItemStack nuggetSteel = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.NUGGET_STEEL);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.IRON_SPADE), ingotIron, nuggetIron, reclaimCount * 2);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.IRON_MATCHPICK), ingotIron, nuggetIron, reclaimCount * 3);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.IRON_MACHETE), ingotIron, nuggetIron, reclaimCount * 4);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.IRON_KUKRI), ingotIron, nuggetIron, reclaimCount * (axeAmt + 2));
            this.addReclaimRecipe(new ItemStack((Item)ModItems.IRON_CARPENTER_SAW), ingotIron, nuggetIron, reclaimCount * (axeAmt + 2));
            this.addReclaimRecipe(new ItemStack((Item)ModItems.IRON_MASON_PICK), ingotIron, nuggetIron, reclaimCount * 4);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.GOLD_SPADE), ingotGold, nuggetGold, reclaimCount * 2);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.GOLD_MATCHPICK), ingotGold, nuggetGold, reclaimCount * 3);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.GOLD_MACHETE), ingotGold, nuggetGold, reclaimCount * 4);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.GOLD_KUKRI), ingotGold, nuggetGold, reclaimCount * (axeAmt + 2));
            this.addReclaimRecipe(new ItemStack((Item)ModItems.GOLD_CARPENTER_SAW), ingotGold, nuggetGold, reclaimCount * (axeAmt + 2));
            this.addReclaimRecipe(new ItemStack((Item)ModItems.GOLD_MASON_PICK), ingotGold, nuggetGold, reclaimCount * 4);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.STEEL_SPADE), ingotSteel, nuggetSteel, 18);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.STEEL_MATCHPICK), ingotSteel, nuggetSteel, 27);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.STEEL_MACHETE), ingotSteel, nuggetSteel, 27);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.STEEL_KUKRI), ingotSteel, nuggetSteel, 45);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.STEEL_CARPENTER_SAW), ingotSteel, nuggetSteel, 45);
            this.addReclaimRecipe(new ItemStack((Item)ModItems.STEEL_MASON_PICK), ingotSteel, nuggetSteel, 36);
            if (ModuleLoader.isFeatureEnabled(HCDiamond.class)) {
                ItemStack ingotDiamond = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.DIAMOND_INGOT);
                ItemStack nuggetDiamond = ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.DIAMOND_NUGGET);
                this.addReclaimRecipe(new ItemStack((Item)ModItems.DIAMOND_SPADE), ingotDiamond, nuggetDiamond, 18);
                this.addReclaimRecipe(new ItemStack((Item)ModItems.DIAMOND_MATCHPICK), ingotDiamond, nuggetDiamond, 27);
                this.addReclaimRecipe(new ItemStack((Item)ModItems.DIAMOND_MACHETE), ingotDiamond, nuggetDiamond, 36);
                this.addReclaimRecipe(new ItemStack((Item)ModItems.DIAMOND_KUKRI), ingotDiamond, nuggetDiamond, 9 * (axeAmt + 2));
                this.addReclaimRecipe(new ItemStack((Item)ModItems.DIAMOND_CARPENTER_SAW), ingotDiamond, nuggetDiamond, 9 * (axeAmt + 2));
                this.addReclaimRecipe(new ItemStack((Item)ModItems.DIAMOND_MASON_PICK), ingotDiamond, nuggetDiamond, 36);
            }
        }
        BWRegistry.CAULDRON.addStokedRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)ModBlocks.LURETREE_LOG), new ItemStack((Block)ModBlocks.LURETREE_FACE)}), ItemMaterial.getMaterial((ItemMaterial.EnumMaterial)ItemMaterial.EnumMaterial.POTASH, (int)2)).setPriority(10);
        TileEntityLureTree.addTreeFood(new ItemStack((Item)ModItems.ROTTEN_FOOD), 250);
        TileEntityLureTree.addTreeFood(new ItemStack(Items.field_151078_bh), 250);
        TileEntityLureTree.addTreeFood(new ItemStack(Items.field_151114_aO), 500);
        TileEntityLureTree.addTreeFood(ModItems.MATERIAL.getMaterial("thornrose"), 1000);
        TileEntityLureTree.addTreeFood(new ItemStack(BWMItems.MYSTERY_MEAT), 4000);
        TileEntityAqueductWater.reloadBiomeList();
        ISpecialMeasuringBehavior platformBehavior = new ISpecialMeasuringBehavior(){

            @Override
            public boolean isFull(World world, BlockPos pos, IBlockState state) {
                HashSet<BlockPos> platformBlocks = new HashSet<BlockPos>();
                boolean success = PulleyUtil.findPlatformPart(world, pos, platformBlocks);
                if (success) {
                    return InteractionBWA.this.measurePlatform(world, platformBlocks) >= InteractionBWA.this.countPlatforms(world, platformBlocks);
                }
                return false;
            }

            @Override
            public boolean isEmpty(World world, BlockPos pos, IBlockState state) {
                HashSet<BlockPos> platformBlocks = new HashSet<BlockPos>();
                boolean success = PulleyUtil.findPlatformPart(world, pos, platformBlocks);
                if (success) {
                    return InteractionBWA.this.measurePlatform(world, platformBlocks) == 0 && InteractionBWA.this.countPlatforms(world, platformBlocks) > 0;
                }
                return true;
            }

            @Override
            public int getDelay(World world, BlockPos pos, IBlockState state) {
                return 4;
            }
        };
        BlockWeight.addSpecialMeasuringBehavior((Block)Blocks.field_150383_bp, new ISpecialMeasuringBehavior(){

            @Override
            public boolean isFull(World world, BlockPos pos, IBlockState state) {
                return (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 3;
            }

            @Override
            public boolean isEmpty(World world, BlockPos pos, IBlockState state) {
                return (Integer)state.func_177229_b((IProperty)BlockCauldron.field_176591_a) == 0;
            }

            @Override
            public int getDelay(World world, BlockPos pos, IBlockState state) {
                return 1;
            }
        });
        BlockWeight.addSpecialMeasuringBehavior(BWMBlocks.ANCHOR, new ISpecialMeasuringBehavior(){

            @Override
            public boolean isFull(World world, BlockPos pos, IBlockState state) {
                return false;
            }

            @Override
            public boolean isEmpty(World world, BlockPos pos, IBlockState state) {
                return state.func_177229_b((IProperty)DirUtils.FACING) != EnumFacing.UP;
            }

            @Override
            public int getDelay(World world, BlockPos pos, IBlockState state) {
                return 1;
            }
        });
        BlockWeight.addSpecialMeasuringBehavior(BWMBlocks.PLATFORM, platformBehavior);
        BlockWeight.addSpecialMeasuringBehavior(BWMBlocks.IRON_WALL, platformBehavior);
        ModBlocks.REDSTONE_EMITTER.func_176194_O().func_177619_a().forEach(PulleyStructureManager::registerPulleyBlock);
        GameRegistry.addSmelting((Item)Items.field_151172_bF, (ItemStack)new ItemStack((Item)ModItems.BAKED_CARROT), (float)0.35f);
        GameRegistry.addSmelting((Item)Items.field_185164_cV, (ItemStack)new ItemStack((Item)ModItems.BAKED_BEETROOT), (float)0.35f);
        GameRegistry.addSmelting((Block)Blocks.field_150338_P, (ItemStack)new ItemStack((Item)ModItems.BAKED_MUSHROOM), (float)0.35f);
        GameRegistry.addSmelting((Block)Blocks.field_150337_Q, (ItemStack)new ItemStack((Item)ModItems.BAKED_AMANITA), (float)0.35f);
        boolean hchunger = ModuleLoader.isFeatureEnabled(HCCooking.class);
        BWRegistry.KILN.addStokedRecipe(BlockModUnbaked.getStack(BlockModUnbaked.EnumType.MELON), new ItemStack((Item)ModItems.PIE_MELON, hchunger ? 1 : 2));
        BWRegistry.KILN.addStokedRecipe(BlockModUnbaked.getStack(BlockModUnbaked.EnumType.MEAT), new ItemStack((Item)ModItems.PIE_MEAT, hchunger ? 1 : 2));
        BWRegistry.KILN.addStokedRecipe(BlockModUnbaked.getStack(BlockModUnbaked.EnumType.MUSHROOM), new ItemStack((Item)ModItems.PIE_MUSHROOM, hchunger ? 1 : 2));
        BWRegistry.KILN.addStokedRecipe(BlockModUnbaked.getStack(BlockModUnbaked.EnumType.AMANITA), new ItemStack((Item)ModItems.PIE_AMANITA, hchunger ? 1 : 2));
        GameRegistry.addSmelting((ItemStack)BlockModUnbaked.getStack(BlockModUnbaked.EnumType.MELON), (ItemStack)new ItemStack((Item)ModItems.PIE_MELON), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)BlockModUnbaked.getStack(BlockModUnbaked.EnumType.MEAT), (ItemStack)new ItemStack((Item)ModItems.PIE_MEAT), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)BlockModUnbaked.getStack(BlockModUnbaked.EnumType.MUSHROOM), (ItemStack)new ItemStack((Item)ModItems.PIE_MUSHROOM), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)BlockModUnbaked.getStack(BlockModUnbaked.EnumType.AMANITA), (ItemStack)new ItemStack((Item)ModItems.PIE_AMANITA), (float)0.35f);
        if (STONEBRICKS_NEED_SMELTING) {
            GameRegistry.addSmelting((Block)Blocks.field_150348_b, (ItemStack)ModItems.MATERIAL.getMaterial("stone_brick", 4), (float)0.1f);
        }
        BWRegistry.CAULDRON.addUnstokedRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Item)ModItems.ROTTEN_FOOD)}), new ItemStack(BWMItems.FERTILIZER));
        BlockRopeSideways.addFastenableBlock(ModBlocks.SCAFFOLD);
        BlockRopeSideways.addFastenableBlock((Block)ModBlocks.ROPE_POST);
        BWRegistry.CAULDRON.addRecipe((BulkRecipe)new AdobeRecipe());
    }

    int countPlatforms(World world, HashSet<BlockPos> platforms) {
        int count = 0;
        for (BlockPos pos : platforms) {
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() != BWMBlocks.PLATFORM) continue;
            ++count;
        }
        return count;
    }

    int measurePlatform(World world, HashSet<BlockPos> platforms) {
        int detected = 0;
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        boolean first = true;
        AxisAlignedBB aabb = null;
        for (BlockPos pos : platforms) {
            IBlockState state = world.func_180495_p(pos);
            if (!PulleyStructureManager.isPulleyBlock((IBlockState)state)) continue;
            if (first) {
                minx = pos.func_177958_n();
                miny = pos.func_177956_o();
                minz = pos.func_177952_p();
                maxx = pos.func_177958_n() + 1;
                maxy = pos.func_177956_o() + 1;
                maxz = pos.func_177952_p() + 1;
                first = false;
                continue;
            }
            minx = Math.min(pos.func_177958_n(), minx);
            miny = Math.min(pos.func_177956_o(), miny);
            minz = Math.min(pos.func_177952_p(), minz);
            maxx = Math.max(pos.func_177958_n() + 1, maxx);
            maxy = Math.max(pos.func_177956_o() + 1, maxy);
            maxz = Math.max(pos.func_177952_p() + 1, maxz);
        }
        aabb = new AxisAlignedBB((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz).func_72317_d(0.0, 1.0, 0.0);
        for (Entity entity : world.func_175647_a(Entity.class, aabb, x -> this.isHeavyEntity((Entity)x) && x.field_70122_E)) {
            BlockPos pos = EntityUtil.getEntityFloor(entity, 2);
            if (!platforms.contains(pos)) continue;
            ++detected;
        }
        return detected;
    }

    boolean isHeavyEntity(Entity entity) {
        return entity instanceof EntityLivingBase || entity instanceof EntityMinecart;
    }

    @Override
    void modifyRecipes(RegistryEvent.Register<IRecipe> event) {
        if (ROTTEN_FOOD && ROTTEN_FOOD_COMBINING) {
            event.getRegistry().register(new FoodCombiningRecipe().setRegistryName(new ResourceLocation("betterwithaddons", "food_combining")));
        }
    }

    public void addReclaimRecipe(ItemStack input, ItemStack ingot, ItemStack nugget, int nuggets) {
        int ingots = nuggets / 9;
        input = new ItemStack(input.func_77973_b(), input.func_190916_E(), Short.MAX_VALUE);
        ItemStack ingotStack = ingot.func_77946_l();
        ingotStack.func_190920_e(ingots);
        ItemStack nuggetStack = nugget.func_77946_l();
        nuggetStack.func_190920_e(nuggets %= 9);
        BWRegistry.CRUCIBLE.addStokedRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{input}), (List)Lists.newArrayList((Object[])new ItemStack[]{ingotStack, nuggetStack}));
    }

    @Override
    public void postInit() {
        HashSet<ResourceLocation> rotBlackList = new HashSet<ResourceLocation>();
        for (String resname : ROTTEN_FOOD_BLACKLIST) {
            rotBlackList.add(new ResourceLocation(resname));
        }
        for (Item item : Item.field_150901_e) {
            ItemStack stack;
            if (!(item instanceof ItemFood) || rotBlackList.contains(item.getRegistryName()) || (stack = new ItemStack(item)).func_190926_b()) continue;
            if (item instanceof ItemFishFood || ItemUtil.matchesOreDict(stack, "listAllfish")) {
                RotHandler.addRottingItem(stack, FISH_ROT_TIME, "fish", new ItemStack(Items.field_151078_bh));
                continue;
            }
            if (ItemUtil.matchesOreDict(stack, "foodMeat") || ItemUtil.matchesOreDict(stack, "listAllmeat") || ItemUtil.matchesOreDict(stack, "listAllmeatcooked")) {
                RotHandler.addRottingItem(stack, MEAT_ROT_TIME, "meat", new ItemStack(Items.field_151078_bh));
                continue;
            }
            if (this.isFruit(stack)) {
                RotHandler.addRottingItem(stack, FRUIT_ROT_TIME, "fruit", new ItemStack((Item)ModItems.ROTTEN_FOOD));
                continue;
            }
            RotHandler.addRottingItem(stack, MISC_ROT_TIME);
        }
        RotHandler.addRottingItem(new ItemStack(Items.field_151105_aU, 1, Short.MAX_VALUE));
        RotHandler.addRottingItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()), FISH_ROT_TIME, "fish", new ItemStack(Items.field_151078_bh));
        RotHandler.addRottingItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.CLOWNFISH.func_150976_a()), FISH_ROT_TIME, "fish", new ItemStack(Items.field_151078_bh));
        RotHandler.addRottingItem(new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.PUFFERFISH.func_150976_a()), FISH_ROT_TIME, "fish", new ItemStack(Items.field_151078_bh));
        NonNullList saltDusts = OreDictionary.getOres((String)"foodSalt");
        if (saltDusts != null && saltDusts.size() > 0) {
            ItemStack saltCluster = new ItemStack((Item)ModItems.SALTS, 1, 0);
            ItemStack saltDust = ((ItemStack)saltDusts.get(0)).func_77946_l();
            saltDust.func_190920_e(3);
            BWRegistry.MILLSTONE.addMillRecipe(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{saltCluster}), saltDust);
        }
        this.writeEnchantmentConfigs();
        this.isLoaded = true;
    }

    private boolean isFruit(ItemStack stack) {
        int[] oreids;
        for (int oreid : oreids = OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)oreid).startsWith("crop")) continue;
            return true;
        }
        return false;
    }
}

