/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.entity;

import betterwithaddons.entity.EntityKarateZombie;
import betterwithaddons.entity.IHasSpirits;
import betterwithaddons.interaction.InteractionEriottoMod;
import betterwithaddons.item.ModItems;
import betterwithaddons.util.InventoryUtil;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySpirit
extends Entity {
    public int xpColor;
    public int orbAge;
    public int delayBeforeCanPickup;
    private int orbHealth = 5;
    private Entity homingEntity;
    private static final DataParameter<Integer> SPIRITS = EntityDataManager.func_187226_a(EntitySpirit.class, (DataSerializer)DataSerializers.field_187192_b);
    private float currentAngle;
    private int nextCheck;

    public EntitySpirit(World worldIn) {
        super(worldIn);
        this.currentAngle = (float)Math.toRadians(this.field_70146_Z.nextInt(360));
    }

    public EntitySpirit(World worldIn, double x, double y, double z, int val) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (float)(Math.random() * 0.2 - 0.1) * 2.0f;
        this.field_70181_x = (float)(Math.random() * 0.2) * 2.0f;
        this.field_70179_y = (float)(Math.random() * 0.2 - 0.1) * 2.0f;
        this.setSpiritValue(val);
        this.currentAngle = (float)Math.toRadians(this.field_70146_Z.nextInt(360));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPIRITS, (Object)0);
    }

    public int getSpiritValue() {
        return (Integer)this.field_70180_af.func_187225_a(SPIRITS);
    }

    public void setSpiritValue(int value) {
        this.field_70180_af.func_187227_b(SPIRITS, (Object)value);
    }

    private void applyGravity() {
        RayTraceResult result = this.field_70170_p.func_72933_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(this.field_70165_t, this.field_70163_u - 1.5, this.field_70161_v));
        this.field_70181_x = result != null && result.field_72313_a == RayTraceResult.Type.BLOCK ? (this.field_70181_x += 0.02) : (this.field_70181_x -= 0.02);
    }

    public void func_70071_h_() {
        double dx;
        super.func_70071_h_();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.applyGravity();
        }
        if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
            this.field_70181_x = 0.2f;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        double maxdist = 8.0;
        if (this.xpColor - 20 + this.func_145782_y() % 100 > this.nextCheck) {
            if (this.homingEntity == null || !this.canEntityAbsorbSpirit(this.homingEntity) || this.homingEntity.func_70068_e((Entity)this) > maxdist * maxdist) {
                this.homingEntity = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, maxdist, this::canEntityAbsorbSpirit);
            }
            if (this.homingEntity == null) {
                List entities = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_186662_g(maxdist), this::canEntityAbsorbSpirit);
                Entity badTarget = null;
                for (Entity entity : entities) {
                    long leastSignificantBits = entity.func_110124_au().getLeastSignificantBits() & 0xFFFFL;
                    if (leastSignificantBits % 4L == (long)(this.func_145782_y() % 100 % 4)) {
                        this.homingEntity = entity;
                    }
                    badTarget = entity;
                }
                if (this.homingEntity == null) {
                    this.homingEntity = badTarget;
                }
            }
            this.nextCheck = this.xpColor;
            this.currentAngle = (float)Math.toRadians(this.field_70146_Z.nextInt(360));
        }
        if (this.homingEntity != null) {
            double dz;
            dx = (this.homingEntity.field_70165_t - this.field_70165_t) / maxdist;
            double dy = (this.homingEntity.field_70163_u + (double)this.homingEntity.func_70047_e() / 2.0 - this.field_70163_u) / maxdist;
            double dist = Math.sqrt(dx * dx + dy * dy + (dz = (this.homingEntity.field_70161_v - this.field_70161_v) / maxdist) * dz);
            double d5 = 1.0 - dist;
            if (d5 > 0.0) {
                d5 *= d5;
                this.field_70159_w += dx / dist * d5 * 0.1;
                this.field_70181_x += dy / dist * d5 * 0.1;
                this.field_70179_y += dz / dist * d5 * 0.1;
            }
            if (dist < 0.1) {
                this.onEntityAbsorb(this.homingEntity);
            }
        } else {
            dx = (double)MathHelper.func_76126_a((float)this.currentAngle) * 0.01;
            double dz = (double)MathHelper.func_76134_b((float)this.currentAngle) * 0.01;
            this.field_70159_w += dx;
            this.field_70179_y += dz;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            f = this.field_70170_p.func_180495_p((BlockPos)new BlockPos((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().field_149765_K * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= (double)-0.9f;
        }
        ++this.xpColor;
        ++this.orbAge;
        if (this.orbAge >= InteractionEriottoMod.MAX_SPIRIT_AGE) {
            this.func_70106_y();
        }
    }

    public boolean canEntityAbsorbSpirit(Entity entity) {
        if (entity.field_70128_L) {
            return false;
        }
        if (entity instanceof EntityPlayer) {
            return this.canPlayerAbsorbSpirit((EntityPlayer)entity);
        }
        if (entity instanceof IHasSpirits) {
            return ((IHasSpirits)entity).canAbsorbSpirits();
        }
        ResourceLocation resourceLocation = EntityList.func_191301_a((Entity)entity);
        return resourceLocation != null && InteractionEriottoMod.TRANSFORM_ZOMBIES.contains(resourceLocation.toString());
    }

    public boolean canPlayerAbsorbSpirit(EntityPlayer player) {
        return !player.func_175149_v() && InventoryUtil.getInventorySlotContainItem((IInventory)player.field_71071_by, Items.field_151069_bo) >= 0;
    }

    public int consumeSpirit(int n) {
        int spiritValue = this.getSpiritValue();
        int consumed = Math.min(n, spiritValue);
        this.setSpiritValue(spiritValue - consumed);
        if (this.getSpiritValue() <= 0) {
            this.func_70106_y();
        }
        return n - consumed;
    }

    public void onEntityAbsorb(Entity entity) {
        if (!this.field_70170_p.field_72995_K && !entity.field_70128_L) {
            ResourceLocation resourceLocation = EntityList.func_191301_a((Entity)entity);
            if (entity instanceof EntityPlayer) {
                this.onPlayerAbsorb((EntityPlayer)entity);
            } else if (resourceLocation != null && InteractionEriottoMod.TRANSFORM_ZOMBIES.contains(resourceLocation.toString())) {
                this.onZombieAbsorb((EntityLivingBase)entity);
            } else if (entity instanceof IHasSpirits) {
                int remainder = ((IHasSpirits)entity).absorbSpirits(this.getSpiritValue());
                this.setSpiritValue(remainder);
                if (remainder == 0) {
                    this.func_70106_y();
                }
            }
        }
    }

    public void onPlayerAbsorb(EntityPlayer player) {
        if (this.delayBeforeCanPickup == 0 && player.field_71090_bL == 0) {
            player.field_71090_bL = 2;
            List spirits = this.field_70170_p.func_72872_a(EntitySpirit.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(0.5));
            int totalSpirit = 0;
            for (EntitySpirit spirit : spirits) {
                totalSpirit += spirit.getSpiritValue();
            }
            if (totalSpirit >= InteractionEriottoMod.BOTTLE_MAX_SPIRITS) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack itemstack = player.field_71071_by.func_70301_a(i);
                    if (itemstack.func_77973_b() != Items.field_151069_bo) continue;
                    itemstack.func_190918_g(1);
                    player.field_71071_by.func_70299_a(i, itemstack);
                    InventoryUtil.addItemToPlayer(player, new ItemStack((Item)ModItems.ANCESTRY_BOTTLE));
                    int consumed = InteractionEriottoMod.BOTTLE_MAX_SPIRITS;
                    for (EntitySpirit spirit : spirits) {
                        consumed = spirit.consumeSpirit(consumed);
                    }
                    break;
                }
            }
        }
    }

    public void copyEntityInfo(EntityLivingBase copyFrom, EntityLivingBase copyTo) {
        copyTo.func_70606_j(copyFrom.func_110143_aJ());
        copyTo.func_70080_a(copyFrom.field_70165_t, copyFrom.field_70163_u, copyFrom.field_70161_v, copyFrom.field_70177_z, copyFrom.field_70125_A);
        copyTo.func_70034_d(copyFrom.func_70079_am());
        copyTo.func_70604_c(copyFrom.func_70643_av());
        copyTo.func_96094_a(copyFrom.func_95999_t());
    }

    public void onZombieAbsorb(EntityLivingBase entity) {
        if (this.delayBeforeCanPickup == 0) {
            EntityKarateZombie zombie = new EntityKarateZombie(entity.func_130014_f_());
            this.copyEntityInfo(entity, (EntityLivingBase)zombie);
            zombie.setSpirits(1);
            entity.func_70106_y();
            zombie.func_130014_f_().func_72838_d((Entity)zombie);
            this.consumeSpirit(1);
        }
    }

    public int getTextureBySpirits() {
        if (this.getSpiritValue() >= 128) {
            return 10;
        }
        if (this.getSpiritValue() >= 64) {
            return 8;
        }
        if (this.getSpiritValue() >= 3) {
            return 6;
        }
        if (this.getSpiritValue() >= 2) {
            return 4;
        }
        if (this.getSpiritValue() >= 1) {
            return 2;
        }
        return 0;
    }

    public static int getSpiritSplit(int value) {
        return value >= 128 ? 128 : (value >= 64 ? 64 : (value >= 3 ? 3 : (value >= 2 ? 2 : 1)));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public int func_70070_b() {
        float f = 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        this.orbHealth = (int)((float)this.orbHealth - amount);
        if (this.orbHealth <= 0) {
            this.func_70106_y();
        }
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("Health", (short)this.orbHealth);
        compound.func_74777_a("Age", (short)this.orbAge);
        compound.func_74777_a("Value", (short)this.getSpiritValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.orbHealth = compound.func_74765_d("Health");
        this.orbAge = compound.func_74765_d("Age");
        this.setSpiritValue(compound.func_74765_d("Value"));
    }

    public boolean func_70075_an() {
        return false;
    }
}

