/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.enchantment;

import betterwithaddons.util.ItemUtil;
import java.util.HashSet;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentMending;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EnchantmentMendingGoldOnly
extends EnchantmentMending {
    private static HashSet<String> goldItems = new HashSet();

    public static void reset() {
        goldItems.clear();
    }

    public static void register(String goldItem) {
        goldItems.add(goldItem);
    }

    public EnchantmentMendingGoldOnly(Enchantment.Rarity rarityIn, EntityEquipmentSlot ... slots) {
        super(rarityIn, slots);
        this.field_77351_y = EnumHelper.addEnchantmentType((String)"GOLD_ONLY", this::appliesToItem);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private boolean appliesToItem(Item item) {
        Item.ToolMaterial toolMaterial = ItemUtil.getToolMaterial(item);
        ItemArmor.ArmorMaterial armorMaterial = ItemUtil.getArmorMaterial(item);
        if (toolMaterial != null && toolMaterial.name().equals("GOLD")) {
            return true;
        }
        if (armorMaterial != null && armorMaterial.name().equals("GOLD")) {
            return true;
        }
        return goldItems.contains(item.getRegistryName().toString());
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.appliesToItem(stack.func_77973_b());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onXP(PlayerPickupXpEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
        EntityXPOrb orb = event.getOrb();
        if (!this.appliesToItem(stack.func_77973_b())) {
            player.field_71090_bL = 2;
            player.func_71001_a((Entity)orb, 1);
            if (orb.field_70530_e > 0) {
                player.func_71023_q(orb.field_70530_e);
            }
            orb.func_70106_y();
        }
    }
}

