/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.recipes;

import betterwithaddons.crafting.recipes.INabeRecipe;
import betterwithaddons.item.ItemTea;
import betterwithaddons.tileentity.TileEntityNabe;
import betterwithaddons.util.NabeResult;
import betterwithaddons.util.NabeResultTea;
import betterwithaddons.util.TeaType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TeaNabeRecipe
implements INabeRecipe {
    public static final HashMap<Potion, Potion> OPPOSITES = new HashMap();

    public static void addOpposite(Potion a, Potion b) {
        OPPOSITES.put(a, b);
        OPPOSITES.put(b, a);
    }

    @Override
    public int getBoilingTime(TileEntityNabe tile) {
        return 1000;
    }

    @Override
    public boolean isValidItem(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemTea || this.isMilk(stack) || this.isSugar(stack);
    }

    private boolean isSugar(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151102_aT;
    }

    private boolean isMilk(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151117_aB;
    }

    @Override
    public boolean matches(TileEntityNabe tile, List<ItemStack> stacks) {
        int itemCount = tile.countIngredients();
        boolean hasTea = stacks.stream().anyMatch(stack -> stack.func_77973_b() instanceof ItemTea && stack.func_190916_E() >= 2);
        return itemCount >= 3 && hasTea;
    }

    @Override
    public NabeResult craft(TileEntityNabe tile, List<ItemStack> stacks) {
        ItemStack mainTea = ItemStack.field_190927_a;
        ItemStack secondaryTea = ItemStack.field_190927_a;
        int milk = 0;
        int sugar = 0;
        int totalAmount = 0;
        for (ItemStack stack : stacks) {
            Item item = stack.func_77973_b();
            int count = stack.func_190916_E();
            if (item instanceof ItemTea) {
                if (mainTea == null || mainTea.func_190916_E() < count) {
                    secondaryTea = mainTea;
                    mainTea = stack;
                } else if (secondaryTea == null || secondaryTea.func_190916_E() < count) {
                    secondaryTea = stack;
                }
            }
            if (this.isMilk(stack)) {
                milk += count;
            }
            if (this.isSugar(stack)) {
                sugar += count;
            }
            totalAmount += count;
        }
        TeaType mainType = ItemTea.getType(mainTea);
        TeaType secondaryType = secondaryTea.func_190926_b() ? null : ItemTea.getType(secondaryTea);
        boolean isCeremonial = mainTea.func_190916_E() == 6 && mainType == TeaType.MATCHA;
        int strength = Math.max(this.getStrength(mainTea), this.getStrength(secondaryTea));
        Color color = new Color(mainType.getPowderColor());
        if (milk > 1) {
            color.brighter();
        }
        if (sugar > 1) {
            color.darker();
        }
        NabeResultTea result = new NabeResultTea(color.getRGB(), totalAmount, totalAmount);
        result.mainType = mainType;
        result.sugar = sugar;
        result.milk = milk;
        result.strength = strength;
        if (isCeremonial) {
            result.isCeremonial = true;
            Random random = tile.random;
            ArrayList<PotionEffect> positives = new ArrayList<PotionEffect>(mainType.getPositiveEffects());
            ArrayList<PotionEffect> negatives = new ArrayList<PotionEffect>(mainType.getNegativeEffects());
            for (int i = 0; i < 3; ++i) {
                PotionEffect effect = positives.get(random.nextInt(positives.size()));
                result.effects.add(effect);
                positives.remove(effect);
            }
            result.effects.add(negatives.get(random.nextInt(negatives.size())));
        } else {
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>(mainType.getNegativeEffects(ItemTea.getItemType(mainTea)));
            if (secondaryType != null) {
                effects.addAll(secondaryType.getNegativeEffects(ItemTea.getItemType(secondaryTea)));
            }
            while (milk > 0 && effects.size() > 0) {
                effects.remove(0);
                --milk;
            }
            effects.addAll(mainType.getPositiveEffects(ItemTea.getItemType(mainTea)));
            if (secondaryType != null) {
                effects.addAll(secondaryType.getPositiveEffects(ItemTea.getItemType(secondaryTea)));
            }
            for (int i = 0; i < effects.size(); ++i) {
                PotionEffect effect = effects.get(i);
                effect = this.extendEffect(effect, duration -> duration * strength / 2);
                if (sugar > 0) {
                    effect = this.powerUpEffect(effect, existing -> existing.func_76458_c() < 2 && !existing.func_188419_a().func_76398_f() ? existing.func_76458_c() + 1 : existing.func_76458_c());
                    --sugar;
                }
                effects.set(i, effect);
            }
            for (PotionEffect effect : effects) {
                Optional<PotionEffect> existing2 = result.effects.stream().filter(x -> x.func_188419_a() == effect.func_188419_a() || TeaNabeRecipe.isOpposite(x.func_188419_a(), effect.func_188419_a())).findFirst();
                if (existing2.isPresent()) {
                    PotionEffect other = existing2.get();
                    if (TeaNabeRecipe.isOpposite(effect.func_188419_a(), other.func_188419_a())) {
                        result.effects.remove(other);
                        result.effects.add(effect);
                        continue;
                    }
                    other.func_76452_a(effect);
                    continue;
                }
                result.effects.add(effect);
            }
        }
        ItemStackHandler inventory = tile.inventory;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!this.isValidItem(stack)) continue;
            stack = tile.consumeItem(stack);
            inventory.setStackInSlot(i, stack);
        }
        return result;
    }

    private PotionEffect extendEffect(PotionEffect effect, Function<Integer, Integer> transform) {
        PotionEffect newEffect = new PotionEffect(effect.func_188419_a(), transform.apply(effect.func_76459_b()).intValue(), effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e());
        newEffect.setCurativeItems(effect.getCurativeItems());
        return newEffect;
    }

    private PotionEffect powerUpEffect(PotionEffect effect, Function<PotionEffect, Integer> transform) {
        PotionEffect newEffect = new PotionEffect(effect.func_188419_a(), effect.func_76459_b(), transform.apply(effect).intValue(), effect.func_82720_e(), effect.func_188418_e());
        newEffect.setCurativeItems(effect.getCurativeItems());
        return newEffect;
    }

    private int getStrength(ItemStack tea) {
        if (tea.func_190926_b()) {
            return 0;
        }
        switch (ItemTea.getItemType(tea)) {
            case Leaves: {
                return (int)Math.round(MathHelper.func_151238_b((double)0.0, (double)3.0, (double)((double)tea.func_190916_E() / 6.0)));
            }
            case Soaked: 
            case Wilted: {
                return (int)Math.round(MathHelper.func_151238_b((double)0.0, (double)4.0, (double)((double)tea.func_190916_E() / 5.0)));
            }
            case Powder: {
                return (int)Math.round(MathHelper.func_151238_b((double)0.0, (double)4.0, (double)((double)tea.func_190916_E() / 4.0)));
            }
        }
        return 0;
    }

    private static boolean isOpposite(Potion a, Potion b) {
        return OPPOSITES.get(a) == b || OPPOSITES.get(b) == a;
    }

    @Override
    public String getName() {
        return "tea";
    }

    @Override
    public int getPriority() {
        return 100;
    }

    static {
        TeaNabeRecipe.addOpposite(MobEffects.field_76432_h, MobEffects.field_76433_i);
        TeaNabeRecipe.addOpposite(MobEffects.field_76428_l, MobEffects.field_76436_u);
        TeaNabeRecipe.addOpposite(MobEffects.field_76439_r, MobEffects.field_76440_q);
        TeaNabeRecipe.addOpposite(MobEffects.field_76443_y, MobEffects.field_76438_s);
        TeaNabeRecipe.addOpposite(MobEffects.field_76424_c, MobEffects.field_76421_d);
        TeaNabeRecipe.addOpposite(MobEffects.field_76420_g, MobEffects.field_76437_t);
        TeaNabeRecipe.addOpposite(MobEffects.field_76441_p, MobEffects.field_188423_x);
        TeaNabeRecipe.addOpposite(MobEffects.field_188425_z, MobEffects.field_189112_A);
    }
}

