/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.crafting.manager;

import betterwithaddons.crafting.recipes.SpindleRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class CraftingManagerSpindle {
    private static final CraftingManagerSpindle instance = new CraftingManagerSpindle();
    private List<SpindleRecipe> recipes = new ArrayList<SpindleRecipe>();

    public static CraftingManagerSpindle getInstance() {
        return instance;
    }

    public void addRecipe(ItemStack[] outputs, Ingredient input, boolean consumesSpindle) {
        this.recipes.add(this.createRecipe(outputs, input, consumesSpindle));
    }

    public void addRecipe(SpindleRecipe recipe) {
        this.recipes.add(recipe);
    }

    public List<SpindleRecipe> findRecipeForRemoval(@Nonnull ItemStack input) {
        return this.recipes.stream().filter(recipe -> recipe.matchesInput(input)).collect(Collectors.toList());
    }

    public SpindleRecipe getMostValidRecipe(List<EntityItem> inv) {
        List<SpindleRecipe> recipes = this.getValidCraftingRecipes(inv);
        if (recipes == null || recipes.size() == 0) {
            return null;
        }
        return recipes.get(0);
    }

    public List<SpindleRecipe> getValidCraftingRecipes(List<EntityItem> inv) {
        return this.recipes.stream().filter(recipe -> recipe.matches(inv)).collect(Collectors.toCollection(ArrayList::new));
    }

    private SpindleRecipe createRecipe(ItemStack[] outputs, Ingredient input, boolean consumesSpindle) {
        return new SpindleRecipe(consumesSpindle, input, outputs);
    }

    public List<SpindleRecipe> getRecipes() {
        return this.recipes;
    }
}

