/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.block.BlockBase;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.item.ModItems;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockThorns
extends BlockBase {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    protected BlockThorns() {
        super("thorns", Material.field_151575_d);
        this.func_149711_c(4.0f);
        this.setHarvestLevel("axe", 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, FACING});
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing.func_176745_a() & 7;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean hasStem = this.hasStem(worldIn, pos, state);
        return state.func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.DOWN, hasStem))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.UP, hasStem))).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.NORTH, hasStem))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.EAST, hasStem))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.SOUTH, hasStem))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(worldIn, pos, EnumFacing.WEST, hasStem)));
    }

    public EnumFacing getStem(IBlockState state) {
        if (state.func_177230_c() != this) {
            return EnumFacing.DOWN;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return facing != null ? facing : EnumFacing.DOWN;
    }

    public IBlockState setStem(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    private boolean hasStem(IBlockAccess world, BlockPos pos, IBlockState state) {
        EnumFacing stemDir = this.getStem(state);
        BlockPos stemPos = pos.func_177972_a(stemDir);
        IBlockState stemState = world.func_180495_p(stemPos);
        return this.isProperSoil(world, stemPos, stemDir) || this.isVine(stemState.func_177230_c());
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing connectDir, boolean hasStem) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing stemDir = this.getStem(state);
        BlockPos otherpos = pos.func_177972_a(connectDir);
        IBlockState otherState = world.func_180495_p(otherpos);
        Block otherblock = otherState.func_177230_c();
        if (otherblock == this) {
            if (!hasStem) {
                return true;
            }
            if (stemDir == connectDir) {
                return true;
            }
            if (this.hasStem(world, otherpos, otherState)) {
                return this.getStem(otherState) == connectDir.func_176734_d();
            }
            return true;
        }
        return this.isVine(otherblock) || this.isProperSoil(world, otherpos, connectDir);
    }

    public boolean isProperSoil(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return ModBlocks.THORN_ROSE.isProperSoil(world, pos, facing);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canSurvive(worldIn, pos) : false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityLivingBase) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 5.0f);
        }
    }

    public boolean canSurvive(World world, BlockPos pos) {
        int adjacentVines = 0;
        int adjacentSoil = 0;
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (this.isVine(block)) {
                ++adjacentVines;
                continue;
            }
            if (!this.isProperSoil((IBlockAccess)world, blockpos, enumfacing)) continue;
            ++adjacentSoil;
        }
        return (adjacentSoil > 0 || adjacentVines > 0) && adjacentVines <= 3;
    }

    private boolean isVine(Block block) {
        return block == this || block == ModBlocks.THORN_ROSE;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        float f = 0.1875f;
        float f1 = (Boolean)state.func_177229_b((IProperty)WEST) != false ? 0.0f : 0.1875f;
        float f2 = (Boolean)state.func_177229_b((IProperty)DOWN) != false ? 0.0f : 0.1875f;
        float f3 = (Boolean)state.func_177229_b((IProperty)NORTH) != false ? 0.0f : 0.1875f;
        float f4 = (Boolean)state.func_177229_b((IProperty)EAST) != false ? 1.0f : 0.8125f;
        float f5 = (Boolean)state.func_177229_b((IProperty)UP) != false ? 1.0f : 0.8125f;
        float f6 = (Boolean)state.func_177229_b((IProperty)SOUTH) != false ? 1.0f : 0.8125f;
        return new AxisAlignedBB((double)f1, (double)f2, (double)f3, (double)f4, (double)f5, (double)f6);
    }

    public void addCollisionBoxToList(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn) {
        state = state.func_185899_b((IBlockAccess)worldIn, pos);
        float f = 0.1875f;
        float f1 = 0.8125f;
        BlockThorns.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.1875, 0.8125, 0.8125, 0.8125));
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockThorns.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.1875, 0.1875, 0.1875, 0.8125, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockThorns.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.8125, 0.1875, 0.1875, 1.0, 0.8125, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockThorns.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.8125, 0.1875, 0.8125, 1.0, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockThorns.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125));
        }
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockThorns.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 0.1875));
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockThorns.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)new AxisAlignedBB(0.1875, 0.1875, 0.8125, 0.8125, 0.8125, 1.0));
        }
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return Lists.newArrayList((Object[])new ItemStack[]{ModItems.MATERIAL.getMaterial("midori")});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !this.canConnectTo(blockAccess, pos.func_177972_a(side), side, this.hasStem(blockAccess, pos, blockState));
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

