/*
 * Decompiled with CFR 0.152.
 */
package betterwithaddons.block;

import betterwithaddons.BetterWithAddons;
import betterwithaddons.block.BlockAqueductWater;
import betterwithaddons.block.BlockBase;
import betterwithaddons.block.ModBlocks;
import betterwithaddons.interaction.InteractionBWA;
import betterwithaddons.tileentity.TileEntityAqueductWater;
import betterwithaddons.util.IHasVariants;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockAqueduct
extends BlockBase
implements IHasVariants {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockAqueduct() {
        super("aqueduct", Material.field_151576_e);
        this.func_149711_c(2.1f).func_149752_b(8.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149675_a(true);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (fromPos.equals((Object)pos.func_177984_a())) {
            worldIn.func_175684_a(pos, (Block)this, 25);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        worldIn.func_175684_a(pos, (Block)this, 25);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IBlockState waterState = worldIn.func_180495_p(pos.func_177984_a());
        Block block = waterState.func_177230_c();
        if (waterState.func_185904_a() == Material.field_151586_h && (Integer)waterState.func_177229_b((IProperty)BlockLiquid.field_176367_b) != 0) {
            int dist = TileEntityAqueductWater.getMinDistance(worldIn, pos.func_177984_a()) + 1;
            if (dist <= InteractionBWA.AQUEDUCT_MAX_LENGTH) {
                worldIn.func_175656_a(pos.func_177984_a(), ModBlocks.AQUEDUCT_WATER.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(8)));
                TileEntity te = worldIn.func_175625_s(pos.func_177984_a());
                if (te instanceof TileEntityAqueductWater) {
                    ((TileEntityAqueductWater)te).setDistanceFromSource(dist);
                }
            }
        } else if (waterState.func_177230_c() instanceof BlockAqueductWater) {
            ((BlockAqueductWater)waterState.func_177230_c()).checkAndDry(worldIn, pos.func_177984_a(), waterState);
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab.equals((Object)BetterWithAddons.instance.creativeTab)) {
            for (EnumType type : EnumType.values()) {
                items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public List<ModelResourceLocation> getVariantModels() {
        EnumType[] values = EnumType.values();
        ModelResourceLocation[] rlist = new ModelResourceLocation[values.length];
        for (EnumType type : values) {
            rlist[type.getMetadata()] = new ModelResourceLocation(this.getRegistryName(), "variant=" + type.func_176610_l());
        }
        return Arrays.asList(rlist);
    }

    @Override
    public String getVariantName(int meta) {
        return null;
    }

    public static enum EnumType implements IStringSerializable
    {
        STONE_BRICKS(0, "stone_bricks"),
        BRICKS(1, "bricks"),
        QUARTZ(2, "quartz"),
        WHITESTONE_BRICKS(3, "whitestone_bricks"),
        SANDSTONE(4, "sandstone"),
        RED_SANDSTONE(5, "red_sandstone"),
        ANDESITE(6, "andesite"),
        GRANITE(7, "granite"),
        DIORITE(8, "diorite"),
        PRISMARINE(9, "prismarine"),
        DARK_PRISMARINE(10, "dark_prismarine");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

