/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.block;

import com.google.common.collect.ImmutableMap;
import java.util.function.Function;
import net.darkhax.bookshelf.client.model.block.CachedDynamicBakedModel;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.huntingdim.block.BlockHuntingFrame;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelFrame
extends CachedDynamicBakedModel {
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> {
        assert (location != null);
        return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
    };
    private final ImmutableMap<? extends IModelPart, TRSRTransformation> transforms;

    public ModelFrame(IBakedModel baked, IModel raw) {
        super(baked, raw);
        this.transforms = RenderUtils.copyTransforms((IBakedModel)baked);
    }

    public String getCacheKey(IBlockState state, EnumFacing side) {
        ItemStack stack = (ItemStack)((IExtendedBlockState)state).getValue(BlockHuntingFrame.BASE_BLOCK);
        if (stack == null || stack.func_190926_b()) {
            stack = new ItemStack(Blocks.field_150364_r);
        }
        return RenderUtils.getParticleTexture((ItemStack)stack).func_94215_i();
    }

    public String getCacheKey(ItemStack stack, World world, EntityLivingBase entity) {
        return RenderUtils.getParticleTexture((ItemStack)BlockHuntingFrame.getVariantFromTag(stack.func_77978_p())).func_94215_i();
    }

    public IBakedModel generateBlockModel(String key) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String texture = key == null ? "minecraft:blocks/stone" : key;
        builder.put((Object)"texture", (Object)texture);
        builder.put((Object)"particle", (Object)texture);
        return this.getRaw().retexture(builder.build()).bake((IModelState)new SimpleModelState(this.transforms), DefaultVertexFormats.field_176600_a, this.textureGetter);
    }
}

