/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim;

import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.lib.LoggingHelper;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.huntingdim.block.BlockHuntingFrame;
import net.darkhax.huntingdim.block.BlockHuntingPortal;
import net.darkhax.huntingdim.block.ModelFrame;
import net.darkhax.huntingdim.block.TileEntityFrame;
import net.darkhax.huntingdim.creativetab.CreativeTabHunting;
import net.darkhax.huntingdim.dimension.WorldProviderHunting;
import net.darkhax.huntingdim.events.EventLoader;
import net.darkhax.huntingdim.handler.ConfigurationHandler;
import net.darkhax.huntingdim.handler.DimensionEffectHandler;
import net.darkhax.huntingdim.item.ItemBiomeChanger;
import net.darkhax.huntingdim.item.ItemBlockColor;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.DimensionType;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="huntingdim", name="Hunting Dimension", version="1.0.42", dependencies="required-after:bookshelf@[2.3.561,)", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.12.2]")
public class HuntingDimension {
    public static DimensionType dimensionType;
    public static final LoggingHelper LOG;
    public static final RegistryHelper REGISTRY;
    public static Block portal;
    public static Block frame;
    public static ItemBlock frameItem;
    public static Item moss;
    public static final List<Tuple<ItemStack, ItemStack>> frameVariants;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        EventLoader.loadCurrentEvents();
        new ConfigurationHandler();
        dimensionType = DimensionType.register((String)"hunting_dim", (String)"_hunting", (int)ConfigurationHandler.dimensionId, WorldProviderHunting.class, (boolean)false);
        DimensionManager.registerDimension((int)ConfigurationHandler.dimensionId, (DimensionType)dimensionType);
        frame = new BlockHuntingFrame();
        frameItem = new ItemBlockColor(frame);
        REGISTRY.registerBlock(frame, frameItem, "frame");
        GameRegistry.registerTileEntity(TileEntityFrame.class, (String)"huntingdim:frame");
        portal = new BlockHuntingPortal();
        REGISTRY.registerBlock(portal, (ItemBlock)new ItemBlockColor(portal), "portal");
        moss = REGISTRY.registerItem((Item)new ItemBiomeChanger(), "biome_changer");
        ItemStack mossPlains = ItemBiomeChanger.setBiome(new ItemStack(moss, 4, 0), Biomes.field_76772_c);
        REGISTRY.addShapedRecipe("moss_sappling", mossPlains, new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "treeSapling", Character.valueOf('y'), Blocks.field_150341_Y});
        REGISTRY.addShapedRecipe("moss_leaves", mossPlains, new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "treeLeaves", Character.valueOf('y'), Blocks.field_150341_Y});
        REGISTRY.addShapedRecipe("moss_vines", mossPlains, new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "vine", Character.valueOf('y'), Blocks.field_150341_Y});
        ItemStack stackMoss = ItemBiomeChanger.setBiome(new ItemStack(moss), Biomes.field_76772_c);
        REGISTRY.addShapedRecipe("moss_special_nether", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_76778_j), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "netherrack", Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_end", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_76779_k), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "endstone", Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_ice", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_76774_n), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Blocks.field_150432_aD, Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_dessert", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_76769_d), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "sand", Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_jungle", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_76782_w), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), "dyeBrown", Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_swamp_red", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_76780_h), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Blocks.field_150337_Q, Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_swamp_brown", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_76780_h), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Blocks.field_150338_P, Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_mesa", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_150589_Z), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Blocks.field_150405_ch, Character.valueOf('y'), moss});
        REGISTRY.addShapedRecipe("moss_special_mesa_stained", ItemBiomeChanger.setBiome(stackMoss.func_77946_l(), Biomes.field_150589_Z), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Blocks.field_150406_ce, Character.valueOf('y'), moss});
        MinecraftForge.EVENT_BUS.register((Object)new DimensionEffectHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (frameVariants.isEmpty()) {
            for (ItemStack itemStack : StackUtils.getAllBlocksForOredict((String)"logWood")) {
                if (!(itemStack.func_77973_b() instanceof ItemBlock)) continue;
                try {
                    Block block = ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
                    IBlockState state = block.getStateForPlacement(null, null, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, itemStack.func_77960_j(), null, EnumHand.MAIN_HAND);
                    if (!state.func_185917_h()) continue;
                    frameVariants.add((Tuple<ItemStack, ItemStack>)new Tuple((Object)itemStack, (Object)BlockHuntingFrame.createFrameVariant(itemStack)));
                }
                catch (Exception e) {
                    LOG.catching((Throwable)e);
                }
            }
        }
        for (Tuple tuple : frameVariants) {
            ItemStack output = ((ItemStack)tuple.func_76340_b()).func_77946_l();
            ItemStack logStack = (ItemStack)tuple.func_76341_a();
            output.func_190920_e(4);
            ShapedOreRecipe recipe = new ShapedOreRecipe(null, output, new Object[]{"xxx", "xax", "xxx", Character.valueOf('x'), logStack, Character.valueOf('a'), "arrow"});
            recipe.setRegistryName("frame_" + StackUtils.getStackIdentifier((ItemStack)logStack).replace(":", "_") + "_" + logStack.func_77952_i());
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        try {
            ResourceLocation modelLocation = new ResourceLocation("huntingdim", "block/frame");
            IModel raw = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
            ModelResourceLocation bakedLocation = new ModelResourceLocation(new ResourceLocation("huntingdim", "frame"), "normal");
            IBakedModel baked = (IBakedModel)event.getModelRegistry().func_82594_a((Object)bakedLocation);
            event.getModelRegistry().func_82595_a((Object)bakedLocation, (Object)new ModelFrame(baked, raw));
            ModelResourceLocation itemLocation = new ModelResourceLocation(new ResourceLocation("huntingdim", "frame"), "inventory");
            IBakedModel bakedItem = (IBakedModel)event.getModelRegistry().func_82594_a((Object)itemLocation);
            event.getModelRegistry().func_82595_a((Object)itemLocation, (Object)new ModelFrame(bakedItem, raw));
        }
        catch (Exception e) {
            LOG.catching((Throwable)e);
        }
    }

    static {
        LOG = new LoggingHelper("Hunting Dimension");
        REGISTRY = new RegistryHelper().setTab((CreativeTabs)new CreativeTabHunting()).enableAutoRegistration();
        frameVariants = new ArrayList<Tuple<ItemStack, ItemStack>>();
    }
}

