/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.common.blocks;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.common.blocks.Types;
import com.oitsjustjose.geolosys.common.config.ModConfig;
import com.oitsjustjose.geolosys.common.util.Utils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockSampleVanilla
extends Block {
    public static final PropertyEnum<Types.Vanilla> VARIANT = PropertyEnum.func_177709_a((String)"variant", Types.Vanilla.class);
    private ArrayList<IBlockState> canPlaceBlacklist;

    public BlockSampleVanilla() {
        super(Material.field_151578_c);
        this.setRegistryName(new ResourceLocation("geolosys", "ore_sample_vanilla"));
        this.func_149711_c(0.125f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.COAL)));
        this.func_149663_c(this.getRegistryName().toString().replaceAll(":", "."));
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)new ItemBlockOre(this));
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.parsePlaceBlacklist();
    }

    private void parsePlaceBlacklist() {
        this.canPlaceBlacklist = new ArrayList();
        for (String s : ModConfig.prospecting.samplePlaceBlacklist) {
            String[] parts = s.split(":");
            if (parts.length < 2 || parts.length > 3) {
                Geolosys.getInstance().LOGGER.info("Entry " + s + " has incorrect formatting in samplePlaceBlacklist; skipping.");
                continue;
            }
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
            if (b == null) {
                Geolosys.getInstance().LOGGER.info("Entry " + s + " does not seem to exist; skipping.");
                continue;
            }
            if (parts.length == 3) {
                this.canPlaceBlacklist.add(Utils.getStateFromMeta(b, Integer.parseInt(parts[2])));
                continue;
            }
            this.canPlaceBlacklist.add(b.func_176223_P());
        }
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.func_176196_c(worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (IBlockState state : this.canPlaceBlacklist) {
            if (!Utils.doStatesMatch(state, worldIn.func_180495_p(pos.func_177977_b()))) continue;
            return false;
        }
        return worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (ModConfig.prospecting.boringSamples) {
            String resource = Types.Vanilla.byMetadata(state.func_177230_c().func_176201_c(state)).getResource();
            playerIn.func_146105_b((ITextComponent)new TextComponentString("You break the sample to find " + resource), true);
        } else {
            this.func_176226_b(worldIn, pos, state, 0);
        }
        worldIn.func_175698_g(pos);
        playerIn.func_184609_a(EnumHand.MAIN_HAND);
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.2f, 0.0, (double)0.2f, (double)0.8f, 0.25, (double)0.8f);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (ModConfig.prospecting.boringSamples) {
            drops.clear();
            return;
        }
        Geolosys.getInstance().ORE_VANILLA.getDrops(drops, world, pos, state, fortune);
        for (ItemStack stack : drops) {
            if (stack.func_190916_E() <= 1) continue;
            stack.func_190920_e(1);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, this.func_176201_c(state));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.byMetadata(meta)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Types.Vanilla.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Types.Vanilla)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @SubscribeEvent
    public void registerEvent(BlockEvent.HarvestDropsEvent event) {
        if (!ModConfig.prospecting.boringSamples || event.getHarvester() == null || event.getState() == null || event.getState().func_177230_c() != this) {
            return;
        }
        String resource = Types.Vanilla.byMetadata(event.getState().func_177230_c().func_176201_c(event.getState())).getResource();
        event.getHarvester().func_146105_b((ITextComponent)new TextComponentString("You break the sample to find " + resource), true);
        event.getDrops().clear();
    }

    public class ItemBlockOre
    extends ItemBlock {
        ItemBlockOre(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
            this.func_77656_e(0);
            this.registerModels();
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + Types.Vanilla.byMetadata(stack.func_77960_j()).func_176610_l();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < Types.Vanilla.values().length; ++i) {
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        private void registerModels() {
            for (int i = 0; i < Types.Vanilla.values().length; ++i) {
                Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), VARIANT.func_177701_a() + "=" + Types.Vanilla.byMetadata(i).func_176610_l());
            }
        }
    }
}

