/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.client;

import com.oitsjustjose.geolosys.Geolosys;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

@SideOnly(value=Side.CLIENT)
public class TranslationManager {
    private static TranslationManager instance;
    private HashMap<String, HashMap<String, String>> translations = new HashMap();

    private TranslationManager() {
        this.loadLanguages();
    }

    private void loadLanguages() {
        Geolosys.getInstance().LOGGER.info("Caching languages");
        for (Language lang : Minecraft.func_71410_x().func_135016_M().func_135040_d()) {
            this.translations.put(lang.func_135034_a(), new HashMap());
            if (!lang.func_135034_a().contains("_")) {
                Geolosys.getInstance().LOGGER.info("Couldn't find langfile " + lang.func_135034_a() + ", looks like Mojang messed up. This language's translations may not work correctly.");
                continue;
            }
            InputStream in = Geolosys.class.getResourceAsStream("/assets/geolosys/lang/" + lang.func_135034_a().substring(0, lang.func_135034_a().indexOf("_")) + lang.func_135034_a().substring(lang.func_135034_a().indexOf("_")).toUpperCase() + ".lang");
            if (in == null) continue;
            try {
                for (String s : IOUtils.readLines((InputStream)in, (String)"utf-8")) {
                    if (!s.contains("=")) continue;
                    this.translations.get(lang.func_135034_a()).put(s.substring(0, s.indexOf("=")), s.substring(s.indexOf("=") + 1));
                }
            }
            catch (IOException iOException) {
            }
        }
        Geolosys.getInstance().LOGGER.info("Done caching languages!");
    }

    public String translate(String untranslated) {
        if (this.translations.containsKey(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a()) && this.translations.get(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a()).containsKey(untranslated)) {
            return this.translations.get(Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a()).get(untranslated);
        }
        return this.translations.get("en_us").get(untranslated);
    }

    public static void init() {
        instance = new TranslationManager();
    }

    public static TranslationManager getInstance() {
        return instance;
    }
}

