/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.container;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.ContainerPipe;
import buildcraft.lib.misc.data.IdAllocator;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.ActionWrapper;
import buildcraft.lib.statement.StatementWrapper;
import buildcraft.lib.statement.TriggerWrapper;
import buildcraft.silicon.gate.GateContext;
import buildcraft.silicon.gate.GateLogic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ContainerGate
extends ContainerPipe {
    protected static final IdAllocator IDS = ContainerBC_Neptune.IDS.makeChild("gate");
    public static final int ID_CONNECTION = IDS.allocId("CONNECTION");
    public static final int ID_VALID_STATEMENTS = IDS.allocId("VALID_STATEMENTS");
    public final GateLogic gate;
    public final int slotHeight;
    public final SortedSet<TriggerWrapper> possibleTriggers;
    public final SortedSet<ActionWrapper> possibleActions;
    public final GateContext<TriggerWrapper> possibleTriggersContext;
    public final GateContext<ActionWrapper> possibleActionsContext;

    public ContainerGate(EntityPlayer player, GateLogic logic) {
        super(player, logic.getPipeHolder());
        this.gate = logic;
        this.gate.getPipeHolder().onPlayerOpen(player);
        boolean split = this.gate.isSplitInTwo();
        int s = this.gate.variant.numSlots;
        if (split) {
            s = (int)Math.ceil((double)s / 2.0);
        }
        this.slotHeight = s;
        if (this.gate.getPipeHolder().getPipeWorld().field_72995_K) {
            this.possibleTriggers = new TreeSet<TriggerWrapper>();
            this.possibleActions = new TreeSet<ActionWrapper>();
        } else {
            this.possibleTriggers = this.gate.getAllValidTriggers();
            this.possibleActions = this.gate.getAllValidActions();
        }
        this.possibleTriggersContext = new GateContext(new ArrayList());
        this.possibleActionsContext = new GateContext(new ArrayList());
        this.refreshPossibleGroups();
        this.addFullPlayerInventory(33 + this.slotHeight * 18);
    }

    public IdAllocator getIdAllocator() {
        return IDS;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.gate.getPipeHolder().onPlayerClose(player);
    }

    private void refreshPossibleGroups() {
        ContainerGate.refresh(this.possibleActions, this.possibleActionsContext);
        ContainerGate.refresh(this.possibleTriggers, this.possibleTriggersContext);
    }

    private static <T extends StatementWrapper> void refresh(SortedSet<T> from, GateContext<T> to) {
        to.groups.clear();
        EnumMap<EnumPipePart, List> parts = new EnumMap<EnumPipePart, List>(EnumPipePart.class);
        for (StatementWrapper val : from) {
            parts.computeIfAbsent(val.sourcePart, p -> new ArrayList()).add(val);
        }
        List<Object> list = (ArrayList<Object>)parts.get(EnumPipePart.CENTER);
        if (list == null) {
            list = new ArrayList<Object>(1);
            list.add(null);
        } else {
            list.add(0, null);
        }
        to.groups.add(new GateContext.GateGroup(EnumPipePart.CENTER, list));
        for (EnumPipePart part : EnumPipePart.FACES) {
            list = (List)parts.get(part);
            if (list == null) continue;
            to.groups.add(new GateContext.GateGroup(part, list));
        }
    }

    public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        if (side == Side.SERVER) {
            if (id == ID_CONNECTION) {
                short index = buffer.readUnsignedByte();
                boolean to = buffer.readBoolean();
                if (index < this.gate.connections.length) {
                    this.gate.connections[index] = to;
                    this.gate.sendResolveData();
                }
            } else if (id == ID_VALID_STATEMENTS) {
                this.sendMessage(ID_VALID_STATEMENTS);
            }
        } else if (side == Side.CLIENT && id == ID_VALID_STATEMENTS) {
            TriggerWrapper wrapper;
            EnumPipePart part;
            String tag;
            int i;
            this.possibleTriggers.clear();
            this.possibleActions.clear();
            int numTriggers = buffer.readInt();
            int numActions = buffer.readInt();
            for (i = 0; i < numTriggers; ++i) {
                tag = buffer.func_150789_c(256);
                part = (EnumPipePart)buffer.func_179257_a(EnumPipePart.class);
                wrapper = TriggerWrapper.wrap((IStatement)((IStatement)StatementManager.statements.get(tag)), (EnumFacing)part.face);
                if (!this.gate.isValidTrigger((IStatement)wrapper)) continue;
                this.possibleTriggers.add(wrapper);
            }
            for (i = 0; i < numActions; ++i) {
                tag = buffer.func_150789_c(256);
                part = (EnumPipePart)buffer.func_179257_a(EnumPipePart.class);
                wrapper = ActionWrapper.wrap((IStatement)((IStatement)StatementManager.statements.get(tag)), (EnumFacing)part.face);
                if (!this.gate.isValidAction((IStatement)wrapper)) continue;
                this.possibleActions.add((ActionWrapper)wrapper);
            }
            this.refreshPossibleGroups();
        }
    }

    public void writeMessage(int id, PacketBufferBC buffer, Side side) {
        super.writeMessage(id, buffer, side);
        if (side == Side.SERVER && id == ID_VALID_STATEMENTS) {
            buffer.writeInt(this.possibleTriggers.size());
            buffer.writeInt(this.possibleActions.size());
            for (TriggerWrapper triggerWrapper : this.possibleTriggers) {
                buffer.func_180714_a(triggerWrapper.getUniqueTag());
                buffer.writeEnumValue((Enum)triggerWrapper.sourcePart);
            }
            for (ActionWrapper actionWrapper : this.possibleActions) {
                buffer.func_180714_a(actionWrapper.getUniqueTag());
                buffer.writeEnumValue((Enum)actionWrapper.sourcePart);
            }
        }
    }

    public void setConnected(int index, boolean to) {
        this.sendMessage(ID_CONNECTION, buffer -> {
            buffer.writeByte(index);
            buffer.writeBoolean(to);
        });
    }
}

