/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import hunternif.mc.atlas.registry.IRegistryEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class MarkerRegistryImpl<V extends IRegistryEntry>
implements IRegistry<ResourceLocation, V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, V> registryObjects = this.createUnderlyingMap();
    private List<V> values;
    private final ResourceLocation defaultKey;

    public MarkerRegistryImpl(ResourceLocation defaultKey) {
        this.defaultKey = defaultKey;
    }

    private Map<ResourceLocation, V> createUnderlyingMap() {
        return Maps.newHashMap();
    }

    @Nullable
    public V getObject(@Nullable ResourceLocation name) {
        IRegistryEntry value = (IRegistryEntry)this.registryObjects.get(name);
        if (value == null) {
            value = (IRegistryEntry)this.registryObjects.get(this.defaultKey);
        }
        return (V)value;
    }

    public void putObject(ResourceLocation key, V value) {
        Validate.notNull((Object)key);
        Validate.notNull(value);
        this.values = null;
        if (this.registryObjects.containsKey(key)) {
            LOGGER.debug("Adding duplicate key '" + key + "' to registry");
        }
        this.registryObjects.put(key, value);
    }

    public void register(V value) {
        ResourceLocation key = value.getRegistryName();
        this.putObject(key, value);
    }

    public Set<ResourceLocation> func_148742_b() {
        return Collections.unmodifiableSet(this.registryObjects.keySet());
    }

    @Nullable
    public V getRandomObject(Random random) {
        this.getValues();
        return (V)((IRegistryEntry)this.values.get(random.nextInt(this.values.size())));
    }

    public List<V> getValues() {
        if (this.values == null) {
            Collection<V> collection = this.registryObjects.values();
            this.values = collection.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf(collection);
        }
        return this.values;
    }

    public boolean containsKey(ResourceLocation key) {
        return this.registryObjects.containsKey(key);
    }

    public Iterator<V> iterator() {
        return this.registryObjects.values().iterator();
    }
}

