/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.ext.watcher;

import com.google.common.collect.Sets;
import hunternif.mc.atlas.ext.watcher.IStructureWatcher;
import hunternif.mc.atlas.ext.watcher.WatcherPos;
import hunternif.mc.atlas.util.Log;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class StructureWatcher {
    public static final StructureWatcher INSTANCE = new StructureWatcher();
    private final Set<IStructureWatcher> structureWatchers = Sets.newHashSet();

    public StructureWatcher() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWorldLoad(WorldEvent.Load event) {
        this.handlePotential(event.getWorld());
    }

    @SubscribeEvent
    public void onPopulateChunk(PopulateChunkEvent.Post event) {
        this.handlePotential(event.getWorld());
    }

    private void handlePotential(World world) {
        if (world.field_72995_K) {
            return;
        }
        for (IStructureWatcher watcher : this.structureWatchers) {
            NBTTagCompound structureData;
            if (!watcher.isDimensionValid(world.field_73011_w.func_186058_p()) || (structureData = watcher.getStructureData(world)) == null) continue;
            Set<Pair<WatcherPos, String>> visited = watcher.visitStructure(world, structureData);
            for (Pair<WatcherPos, String> visit : visited) {
                Log.debug("Visited %s in dimension %d at %s", visit.getRight(), world.field_73011_w.getDimension(), ((WatcherPos)visit.getLeft()).toString());
            }
        }
    }

    public void handleShutdown() {
        for (IStructureWatcher watcher : this.structureWatchers) {
            watcher.getVisited().clear();
        }
    }

    public void addWatcher(IStructureWatcher watcher) {
        if (!this.structureWatchers.contains(watcher)) {
            this.structureWatchers.add(watcher);
        }
    }
}

