/*
 * Decompiled with CFR 0.152.
 */
package phylogeny.proportionaldestructionparticles.api;

import java.util.List;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.ChiselsAndBitsAddon;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.IChiselsAndBitsAddon;
import mod.chiselsandbits.api.IMultiStateBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import phylogeny.proportionaldestructionparticles.ConfigMod;
import phylogeny.proportionaldestructionparticles.IProportionalDestructionParticleManager;
import phylogeny.proportionaldestructionparticles.ParticleManagerMod;
import phylogeny.proportionaldestructionparticles.api.ChiselsAndBitsAPIProxy;

@ChiselsAndBitsAddon
public class ChiselsAndBitsAPI
implements IChiselsAndBitsAddon {
    static IChiselAndBitsAPI api;

    public void onReadyChiselsAndBits(IChiselAndBitsAPI api) {
        ChiselsAndBitsAPI.api = api;
        ChiselsAndBitsAPIProxy.apiPresent = true;
    }

    static IBlockState getPrimaryState(World world, BlockPos pos, IBlockState state) {
        return state.func_177230_c() instanceof IMultiStateBlock ? ((IMultiStateBlock)state.func_177230_c()).getPrimaryState((IBlockAccess)world, pos) : Blocks.field_150348_b.func_176223_P();
    }

    static boolean spawnDestructionParticlesPerBit(World world, BlockPos pos, IProportionalDestructionParticleManager particleManager, double particlesPerAxis, List<AxisAlignedBB> masks) {
        IBitAccess bitAccess;
        try {
            bitAccess = api.getBitAccess(world, pos);
        }
        catch (APIExceptions.CannotBeChiseled e) {
            return false;
        }
        if (ConfigMod.CLIENT.random) {
            double volumeTotal = 1.0;
            double particlesCountTotal = particlesPerAxis * particlesPerAxis * particlesPerAxis;
            for (AxisAlignedBB mask : masks) {
                AxisAlignedBB maskOriginal = mask.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                mask = maskOriginal.func_186662_g(ConfigMod.CLIENT.boxGrowth);
                double d0 = mask.field_72336_d - mask.field_72340_a;
                double d1 = mask.field_72337_e - mask.field_72338_b;
                double d2 = mask.field_72334_f - mask.field_72339_c;
                double count = Math.round(d0 * d1 * d2 / volumeTotal * particlesCountTotal);
                mask = mask.func_186664_h(ConfigMod.CLIENT.boxGrowth);
                mask = new AxisAlignedBB(Math.max(mask.field_72340_a, 0.125), Math.max(mask.field_72338_b, 0.125), Math.max(mask.field_72339_c, 0.125), Math.min(mask.field_72336_d, 0.875), Math.min(mask.field_72337_e, 0.875), Math.min(mask.field_72334_f, 0.875));
                double dx = mask.field_72336_d - mask.field_72340_a;
                double dy = mask.field_72337_e - mask.field_72338_b;
                double dz = mask.field_72334_f - mask.field_72339_c;
                int i = 0;
                while ((double)i < count) {
                    d0 = mask.field_72340_a + dx * world.field_73012_v.nextDouble();
                    d1 = mask.field_72338_b + dy * world.field_73012_v.nextDouble();
                    d2 = mask.field_72339_c + dz * world.field_73012_v.nextDouble();
                    particleManager.addDestructionParticle(pos, bitAccess.getBitAt((int)(MathHelper.func_151237_a((double)d0, (double)maskOriginal.field_72340_a, (double)maskOriginal.field_72336_d) * 16.0), (int)(MathHelper.func_151237_a((double)d1, (double)maskOriginal.field_72338_b, (double)maskOriginal.field_72337_e) * 16.0), (int)(MathHelper.func_151237_a((double)d2, (double)maskOriginal.field_72339_c, (double)maskOriginal.field_72334_f) * 16.0)).getState(), world, d0 + (double)pos.func_177958_n(), d1 + (double)pos.func_177956_o(), d2 + (double)pos.func_177952_p(), d0 - 0.5, d1 - 0.5, d2 - 0.5);
                    ++i;
                }
            }
            return true;
        }
        int j = 0;
        while ((double)j < particlesPerAxis) {
            int k = 0;
            while ((double)k < particlesPerAxis) {
                int l = 0;
                while ((double)l < particlesPerAxis) {
                    double d0 = ((double)j + 0.5) / particlesPerAxis;
                    double d1 = ((double)k + 0.5) / particlesPerAxis;
                    double d2 = ((double)l + 0.5) / particlesPerAxis;
                    double x = d0 + (double)pos.func_177958_n();
                    double y = d1 + (double)pos.func_177956_o();
                    double z = d2 + (double)pos.func_177952_p();
                    for (AxisAlignedBB mask : masks) {
                        AxisAlignedBB maskOriginal = mask.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
                        if (!ParticleManagerMod.maskContainsVector(x, y, z, mask.func_186662_g(ConfigMod.CLIENT.boxGrowth))) continue;
                        particleManager.addDestructionParticle(pos, bitAccess.getBitAt((int)(MathHelper.func_151237_a((double)d0, (double)maskOriginal.field_72340_a, (double)maskOriginal.field_72336_d) * 16.0), (int)(MathHelper.func_151237_a((double)d1, (double)maskOriginal.field_72338_b, (double)maskOriginal.field_72337_e) * 16.0), (int)(MathHelper.func_151237_a((double)d2, (double)maskOriginal.field_72339_c, (double)maskOriginal.field_72334_f) * 16.0)).getState(), world, x, y, z, d0 - 0.5, d1 - 0.5, d2 - 0.5);
                        break;
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        return true;
    }
}

