/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.horsepower.client.renderer;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import se.gory_moon.horsepower.Configs;
import se.gory_moon.horsepower.blocks.BlockHPBase;
import se.gory_moon.horsepower.blocks.BlockPress;
import se.gory_moon.horsepower.client.model.modelvariants.PressModels;
import se.gory_moon.horsepower.client.renderer.TileEntityHPBaseRenderer;
import se.gory_moon.horsepower.tileentity.TileEntityPress;
import se.gory_moon.horsepower.util.RenderUtils;

public class TileEntityPressRender
extends TileEntityHPBaseRenderer<TileEntityPress> {
    public void render(TileEntityPress te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        BlockRendererDispatcher dispatcher = Minecraft.func_71410_x().func_175602_ab();
        IBlockState blockState = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!(blockState.func_177230_c() instanceof BlockHPBase)) {
            return;
        }
        IBlockState topState = blockState.func_177226_a(BlockPress.PART, (Comparable)((Object)PressModels.TOP));
        if (!(topState.func_177230_c() instanceof BlockHPBase)) {
            return;
        }
        IBakedModel pressModel = dispatcher.func_175023_a().func_178125_b(topState);
        this.preDestroyRender(destroyStage);
        this.setRenderSettings();
        buffer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        buffer.func_178969_c((double)(-te.func_174877_v().func_177958_n()), (double)(-te.func_174877_v().func_177956_o()), (double)(-te.func_174877_v().func_177952_p()));
        if (destroyStage >= 0) {
            buffer.func_78914_f();
            this.renderBlockDamage(topState, te.func_174877_v(), TileEntityPressRender.getDestroyBlockIcon(destroyStage), (IBlockAccess)te.func_145831_w());
        } else {
            dispatcher.func_175019_b().func_178267_a((IBlockAccess)te.func_145831_w(), pressModel, blockState, te.func_174877_v(), buffer, false);
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        float move = (float)te.getField(0) / (float)(Configs.general.pointsForPress > 0 ? Configs.general.pointsForPress : 1);
        GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179137_b((double)0.0, (double)(-(0.58 * (double)move)), (double)0.0);
        GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
        this.postDestroyRender(destroyStage);
        RenderHelper.func_74519_b();
        if (!(blockState.func_177230_c() instanceof BlockHPBase)) {
            return;
        }
        if (te.hasWorker()) {
            this.renderLeash(te.getWorker(), x, y, z, 0.0, 0.4, 0.0, partialTicks, te.func_174877_v());
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        if (!te.getStackInSlot(0).func_190926_b() && (double)move <= 0.25) {
            this.renderItem(te, te.getStackInSlot(0), 0.5f, 0.5f, 0.5f, 1.0f);
            this.drawString(te, String.valueOf(te.getStackInSlot(0).func_190916_E()), 0.0, 0.35, 0.0);
        }
        if (!te.getStackInSlot(1).func_190926_b() && (double)move <= 0.25) {
            this.renderItem(te, te.getStackInSlot(1), 0.5f, 0.5f, 0.5f, 1.0f);
            this.drawString(te, String.valueOf(te.getStackInSlot(1).func_190916_E()), 0.0, 0.35, 0.0);
        }
        GlStateManager.func_179121_F();
        IFluidTankProperties tankProperties = te.getTankFluidStack()[0];
        FluidStack stack = tankProperties.getContents();
        if (stack != null && (double)move <= 0.25) {
            float amount = 0.75f / (float)tankProperties.getCapacity() * (float)stack.amount;
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(stack.getFluid().getStill().toString());
            int fluidColor = stack.getFluid().getColor(stack);
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179137_b((double)x, (double)(y + 0.07), (double)z);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(fluidColor & 0xFF) / 255.0f;
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float xMax = 0.9f;
            float zMax = 0.9f;
            float xMin = 0.1f;
            float zMin = 0.1f;
            double uMin = sprite.func_94209_e();
            double uMax = sprite.func_94212_f();
            double vMin = sprite.func_94206_g();
            double vMax = sprite.func_94210_h();
            buffer.func_181662_b((double)xMax, (double)amount, (double)zMax).func_187315_a(uMax, vMin).func_181675_d();
            buffer.func_181662_b((double)xMax, (double)amount, (double)zMin).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b((double)xMin, (double)amount, (double)zMin).func_187315_a(uMin, vMax).func_181675_d();
            buffer.func_181662_b((double)xMin, (double)amount, (double)zMax).func_187315_a(uMax, vMin).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179094_E();
        this.drawDisplayText(te, x, y + 1.0, z);
        if (!te.isValid()) {
            RenderUtils.renderInvalidArea(te.func_145831_w(), te.func_174877_v(), 0);
        }
        GlStateManager.func_179121_F();
    }
}

