/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.ingredient;

import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;

public class IngredientInstanceWrapper<T, M>
implements Comparable<IngredientInstanceWrapper<T, M>> {
    private final IngredientComponent<T, M> component;
    private final T instance;

    public IngredientInstanceWrapper(IngredientComponent<T, M> component, T instance) {
        this.component = component;
        this.instance = instance;
    }

    public IngredientComponent<T, M> getComponent() {
        return this.component;
    }

    public T getInstance() {
        return this.instance;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IngredientInstanceWrapper)) {
            return false;
        }
        IngredientInstanceWrapper wrapper = (IngredientInstanceWrapper)obj;
        if (wrapper.getComponent() != this.getComponent()) {
            return false;
        }
        T thatInstance = wrapper.getInstance();
        IIngredientMatcher<T, M> matcher = this.getComponent().getMatcher();
        return matcher.isInstance(thatInstance) && matcher.matchesExactly(this.getInstance(), thatInstance);
    }

    public int hashCode() {
        return this.getComponent().getMatcher().hash(this.getInstance());
    }

    @Override
    public int compareTo(IngredientInstanceWrapper<T, M> o) {
        return this.getComponent().getMatcher().compare(this.getInstance(), o.getInstance());
    }
}

