/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import mcjty.immcraft.api.input.KeyType;
import mcjty.immcraft.varia.BlockTools;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.thirteen.Context;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketSendKey
implements IMessage {
    private KeyType keyType;
    private BlockPos blockPos;
    private EnumFacing side;
    private Vec3d hitVec;

    public void fromBytes(ByteBuf buf) {
        this.keyType = KeyType.values()[buf.readShort()];
        this.blockPos = NetworkTools.readPos((ByteBuf)buf);
        this.side = EnumFacing.values()[buf.readShort()];
        this.hitVec = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.keyType.ordinal());
        NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        buf.writeShort(this.side.ordinal());
        buf.writeDouble(this.hitVec.field_72450_a);
        buf.writeDouble(this.hitVec.field_72448_b);
        buf.writeDouble(this.hitVec.field_72449_c);
    }

    public PacketSendKey() {
    }

    public PacketSendKey(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public PacketSendKey(KeyType keyType) {
        this.keyType = keyType;
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver == null) {
            return;
        }
        this.blockPos = mouseOver.func_178782_a();
        if (this.blockPos == null) {
            return;
        }
        this.side = mouseOver.field_178784_b;
        this.hitVec = new Vec3d(mouseOver.field_72307_f.field_72450_a - (double)this.blockPos.func_177958_n(), mouseOver.field_72307_f.field_72448_b - (double)this.blockPos.func_177956_o(), mouseOver.field_72307_f.field_72449_c - (double)this.blockPos.func_177952_p());
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP playerEntity = ctx.getSender();
            World world = playerEntity.func_130014_f_();
            BlockTools.getTE(null, (IBlockAccess)world, this.blockPos).ifPresent(p -> p.onKeyPress(this.keyType, (EntityPlayer)playerEntity, this.side, PacketSendKey.getLocalSide(world, this), this.hitVec));
        });
        ctx.setPacketHandled(true);
    }

    private static EnumFacing getLocalSide(World world, PacketSendKey message) {
        return BlockTools.getBlock(world, message.blockPos).map(p -> p.worldToBlockSpace(world, message.blockPos, message.side)).orElse(null);
    }
}

