/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import mcjty.immcraft.ImmersiveCraft;
import mcjty.immcraft.items.BookType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class GeneralConfiguration {
    public static final String CATEGORY_GENERAL = "general";
    public static final String CATEGORY_BOOKS = "books";
    public static boolean worldgen = true;
    public static boolean rockRecipe = true;
    public static float leavesDropSticksChance = 0.1f;
    public static boolean allowRightClickPlacement = false;
    public static boolean allowMakingStoneAxe = false;
    public static float maxRenderDistance = 16.0f;
    public static double maxRenderDistanceSquared;
    public static float rockDamage;
    public static float rockStickFireChance;
    public static int worldgenStickAttemptsPerChunk;
    public static int worldgenRockAttemptsPerChunk;
    public static boolean flintOnRockMakesFlintAndSteel;
    public static boolean lightingFurnaceWithTorchConsumesTorch;
    public static boolean showDebugHandles;
    public static boolean createWorkbench;
    public static boolean willRainExtinguishTheFurnace;
    public static float basePageTurnVolume;
    public static Map<String, String> validBooks;
    public static Set<Item> validIgnitionSources;
    public static Set<Item> ignitionSourcesConsume;
    private static String[] validBlocksForRocksList;
    private static Set<IBlockState> validBlocksForRocks;
    private static String[] validBlocksForSticksList;
    private static Set<IBlockState> validBlocksForSticks;

    public static void init(Configuration cfg) {
        IForgeRegistry itemRegistry = GameRegistry.findRegistry(Item.class);
        GeneralConfiguration.setupBookConfig(cfg);
        basePageTurnVolume = (float)cfg.get(CATEGORY_GENERAL, "basePageTurnVolume", (double)basePageTurnVolume, "The volume for the page turning sound (0.0 is off)").getDouble();
        worldgen = cfg.getBoolean("worldgen", CATEGORY_GENERAL, worldgen, "Enable worldgen for rocks and sticks");
        rockRecipe = cfg.getBoolean("rockRecipe", CATEGORY_GENERAL, rockRecipe, "Enable recipe for rocks");
        rockDamage = cfg.getFloat("rockDamage", CATEGORY_GENERAL, rockDamage, 0.0f, 1000000.0f, "How much damage does a thrown rock do");
        rockStickFireChance = cfg.getFloat("rockStickFireChance", CATEGORY_GENERAL, rockStickFireChance, 0.0f, 1.0f, "The chance that right clicking a stick on a rock will start a fire");
        flintOnRockMakesFlintAndSteel = cfg.getBoolean("flintOnRockMakesFlintAndSteel", CATEGORY_GENERAL, flintOnRockMakesFlintAndSteel, "If true then right clicking a flint on a rock will make flint and steel");
        lightingFurnaceWithTorchConsumesTorch = cfg.getBoolean("lightingFurnaceWithTorchConsumesTorch", CATEGORY_GENERAL, lightingFurnaceWithTorchConsumesTorch, "If true then lighting a torch this way will consume the torch");
        allowRightClickPlacement = cfg.getBoolean("allowRightClickPlacement", CATEGORY_GENERAL, allowRightClickPlacement, "If true then right clicking a tool on a block will place it. If disabled then only the placement hotkey will work");
        allowMakingStoneAxe = cfg.getBoolean("allowMakingStoneAxe", CATEGORY_GENERAL, allowMakingStoneAxe, "If true then right clicking a rock on a stick will give a stone axe");
        leavesDropSticksChance = cfg.getFloat("leavesDropSticksChance", CATEGORY_GENERAL, leavesDropSticksChance, 0.0f, 1.0f, "Chance that destroying a leaf block will spawn sticks (0 to disable this)");
        createWorkbench = cfg.getBoolean("createWorkbench", CATEGORY_GENERAL, createWorkbench, "If true then right clicking a stone axe on two logs will create a workbench. Currently disabled because workbench isn't working properly");
        maxRenderDistance = cfg.getFloat("maxRenderDistance", CATEGORY_GENERAL, maxRenderDistance, 1.0f, 1.0E9f, "Maximum render distance for in-world items");
        maxRenderDistanceSquared = maxRenderDistance * maxRenderDistance;
        worldgenStickAttemptsPerChunk = cfg.getInt("worldgenStickAttemptsPerChunk", CATEGORY_GENERAL, worldgenStickAttemptsPerChunk, 0, 100, "Maximum amount of attempts to spawn sticks in a chunk");
        worldgenRockAttemptsPerChunk = cfg.getInt("worldgenRockAttemptsPerChunk", CATEGORY_GENERAL, worldgenRockAttemptsPerChunk, 0, 100, "Maximum amount of attempts to spawn rocks in a chunk");
        willRainExtinguishTheFurnace = cfg.getBoolean("doesRainExtinguishTheFurnace", CATEGORY_GENERAL, willRainExtinguishTheFurnace, "Will the furnace get extinguished if it's in the rain");
        String[] ignitionSourcesStr = cfg.getStringList("validIgnitionSources", CATEGORY_GENERAL, new String[]{"minecraft:flint_and_steel", "minecraft:fire_charge", "minecraft:torch"}, "What ignition sources are valid");
        String[] ignitionSourcesConsumeStr = cfg.getStringList("ignitionSourcesConsumeList", CATEGORY_GENERAL, new String[]{"minecraft:fire_charge", "minecraft:torch"}, "What ignition sources should be consumed");
        validBlocksForRocksList = cfg.getStringList("validBlocksForRocks", CATEGORY_GENERAL, validBlocksForRocksList, "All blocks where rocks can spawn on");
        validBlocksForSticksList = cfg.getStringList("validBlocksForSticks", CATEGORY_GENERAL, validBlocksForSticksList, "All blocks where sticks can spawn on");
        HashSet<String> newIgnitionSources = new HashSet<String>();
        for (String source : ignitionSourcesStr) {
            validIgnitionSources.add((Item)itemRegistry.getValue(new ResourceLocation(source)));
            newIgnitionSources.add(source);
        }
        for (String source : ignitionSourcesConsumeStr) {
            Item item = (Item)itemRegistry.getValue(new ResourceLocation(source));
            validIgnitionSources.add(item);
            ignitionSourcesConsume.add(item);
            newIgnitionSources.add(source);
        }
        cfg.get(CATEGORY_GENERAL, "validIgnitionSources", ignitionSourcesStr).set(newIgnitionSources.toArray(new String[newIgnitionSources.size()]));
    }

    public static void setupBookConfig(Configuration cfg) {
        ConfigCategory category = cfg.getCategory(CATEGORY_BOOKS);
        if (category.isEmpty()) {
            GeneralConfiguration.addBook(cfg, Items.field_151122_aG.getRegistryName().toString(), "*");
            GeneralConfiguration.addBook(cfg, Items.field_151134_bR.getRegistryName().toString(), "*");
            GeneralConfiguration.addBook(cfg, Items.field_151099_bA.getRegistryName().toString(), "*");
            GeneralConfiguration.addBook(cfg, Items.field_151164_bB.getRegistryName().toString(), "*");
            GeneralConfiguration.addBook(cfg, "rftools:rftools_manual", BookType.BOOK_BLUE.getModel());
            GeneralConfiguration.addBook(cfg, "rftoolscontrol:rftoolscontrol_manual", BookType.BOOK_GREEN.getModel());
            GeneralConfiguration.addBook(cfg, "rftoolsdim:rftoolsdim_manual", BookType.BOOK_GREEN.getModel());
            GeneralConfiguration.addBook(cfg, "deepresonance:dr_manual", BookType.BOOK_RED.getModel());
        } else {
            for (Map.Entry entry : category.entrySet()) {
                validBooks.put((String)entry.getKey(), ((Property)entry.getValue()).getString());
            }
        }
    }

    private static void addBook(Configuration cfg, String name, String type) {
        cfg.get(CATEGORY_BOOKS, name, type);
        validBooks.put(name, type);
    }

    public static Set<IBlockState> getValidBlocksForRocks() {
        if (validBlocksForRocks == null) {
            validBlocksForRocks = GeneralConfiguration.parseBlockStates(validBlocksForRocksList);
        }
        return validBlocksForRocks;
    }

    public static Set<IBlockState> getValidBlocksForSticks() {
        if (validBlocksForSticks == null) {
            validBlocksForSticks = GeneralConfiguration.parseBlockStates(validBlocksForSticksList);
        }
        return validBlocksForSticks;
    }

    private static Set<IBlockState> parseBlockStates(String[] blocksList) {
        HashSet<IBlockState> states = new HashSet<IBlockState>();
        for (String desc : blocksList) {
            String s;
            int meta = 0;
            if (desc.contains("@")) {
                String[] split = StringUtils.split((String)desc, (char)'@');
                s = split[0];
                meta = Integer.parseInt(split[1]);
            } else {
                s = desc;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
            if (block == null) {
                ImmersiveCraft.setup.getLogger().log(Level.WARN, "Block '" + s + "' is not a valid block!");
                continue;
            }
            states.add(block.func_176203_a(meta));
        }
        return states;
    }

    static {
        rockDamage = 2.0f;
        rockStickFireChance = 0.3f;
        worldgenStickAttemptsPerChunk = 30;
        worldgenRockAttemptsPerChunk = 10;
        flintOnRockMakesFlintAndSteel = true;
        lightingFurnaceWithTorchConsumesTorch = false;
        showDebugHandles = false;
        createWorkbench = false;
        willRainExtinguishTheFurnace = false;
        basePageTurnVolume = 1.0f;
        validBooks = new HashMap<String, String>();
        validIgnitionSources = Collections.newSetFromMap(new IdentityHashMap());
        ignitionSourcesConsume = Collections.newSetFromMap(new IdentityHashMap());
        validBlocksForRocksList = new String[]{"minecraft:dirt", "minecraft:stone", "minecraft:grass", "minecraft:mycelium"};
        validBlocksForRocks = null;
        validBlocksForSticksList = new String[]{"minecraft:dirt", "minecraft:grass"};
        validBlocksForSticks = null;
    }
}

