/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.compat.intwheel;

import com.google.common.base.Function;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.immcraft.ImmersiveCraft;
import mcjty.immcraft.api.generic.GenericBlock;
import mcjty.immcraft.api.generic.GenericTE;
import mcjty.immcraft.api.handles.IInterfaceHandle;
import mcjty.immcraft.api.rendering.BlockRenderHelper;
import mcjty.immcraft.compat.intwheel.HandleGetOneAction;
import mcjty.immcraft.compat.intwheel.HandlePlaceOneAction;
import mcjty.intwheel.api.IInteractionWheel;
import mcjty.intwheel.api.IWheelAction;
import mcjty.intwheel.api.IWheelActionProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import org.apache.logging.log4j.Level;

public class WheelCompatibility {
    private static boolean registered;

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        FMLInterModComms.sendFunctionMessage((String)"intwheel", (String)"getTheWheel", (String)"mcjty.immcraft.compat.intwheel.WheelCompatibility$GetTheWheel");
    }

    public static class GetTheWheel
    implements Function<IInteractionWheel, Void> {
        public static IInteractionWheel wheel;

        @Nullable
        public Void apply(IInteractionWheel theWheel) {
            wheel = theWheel;
            ImmersiveCraft.setup.getLogger().log(Level.INFO, "Enabled support for The Interaction Wheel");
            wheel.registerProvider(new IWheelActionProvider(){

                public String getID() {
                    return "immcraft.wheel";
                }

                public void updateWheelActions(@Nonnull Set<String> actions, @Nonnull EntityPlayer player, World world, @Nullable BlockPos pos) {
                    GenericTE te;
                    IInterfaceHandle selectedHandle;
                    if (pos == null) {
                        return;
                    }
                    TileEntity tileEntity = world.func_175625_s(pos);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (tileEntity instanceof GenericTE && block instanceof GenericBlock && (selectedHandle = BlockRenderHelper.getFacingInterfaceHandle(te = (GenericTE)tileEntity, (GenericBlock)block)) != null) {
                        actions.add("immcraft.getone");
                        ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
                        if (!heldItem.func_190926_b()) {
                            actions.add("immcraft.placeone");
                        }
                    }
                }
            });
            wheel.getRegistry().register((IWheelAction)new HandleGetOneAction());
            wheel.getRegistry().register((IWheelAction)new HandlePlaceOneAction());
            return null;
        }
    }
}

