/*
 * Decompiled with CFR 0.152.
 */
package mcjty.immcraft.books;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.immcraft.ImmersiveCraft;
import mcjty.immcraft.books.BookPage;
import mcjty.immcraft.books.BookSection;
import mcjty.immcraft.books.RenderSection;
import mcjty.immcraft.books.TextElementFormat;
import mcjty.immcraft.books.elements.BookElementImage;
import mcjty.immcraft.books.elements.BookElementIndent;
import mcjty.immcraft.books.elements.BookElementItem;
import mcjty.immcraft.books.elements.BookElementLink;
import mcjty.immcraft.books.elements.BookElementNewParagraph;
import mcjty.immcraft.books.elements.BookElementNewline;
import mcjty.immcraft.books.elements.BookElementRuler;
import mcjty.immcraft.books.elements.BookElementSoftSpace;
import mcjty.immcraft.books.elements.BookElementText;
import net.minecraft.client.Minecraft;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class BookParser {
    public static final int SECTION_MARGIN = 40;

    private List<BookSection> parseSections(File file) {
        FileInputStream inputstream;
        try {
            inputstream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            ImmersiveCraft.setup.getLogger().log(Level.ERROR, "Error reading file: " + file.getName());
            return Collections.emptyList();
        }
        return this.parseSections(file.getName(), inputstream);
    }

    private List<BookSection> parseSections(String name, InputStream inputstream) {
        BufferedReader br;
        try {
            br = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            ImmersiveCraft.setup.getLogger().log(Level.ERROR, "Error reading file: " + name);
            return Collections.emptyList();
        }
        ArrayList<BookSection> sections = new ArrayList<BookSection>();
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse((Reader)br);
        for (JsonElement entry : element.getAsJsonArray()) {
            JsonObject object = entry.getAsJsonObject();
            JsonElement sectionElement = object.get("section");
            BookSection section = sectionElement != null ? new BookSection(sectionElement.getAsString()) : new BookSection("");
            sections.add(section);
            JsonElement textElement = object.get("text");
            boolean lastIsText = false;
            if (textElement != null) {
                for (JsonElement textChild : textElement.getAsJsonArray()) {
                    if (!textChild.isJsonPrimitive() || !textChild.getAsJsonPrimitive().isString()) {
                        ImmersiveCraft.setup.getLogger().log(Level.WARN, "File " + name + " has a problem in section " + section.getName());
                        continue;
                    }
                    String string = textChild.getAsString();
                    if (string.equals("#")) {
                        section.addElement(new BookElementNewline());
                        lastIsText = false;
                        continue;
                    }
                    if (string.equals("#>")) {
                        section.addElement(new BookElementNewline());
                        section.addElement(new BookElementIndent());
                        lastIsText = false;
                        continue;
                    }
                    if (string.equals("##")) {
                        section.addElement(new BookElementNewParagraph());
                        lastIsText = false;
                        continue;
                    }
                    if (string.equals("#-")) {
                        section.addElement(new BookElementRuler());
                        lastIsText = false;
                        continue;
                    }
                    if (string.startsWith("#l")) {
                        lastIsText = this.parseLink(section, string);
                        continue;
                    }
                    if (string.startsWith("#i")) {
                        lastIsText = this.parseItem(section, string);
                        continue;
                    }
                    if (string.startsWith("#I")) {
                        lastIsText = this.parseImage(section, string);
                        continue;
                    }
                    if (string.startsWith("#:")) {
                        lastIsText = this.parseFormattedText(section, lastIsText, string);
                        continue;
                    }
                    lastIsText = this.handleText(section, lastIsText, string, "");
                }
            }
            if (!object.has("page")) continue;
            sections.add(new BookSection(null));
        }
        return sections;
    }

    private boolean parseLink(BookSection section, String string) {
        TextElementFormat fmt;
        String sec;
        if (string.charAt(2) == ':') {
            sec = string.substring(3);
            fmt = new TextElementFormat("");
        } else {
            sec = string.substring(4);
            fmt = new TextElementFormat(string.substring(2, 3));
        }
        fmt.setColor(EnumDyeColor.BLUE);
        section.addElement(new BookElementLink(sec, fmt));
        boolean lastIsText = true;
        return lastIsText;
    }

    private boolean parseFormattedText(BookSection section, boolean lastIsText, String string) {
        String fmtString = string.substring(2);
        if (fmtString.contains(":")) {
            int idx = fmtString.indexOf(58);
            String fmt = fmtString.substring(0, idx);
            String text = fmtString.substring(idx + 1);
            lastIsText = this.handleText(section, lastIsText, text, fmt);
        } else {
            lastIsText = this.handleText(section, lastIsText, fmtString, "");
        }
        return lastIsText;
    }

    private boolean parseImage(BookSection section, String string) {
        String regName;
        float scale;
        if (string.charAt(2) == ':') {
            scale = 1.0f;
            regName = string.substring(3);
        } else {
            scale = 0.5f + (float)(string.charAt(2) - 48) * 0.6f;
            regName = string.substring(4);
        }
        int colon = regName.lastIndexOf(58);
        if (colon != -1) {
            String[] split = StringUtils.split((String)regName.substring(colon + 1), (char)',');
            regName = regName.substring(0, colon);
            int u = BookParser.toIntSafe(split, 0, 0);
            int v = BookParser.toIntSafe(split, 1, 0);
            int w = BookParser.toIntSafe(split, 2, 16);
            int h = BookParser.toIntSafe(split, 3, 16);
            int tw = BookParser.toIntSafe(split, 4, 256);
            int th = BookParser.toIntSafe(split, 5, 256);
            section.addElement(new BookElementImage(new ResourceLocation(regName), u, v, w, h, tw, th, scale));
        }
        boolean lastIsText = false;
        return lastIsText;
    }

    private boolean parseItem(BookSection section, String string) {
        Item item;
        String regName;
        float scale;
        if (string.charAt(2) == ':') {
            scale = 1.0f;
            regName = string.substring(3);
        } else {
            scale = 0.5f + (float)(string.charAt(2) - 48) * 0.4f;
            regName = string.substring(4);
        }
        int meta = 0;
        if (regName.contains("@")) {
            String[] split = StringUtils.split((String)regName, (String)"@");
            regName = split[0];
            try {
                meta = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                ImmersiveCraft.setup.getLogger().warn("Bad metadata for item");
            }
        }
        if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(regName))) != null) {
            section.addElement(new BookElementItem(new ItemStack(item, 1, meta), scale));
        }
        boolean lastIsText = false;
        return lastIsText;
    }

    private static int toIntSafe(String[] splitted, int idx, int def) {
        try {
            return Integer.parseInt(splitted[idx]);
        }
        catch (Exception e) {
            return def;
        }
    }

    private boolean handleText(BookSection section, boolean lastIsText, String string, String fmt) {
        TextElementFormat format = new TextElementFormat(fmt);
        if (format.getAlign() == -1) {
            for (String s : StringUtils.split((String)string)) {
                if (lastIsText) {
                    section.addElement(new BookElementSoftSpace());
                }
                section.addElement(new BookElementText(s, format));
                lastIsText = true;
            }
        } else {
            section.addElement(new BookElementText(string, format));
            lastIsText = true;
        }
        return lastIsText;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BookPage> parse(ResourceLocation location, int width, int height) {
        InputStream inputstream = null;
        try {
            inputstream = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<BookSection> sections = this.parseSections("builtin", inputstream);
        ArrayList<BookPage> pages = new ArrayList<BookPage>();
        BookPage currentpage = new BookPage();
        pages.add(currentpage);
        int curh = 0;
        for (BookSection section : sections) {
            if (section.isPagebreak()) {
                currentpage = new BookPage();
                pages.add(currentpage);
                curh = 0;
                continue;
            }
            RenderSection renderSection = section.renderAtWidth(width);
            int h = renderSection.getHeight();
            if (h > height) {
                renderSection = new RenderSection(section.getName());
                BookElementText element = new BookElementText("<NO FIT: " + h + "/" + height + ">", TextElementFormat.DEFAULT);
                renderSection.addElement(element.createRenderElement(0, 0, element.getWidth(0), element.getHeight()));
                h = renderSection.getHeight();
            }
            if (curh + h > height) {
                currentpage = new BookPage();
                pages.add(currentpage);
                currentpage.addSection(renderSection);
                curh = h + 40;
                continue;
            }
            currentpage.addSection(renderSection);
            curh += h + 40;
        }
        return pages;
    }
}

